package com.provismet.dualswords.mixin;

import com.provismet.dualswords.interfaceMixin.IMixinItemRenderState;
import com.provismet.dualswords.interfaceMixin.IMixinLivingEntityRenderState;
import net.minecraft.class_10426;
import net.minecraft.class_10444;
import net.minecraft.class_11659;
import net.minecraft.class_1306;
import net.minecraft.class_3881;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_583;
import net.minecraft.class_7833;
import net.minecraft.class_989;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_989.class)
public abstract class HeldItemFeatureRendererMixin<S extends class_10426, M extends class_583<S> & class_3881> extends class_3887<S, M> {
    protected HeldItemFeatureRendererMixin(class_3883<S, M> context) {
        super(context);
    }

    @Inject(method="renderItem", at=@At(value="INVOKE", target="Lnet/minecraft/client/render/item/ItemRenderState;render(Lnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/command/OrderedRenderCommandQueue;III)V", shift=At.Shift.BEFORE))
    private void flipBlade (S entityState, class_10444 itemRenderState, class_1306 arm, class_4587 matrices, class_11659 orderedRenderCommandQueue, int light, CallbackInfo ci) {
        boolean activeItem = ((IMixinLivingEntityRenderState)entityState).dual_Swords$isUsingItem() && ((IMixinItemRenderState)itemRenderState).dual_Swords$isActive();

        if (((IMixinItemRenderState)itemRenderState).dual_Swords$shouldReverseRender()) {
            matrices.method_46416(0f, -0.25f, 0.2f);
            matrices.method_22907(class_7833.field_40714.rotationDegrees(180f));
            
            if (activeItem) {
                float armMultiplier = arm == class_1306.field_6183 ? -1f : 1f;
                matrices.method_22907(class_7833.field_40718.rotationDegrees(armMultiplier * 45f));
            }
        }
        else if (activeItem && ((IMixinItemRenderState)itemRenderState).dual_Swords$shouldFlipSpear()) {
            matrices.method_46416(0f, -0.25f, 0.2f);
            matrices.method_22907(class_7833.field_40714.rotationDegrees(180f));
        }
    }
}
