package com.provismet.dualswords.mixin;

import com.provismet.dualswords.config.DSSettings;
import com.provismet.dualswords.util.tag.DSEnchantmentTags;
import net.minecraft.class_11659;
import net.minecraft.class_1268;
import net.minecraft.class_1306;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_742;
import net.minecraft.class_759;
import net.minecraft.class_7833;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import com.provismet.dualswords.registry.DSEnchantments;

@Mixin(class_759.class)
public abstract class HeldItemRendererMixin {
    @Shadow protected abstract void applyEquipOffset (class_4587 matrices, class_1306 arm, float equipProgress);
    @Shadow protected abstract void swingArm (float swingProgress, float equipProgress, class_4587 matrices, int armX, class_1306 arm);

    @Shadow protected abstract void applySwingOffset (class_4587 matrices, class_1306 arm, float swingProgress);

    @Unique
    private void applyParryOffset (class_4587 matrices, class_1306 arm, float equipProgress) {
        float armMultiplier = arm == class_1306.field_6183 ? -1f : 1f;
        matrices.method_46416(0.5f * armMultiplier, 0f, 0.25f);
        matrices.method_22907(class_7833.field_40714.rotationDegrees(55f * (1f - equipProgress)));
        matrices.method_22907(class_7833.field_40718.rotationDegrees(armMultiplier * 125f * (1f - equipProgress)));
    }

    @Unique
    private void applyEquipOffsetUpwards (class_4587 matrices, class_1306 arm, float equipProgress) {
        float sideMultiplier = arm == class_1306.field_6183 ? 1f : -1f;
        matrices.method_46416(sideMultiplier * 0.56F, -0.52F + equipProgress * 0.6F, -0.72F);
    }

    @Redirect(
        method = "renderFirstPersonItem",
        slice = @Slice(
            from = @At(value = "INVOKE", target = "Lnet/minecraft/item/ItemStack;getUseAction()Lnet/minecraft/item/consume/UseAction;")
        ),
        at = @At(
            value = "INVOKE",
            target = "Lnet/minecraft/client/render/item/HeldItemRenderer;applyEquipOffset(Lnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/util/Arm;F)V",
            ordinal = 2
        )
    )
    private void animateParry (class_759 instance, class_4587 matrices, class_1306 arm, float equipProgress, class_742 player, float tickProgress, float pitch, class_1268 hand, float swingProgress, class_1799 item, float equipProgress1, class_4587 matrices1, class_11659 orderedRenderCommandQueue, int light) {
        if (class_1890.method_60138(item, DSEnchantmentTags.REVERSE_RENDER) && DSSettings.renderFlippedSwords()) {
            applyEquipOffsetUpwards(matrices1, arm, equipProgress1);
            applyParryOffset(matrices1, arm, equipProgress1);
        }
        else {
            this.applyEquipOffset(matrices1, arm, equipProgress1);
        }
    }

    @Inject(
        method = "renderFirstPersonItem",
        slice = @Slice(from=@At(value="INVOKE", target="Lnet/minecraft/item/ItemStack;getUseAction()Lnet/minecraft/item/consume/UseAction;")),
        at = @At(
            value = "INVOKE",
            target = "Lnet/minecraft/client/render/item/HeldItemRenderer;applyEquipOffset(Lnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/util/Arm;F)V",
            ordinal = 4,
            shift = At.Shift.AFTER
        )
    )
    private void animateLunge (class_742 player, float tickProgress, float pitch, class_1268 hand, float swingProgress, class_1799 item, float equipProgress, class_4587 matrices, class_11659 orderedRenderCommandQueue, int light, CallbackInfo ci) {
        if (class_1890.method_8225(DSEnchantments.LUNGE.getEntryOrThrow(player.method_73183().method_30349()), item) > 0) {
            matrices.method_22907(class_7833.field_40713.rotationDegrees(75f * (1 - equipProgress)));
            matrices.method_46416(0f, -0.75f, 0.75f);
        }
    }

    @Redirect(
        method = "renderFirstPersonItem",
        at = @At(
            value = "INVOKE",
            target = "Lnet/minecraft/client/render/item/HeldItemRenderer;swingArm(FFLnet/minecraft/client/util/math/MatrixStack;ILnet/minecraft/util/Arm;)V",
            ordinal = 2
        )
    )
    private void applyUpwardsEquip (class_759 instance, float swingProgress, float equipProgress, class_4587 matrices, int armX, class_1306 arm, class_742 player, float tickProgress, float pitch, class_1268 hand, float swingProgress1, class_1799 item, float equipProgress1, class_4587 matrices1, class_11659 orderedRenderCommandQueue, int light) {
        if (class_1890.method_60138(item, DSEnchantmentTags.REVERSE_RENDER) && DSSettings.renderFlippedSwords() && swingProgress == 0) {
            float f = -0.4F * class_3532.method_15374(class_3532.method_15355(swingProgress1) * (float) Math.PI);
            float g = 0.2F * class_3532.method_15374(class_3532.method_15355(swingProgress1) * (float) (Math.PI * 2));
            float h = -0.2F * class_3532.method_15374(swingProgress1 * (float) Math.PI);
            matrices1.method_46416((float)armX * f, g, h);
            this.applyEquipOffsetUpwards(matrices1, arm, equipProgress1);
            this.applySwingOffset(matrices1, arm, swingProgress1);
        }
        else this.swingArm(swingProgress1, equipProgress1, matrices1, armX, arm);
    }

    @Inject(method="renderFirstPersonItem", at=@At(value="INVOKE", target="Lnet/minecraft/client/util/math/MatrixStack;push()V", shift=At.Shift.AFTER))
    private void flipBlade (class_742 player, float tickProgress, float pitch, class_1268 hand, float swingProgress, class_1799 item, float equipProgress, class_4587 matrices, class_11659 orderedRenderCommandQueue, int light, CallbackInfo ci) {
        if (class_1890.method_60138(item, DSEnchantmentTags.REVERSE_RENDER) && DSSettings.renderFlippedSwords() && swingProgress == 0) {
            class_1306 arm = hand == class_1268.field_5808 ? player.method_6068() : player.method_6068().method_5928();
            float sideMultiplier = arm == class_1306.field_6183 ? -1f : 1f;
            matrices.method_46416(0.1f * sideMultiplier, -0.8f, -1.25f);
            matrices.method_22907(class_7833.field_40714.rotationDegrees(180f));
        }
    }
}
