package com.provismet.dualswords.mixin;

import com.mojang.datafixers.util.Pair;
import com.provismet.CombatPlusCore.enchantment.loot.context.CPCLootContext;
import com.provismet.CombatPlusCore.utility.CPCEnchantmentHelper;
import com.provismet.dualswords.DualSwordsMain;
import com.provismet.dualswords.enchantment.component.EnchantmentStoppedUsingEffect;
import com.provismet.dualswords.registry.DSEnchantmentComponentTypes;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1839;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_9698;
import net.minecraft.class_9699;
import net.minecraft.class_9721;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_1792.class)
public abstract class ItemMixin {
    @Inject(method="use", at=@At("HEAD"), cancellable=true)
    private void attemptParry (class_1937 world, class_1657 user, class_1268 hand, CallbackInfoReturnable<class_1269> cir) {
        class_1799 itemStack = user.method_5998(hand);
        if (class_1890.method_60142(itemStack, DSEnchantmentComponentTypes.USE_ACTION)) {
            user.method_6019(hand);
            cir.setReturnValue(class_1269.field_21466);
        }
    }
    
    @Inject(method="getUseAction", at=@At("HEAD"), cancellable=true)
    private void setParryAction (class_1799 itemStack, CallbackInfoReturnable<class_1839> cir) {
        Pair<String, Integer> action = class_1890.method_60174(itemStack, DSEnchantmentComponentTypes.USE_ACTION);
        if (action != null) {
            try {
                cir.setReturnValue(class_1839.valueOf(action.getFirst()));
            }
            catch (IllegalArgumentException e) {
                DualSwordsMain.LOGGER.error("Invalid use action attempted: ", e);
            }
        }
    }

    @Inject(method="finishUsing", at=@At("HEAD"))
    private void finishParrying (class_1799 itemStack, class_1937 world, class_1309 user, CallbackInfoReturnable<class_1799> cir) {
        if (world instanceof class_3218 serverWorld) {
            class_1304 slot;
            if (class_1799.method_7973(itemStack, user.method_6047())) slot = class_1304.field_6173;
            else if (class_1799.method_7973(itemStack, user.method_6079())) slot = class_1304.field_6171;
            else slot = null;

            if (slot != null) {
                CPCEnchantmentHelper.forEachEnchantment((enchantment, level, context) -> {
                    for (class_9698<class_9721> effect : enchantment.comp_349().method_60034(DSEnchantmentComponentTypes.ON_FINISHED_USING)) {
                        if (effect.method_60006(CPCLootContext.createSingleEntity(serverWorld, level, user, itemStack)))
                            effect.comp_2680().method_60220(serverWorld, level, new class_9699(itemStack, slot, user), user, user.method_73189());
                    }
                }, user, slot);
            }
        }
    }

    @Inject(method="onStoppedUsing", at=@At("HEAD"))
    private void onStoppedParrying (class_1799 itemStack, class_1937 world, class_1309 user, int remainingUseTicks, CallbackInfoReturnable<Boolean> cir) {
        if (world instanceof class_3218 serverWorld) {
            class_1304 slot;
            if (class_1799.method_7973(itemStack, user.method_6047())) slot = class_1304.field_6173;
            else if (class_1799.method_7973(itemStack, user.method_6079())) slot = class_1304.field_6171;
            else slot = null;

            if (slot != null) {
                CPCEnchantmentHelper.forEachEnchantment((enchantment, level, context) -> {
                    for (class_9698<EnchantmentStoppedUsingEffect> effect : enchantment.comp_349().method_60034(DSEnchantmentComponentTypes.ON_STOPPED_USING)) {
                        if (effect.method_60006(CPCLootContext.createSingleEntity(serverWorld, level, user, itemStack)))
                            effect.comp_2680().onStoppedUsing(serverWorld, level, new class_9699(itemStack, slot, user), user, remainingUseTicks);
                    }
                }, user, slot);
            }
        }
    }
}
