package com.provismet.dualswords.mixin;

import com.provismet.CombatPlusCore.interfaces.DualWeapon;
import com.provismet.CombatPlusCore.interfaces.MeleeWeapon;
import com.provismet.CombatPlusCore.items.component.MeleeWeaponComponent;
import com.provismet.CombatPlusCore.registries.CPCDataComponentTypes;
import com.provismet.CombatPlusCore.utility.CPCEnchantmentHelper;
import com.provismet.dualswords.DSDamageTypes;
import com.provismet.dualswords.interfaceMixin.IMixinLivingEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.List;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_5134;
import net.minecraft.class_6880;

@Mixin(value=class_1309.class, priority=999)
public abstract class LivingEntityMixin extends class_1297 implements IMixinLivingEntity {
    protected LivingEntityMixin (class_1299<?> type, class_1937 world) {
        super(type, world);
    }

    @Unique private int lungeTicks = 0;
    @Unique private class_1799 lungeWeapon = class_1799.field_8037;
    @Unique private class_1304 lungeSlot = null;

    @Shadow public abstract double getAttributeValue (class_6880<class_1320> attribute);
    @Shadow public abstract boolean method_64397 (class_3218 world, class_1282 source, float amount);

    @Override
    public void dual_Swords$setLungeTicks (class_1799 stack, class_1304 slot, int ticks) {
        this.lungeTicks = ticks;
        this.lungeWeapon = stack;
        if (this.lungeWeapon == null || this.lungeWeapon.method_7960()) this.lungeSlot = null;
        else this.lungeSlot = slot;
    }

    @Inject(method="tick", at=@At("HEAD"))
    private void applyLunge (CallbackInfo info) {
        if (this.lungeTicks > 0) {
            --this.lungeTicks;
            if (this.method_24828()) {
                this.lungeTicks = 0;
                this.lungeWeapon = class_1799.field_8037;
            }
            else if (this.method_73183() instanceof class_3218 serverWorld) {
                double deltaX = this.field_5974.method_43058() * 0.5 * class_3532.field_29844;
                double deltaZ = this.field_5974.method_43058() * 0.5 * class_3532.field_29844;

                float angle = this.field_5974.method_43057() * class_3532.field_29844 * 2f;
                double x = -class_3532.method_15374(angle) * 0.15 + this.method_23317();
                double y = this.field_5974.method_43058() - 0.5 + this.method_23323(0.5);
                double z = class_3532.method_15362(angle) * 0.15 + this.method_23321();
                serverWorld.method_65096(class_2398.field_11227, x, y, z, 3, deltaX, 0.0, deltaZ, 0.0);

                class_243 attackPos = this.method_73189().method_1019(this.method_18798().method_1029().method_1021(3));
                class_238 hitbox = class_238.method_30048(attackPos, 2.0, 0.5, 2.0).method_991(this.method_5829().method_1009(1.0, 0.5, 1.0));
                List<class_1297> others = this.method_73183().method_8335(this, hitbox);
                for (class_1297 other : others) {
                    if (other instanceof class_1309 target) {
                        this.lungeTicks = 0;
                        this.method_18799(this.method_18798().method_1021(-0.2));
                        this.field_6037 = true;

                        if ((class_1309)(Object)this instanceof class_1657 player && this.lungeSlot != null) {
                            float damage = 0f;

                            if (this.lungeWeapon.method_7909() instanceof DualWeapon dual) {
                                damage += dual.getOffhandDamage(this.lungeWeapon) * 2f;
                            }
                            else {
                                damage += this.lungeWeapon.method_58695(CPCDataComponentTypes.MELEE_WEAPON, MeleeWeaponComponent.DEFAULT).dualDamage() * 2f;
                            }

                            class_1282 lunge = DSDamageTypes.LUNGE.createDamageSource(player);
                            damage = CPCEnchantmentHelper.getDamage(serverWorld, this.lungeWeapon, target, lunge, damage);
                            float knockbackAmount = class_1890.method_60175(serverWorld, this.lungeWeapon, target, lunge, (float)this.getAttributeValue(class_5134.field_23722));
                            target.method_64397(serverWorld, lunge, damage);
                            if (knockbackAmount > 0) target.method_6005(knockbackAmount * 0.5, this.method_23317() - target.method_23317(), this.method_23321() - target.method_23321());

                            if (this.lungeWeapon.method_7909() instanceof MeleeWeapon melee) {
                                melee.postChargedHit(this.lungeWeapon, player, target);
                            }
                            CPCEnchantmentHelper.postChargedHit(serverWorld, player, target, this.lungeSlot);
                            this.lungeWeapon.method_7970(1, player, this.lungeSlot);
                        }

                        this.lungeWeapon = class_1799.field_8037;
                        break;
                    }
                }
            }
        }
    }
}
