package com.provismet.dualswords.registry;

import com.provismet.CombatPlusCore.enchantment.effect.component.BlocksAttacksComponentEntityEffect;
import com.provismet.CombatPlusCore.enchantment.effect.component.CooldownGroupComponentEntityEffect;
import com.provismet.CombatPlusCore.enchantment.effect.component.MaxUseTimeComponentEntityEffect;
import com.provismet.CombatPlusCore.enchantment.effect.doubleEntity.CodeExecutionDoubleEntityEffect;
import com.provismet.CombatPlusCore.enchantment.effect.singleEntity.CodeExecutionSingleEntityEffect;
import com.provismet.CombatPlusCore.enchantment.effect.singleEntity.SetCooldownEnchantmentEffect;
import com.provismet.CombatPlusCore.enchantment.loot.condition.singleEntity.ApplyToAttackerCondition;
import com.provismet.CombatPlusCore.enchantment.loot.condition.singleEntity.SingleEntityLambdaCondition;
import com.provismet.CombatPlusCore.registries.CPCEnchantmentComponentTypes;
import com.provismet.CombatPlusCore.utility.tag.CPCItemTags;
import com.provismet.dualswords.DualSwordsMain;
import com.provismet.dualswords.enchantment.effect.stopped.ApplyToUserEffect;
import com.provismet.dualswords.enchantment.effect.stopped.ReverseScalingCooldownEffect;

import com.provismet.dualswords.util.tag.DSDamageTypeTags;
import com.provismet.dualswords.util.tag.DSEnchantmentTags;
import com.provismet.lilylib.container.EnchantmentContainer;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_10707;
import net.minecraft.class_1839;
import net.minecraft.class_1887;
import net.minecraft.class_190;
import net.minecraft.class_2022;
import net.minecraft.class_3417;
import net.minecraft.class_6880;
import net.minecraft.class_7891;
import net.minecraft.class_8129;
import net.minecraft.class_9274;
import net.minecraft.class_9701;
import net.minecraft.class_9704;
import net.minecraft.class_9711;

public class DSEnchantments {
    public static final EnchantmentContainer PARRY = new EnchantmentContainer(
        DualSwordsMain.identifier("parry"),
        (itemLookup, enchantmentLookup, damageLookup, blockLookup, entityLookup) -> class_1887.method_60030(
            class_1887.method_58443(
                itemLookup.method_46735(CPCItemTags.OFFHAND_ENCHANTABLE),
                itemLookup.method_46735(CPCItemTags.OFFHAND_PRIMARY_ENCHANTABLE),
                5,
                3,
                class_1887.method_58441(5, 5),
                class_1887.method_58441(45, 5),
                2,
                class_9274.field_49219
            )
        ).method_60070(
            DSEnchantmentComponentTypes.USE_ACTION,
            class_1839.field_8949.name()
        ).method_60066(
            CPCEnchantmentComponentTypes.POST_BLOCK,
            new CodeExecutionDoubleEntityEffect(DualSwordsMain.identifier("parry"))
        ).method_60066(
            CPCEnchantmentComponentTypes.DATA_COMPONENT,
            new MaxUseTimeComponentEntityEffect(
                class_9704.method_60194(10)
            )
        ).method_60066(
            DSEnchantmentComponentTypes.ON_FINISHED_USING,
            new SetCooldownEnchantmentEffect(
                class_9704.method_60186(30)
            )
        ).method_60066(
            DSEnchantmentComponentTypes.ON_STOPPED_USING,
            new ReverseScalingCooldownEffect(
                class_9704.method_60186(30)
            )
        ).method_60066(
            CPCEnchantmentComponentTypes.DATA_COMPONENT,
            new BlocksAttacksComponentEntityEffect(
                class_9704.method_60186(0.1f),
                class_9704.method_60186(1f),
                List.of(new class_10707.class_10708(90.0F, Optional.empty(), 0.0F, 1.0F)),
                new class_10707.class_10709(3.0F, 1.0F, 1.0F),
                Optional.of(DSDamageTypeTags.BYPASSES_PARRY),
                Optional.of(class_6880.method_40223(class_3417.field_14706)),
                Optional.of(class_3417.field_15075)
            )
        ).method_60066(
            CPCEnchantmentComponentTypes.DATA_COMPONENT,
            new CooldownGroupComponentEntityEffect(DualSwordsMain.identifier("parry_cooldown"))
        ).method_60061(
            enchantmentLookup.method_46735(DSEnchantmentTags.PARRY_EXCLUSIVE)
        )
    );
    public static final EnchantmentContainer RIPOSTE = new EnchantmentContainer(
        DualSwordsMain.identifier("riposte"),
        (itemLookup, enchantmentLookup, damageLookup, blockLookup, entityLookup) -> class_1887.method_60030(
            class_1887.method_58443(
                itemLookup.method_46735(CPCItemTags.OFFHAND_ENCHANTABLE),
                itemLookup.method_46735(CPCItemTags.OFFHAND_PRIMARY_ENCHANTABLE),
                3,
                3,
                class_1887.method_58441(5, 5),
                class_1887.method_58441(35, 5),
                2,
                class_9274.field_49219
            )
        ).method_60067(
            class_9701.field_51661,
            new class_9711(
                class_9704.method_60194(1.5f)
            ),
            class_190.method_837(
                class_2022.class_2023.method_8855().method_48785(
                    class_8129.method_48965(DSDamageTypeTags.IS_OFFHANDED)
                )
            )
        ).method_60061(
            enchantmentLookup.method_46735(DSEnchantmentTags.PARRY_BONUS_EXCLUSIVE)
        )
    );
    public static final EnchantmentContainer DEFLECT = new EnchantmentContainer(
        DualSwordsMain.identifier("deflect"),
        (itemLookup, enchantmentLookup, damageLookup, blockLookup, entityLookup) -> class_1887.method_60030(
            class_1887.method_58443(
                itemLookup.method_46735(CPCItemTags.OFFHAND_ENCHANTABLE),
                itemLookup.method_46735(CPCItemTags.OFFHAND_PRIMARY_ENCHANTABLE),
                3,
                3,
                class_1887.method_58441(5, 5),
                class_1887.method_58441(25, 5),
                2,
                class_9274.field_49219
            )
        ).method_60066(
            DSEnchantmentComponentTypes.DEFLECTION_SPEED,
            new class_9711(
                class_9704.method_60194(3)
            )
        ).method_60061(
            enchantmentLookup.method_46735(DSEnchantmentTags.PARRY_BONUS_EXCLUSIVE)
        )
    );

    public static final EnchantmentContainer LUNGE = new EnchantmentContainer(
        DualSwordsMain.identifier("lunge"),
        (itemLookup, enchantmentLookup, damageLookup, blockLookup, entityLookup) -> class_1887.method_60030(
            class_1887.method_58443(
                itemLookup.method_46735(CPCItemTags.OFFHAND_ENCHANTABLE),
                itemLookup.method_46735(CPCItemTags.OFFHAND_PRIMARY_ENCHANTABLE),
                5,
                3,
                class_1887.method_58441(5, 5),
                class_1887.method_58441(45, 5),
                2,
                class_9274.field_49219
            )
        ).method_60070(
            DSEnchantmentComponentTypes.USE_ACTION,
            class_1839.field_8951.name()
        ).method_60066(
            DSEnchantmentComponentTypes.ON_STOPPED_USING,
            new ApplyToUserEffect(
                new CodeExecutionSingleEntityEffect(DualSwordsMain.identifier("lunge")),
                class_9704.method_60186(9)
            )
        ).method_60066(
            DSEnchantmentComponentTypes.ON_STOPPED_USING,
            new ApplyToUserEffect(
                new SetCooldownEnchantmentEffect(
                    class_9704.method_60186(60)
                ),
                class_9704.method_60186(9)
            )
        ).method_60066(
            CPCEnchantmentComponentTypes.DATA_COMPONENT,
            new MaxUseTimeComponentEntityEffect(class_9704.method_60186(72000))
        ).method_60066(
            CPCEnchantmentComponentTypes.DATA_COMPONENT,
            new CooldownGroupComponentEntityEffect(DualSwordsMain.identifier("lunge_cooldown"))
        ).method_60061(
            enchantmentLookup.method_46735(DSEnchantmentTags.LUNGE_EXCLUSIVE)
        )
    );
    public static final EnchantmentContainer THRUSTING = new EnchantmentContainer(
        DualSwordsMain.identifier("thrusting"),
        (itemLookup, enchantmentLookup, damageLookup, blockLookup, entityLookup) -> class_1887.method_60030(
            class_1887.method_58443(
                itemLookup.method_46735(CPCItemTags.OFFHAND_ENCHANTABLE),
                itemLookup.method_46735(CPCItemTags.OFFHAND_PRIMARY_ENCHANTABLE),
                3,
                2,
                class_1887.method_58441(5, 10),
                class_1887.method_58441(50, 10),
                2,
                class_9274.field_49219
            )
        ).method_60067(
            class_9701.field_51661,
            new class_9711(
                class_9704.method_60194(1.5f)
            ),
            class_190.method_837(
                class_2022.class_2023.method_8855().method_48785(
                    class_8129.method_48965(DSDamageTypeTags.IS_OFFHANDED)
                )
            )
        ).method_60061(
            enchantmentLookup.method_46735(DSEnchantmentTags.LUNGE_BONUS_EXCLUSIVE)
        )
    );
    public static final EnchantmentContainer FORCEFUL = new EnchantmentContainer(
        DualSwordsMain.identifier("forceful"),
        (itemLookup, enchantmentLookup, damageLookup, blockLookup, entityLookup) -> class_1887.method_60030(
            class_1887.method_58443(
                itemLookup.method_46735(CPCItemTags.OFFHAND_ENCHANTABLE),
                itemLookup.method_46735(CPCItemTags.OFFHAND_PRIMARY_ENCHANTABLE),
                3,
                2,
                class_1887.method_58441(5, 10),
                class_1887.method_58441(20, 10),
                4,
                class_9274.field_49219
            )
        ).method_60067(
            class_9701.field_51663,
            new class_9711(
                class_9704.method_60194(1)
            ),
            class_190.method_837(
                class_2022.class_2023.method_8855().method_48785(
                    class_8129.method_48965(DSDamageTypeTags.IS_OFFHANDED)
                )
            )
        ).method_60061(
            enchantmentLookup.method_46735(DSEnchantmentTags.LUNGE_BONUS_EXCLUSIVE)
        )
    );

    public static final EnchantmentContainer DAISHO = new EnchantmentContainer(
        DualSwordsMain.identifier("daisho"),
        (itemLookup, enchantmentLookup, damageLookup, blockLookup, entityLookup) -> class_1887.method_60030(
            class_1887.method_58443(
                itemLookup.method_46735(CPCItemTags.OFFHAND_ENCHANTABLE),
                itemLookup.method_46735(CPCItemTags.OFFHAND_PRIMARY_ENCHANTABLE),
                2,
                5,
                class_1887.method_58441(20, 5),
                class_1887.method_58441(30, 10),
                8,
                class_9274.field_49218
            )
        ).method_60067(
            CPCEnchantmentComponentTypes.BONUS_DAMAGE,
            new class_9711(
                class_9704.method_60194(0.8f)
            ),
            ApplyToAttackerCondition.builder(
                SingleEntityLambdaCondition.builder(DualSwordsMain.identifier("dual_wielder"))
            )
        ).method_60066(
            CPCEnchantmentComponentTypes.MODIFY_COOLDOWN,
            new class_9711(
                class_9704.method_60194(8)
            )
        )
    );

    public static void bootstrap (class_7891<class_1887> registerable) {
        register(registerable, PARRY);
        register(registerable, RIPOSTE);
        register(registerable, DEFLECT);
        register(registerable, LUNGE);
        register(registerable, THRUSTING);
        register(registerable, FORCEFUL);
        register(registerable, DAISHO);
    }

    private static void register (class_7891<class_1887> registerable, EnchantmentContainer container) {
        registerable.method_46838(container.getKey(), container.getBuilder(registerable).method_60060(container.getKey().method_29177()));
    }
}
