package com.provismet.dualswords.registry;

import com.provismet.CombatPlusCore.enchantment.effect.doubleEntity.CodeExecutionDoubleEntityEffect;
import com.provismet.CombatPlusCore.enchantment.effect.singleEntity.CodeExecutionSingleEntityEffect;
import com.provismet.CombatPlusCore.interfaces.DualWeapon;
import com.provismet.CombatPlusCore.items.component.MeleeWeaponComponent;
import com.provismet.CombatPlusCore.registries.CPCDataComponentTypes;
import com.provismet.CombatPlusCore.utility.CPCCallbackUtil;
import com.provismet.CombatPlusCore.utility.CPCEnchantmentHelper;
import com.provismet.CombatPlusCore.utility.CPCRegistries;
import com.provismet.CombatPlusCore.utility.tag.CPCItemTags;
import com.provismet.dualswords.DSDamageTypes;
import com.provismet.dualswords.DualSwordsMain;
import com.provismet.dualswords.interfaceMixin.IMixinLivingEntity;
import java.util.function.Predicate;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1890;
import net.minecraft.class_2378;
import net.minecraft.class_243;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_5134;

public abstract class DSLambdas {
    public static void register () {
        registerSingleEntityEffect("lunge", (world, level, context, user, pos) -> {
            if (!(user instanceof class_1657 player)) return;

            if (player.method_24828()) player.method_6082(player.method_23317(), player.method_23318() + 0.5, player.method_23321(), false);
            double dx = -class_3532.method_15374(user.method_5791() / class_3532.field_29848);
            double dz = class_3532.method_15362(user.method_5791() / class_3532.field_29848);
            class_243 velocity = new class_243(dx, 0.0, dz).method_1021(0.5 * level);
            player.method_60491(velocity);
            player.field_6037 = true;
            ((IMixinLivingEntity)player).dual_Swords$setLungeTicks(context.comp_2682(), context.comp_2683(), 30);
            player.method_73183().method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_14706, class_3419.field_15248, 1f, 1f);
            context.comp_2682().method_7970(1, player, player.method_6058().method_73186());
        });

        registerSingleEntityCondition("dual_wielder", entity -> {
            if (entity instanceof class_1309 living) return living.method_6047().method_31573(CPCItemTags.DUAL_WEAPON) && living.method_6079().method_31573(CPCItemTags.DUAL_WEAPON);
            return false;
        });

        registerDoubleEntityEffect("parry", (world, level, context, user, attacker, pos) -> {
            if (user instanceof class_1657 player) {
                if (attacker instanceof class_1309 target) {
                    if (player.method_5739(target) <= player.method_45325(class_5134.field_47759)) {
                        class_1282 riposte = DSDamageTypes.RIPOSTE.createDamageSource(player);

                        float itemDamage = 0f;
                        if (context.comp_2682().method_7909() instanceof DualWeapon dual) {
                            itemDamage = dual.getOffhandDamage(context.comp_2682()) * 1.2f;
                        }
                        else {
                            itemDamage += context.comp_2682().method_58695(CPCDataComponentTypes.MELEE_WEAPON, MeleeWeaponComponent.DEFAULT).dualDamage() * 1.2f;
                        }

                        float finalDamage = CPCEnchantmentHelper.getDamage(world, context.comp_2682(), target, riposte, itemDamage);
                        target.method_64397(world, riposte, finalDamage);
                        float knockback = class_1890.method_60175(world, context.comp_2682(), target, riposte, (float) player.method_45325(class_5134.field_23722));
                        target.method_6005(knockback * 0.5, class_3532.method_15374(player.method_36454() * ((float) Math.PI / 180)), -class_3532.method_15362(player.method_36454() * ((float) Math.PI / 180)));
                        CPCCallbackUtil.postChargedHit(world, context.comp_2682(), context.comp_2683(), player, target);
                    }
                    context.comp_2682().method_7970(1, player, player.method_6058().method_73186()); // Do not use posthit, it ONLY breaks the mainhand.
                }
                else if (attacker instanceof class_1665 persistentProjectile) {
                    float deflectionLevel = CPCEnchantmentHelper.modifyValue(DSEnchantmentComponentTypes.DEFLECTION_SPEED, world, context.comp_2682(), player, 1);
                    persistentProjectile.method_18799(persistentProjectile.method_18798().method_1021(deflectionLevel)); // This gets multiplied by -0.1 in onEntityHit();
                }
                player.method_7263();
                player.field_6222 = 1;
            }
        });
    }

    private static void registerSingleEntityEffect (String name, CodeExecutionSingleEntityEffect.Lambda lambda) {
        class_2378.method_10230(CPCRegistries.SINGLE_ENTITY_LAMBDA, DualSwordsMain.identifier(name), lambda);
    }

    private static void registerSingleEntityCondition (String name, Predicate<class_1297> predicate) {
        class_2378.method_10230(CPCRegistries.SINGLE_ENTITY_LAMBDA_CONDITION, DualSwordsMain.identifier(name), predicate);
    }

    private static void registerDoubleEntityEffect (String name, CodeExecutionDoubleEntityEffect.Lambda lambda) {
        class_2378.method_10230(CPCRegistries.DOUBLE_ENTITY_LAMBDA, DualSwordsMain.identifier(name), lambda);
    }
}
