package com.provismet.dualswords.util.event;

import com.provismet.dualswords.registry.DSEnchantments;
import com.provismet.dualswords.util.tag.DSEnchantmentTags;
import net.fabricmc.fabric.api.item.v1.EnchantmentEvents;
import net.fabricmc.fabric.api.util.TriState;

public abstract class EnchantmentEventHandler {
    public static void registerAllowEnchanting () {
        EnchantmentEvents.ALLOW_ENCHANTING.register((enchantment, target, enchantingContext) -> {
            if (enchantment.method_40220(DSEnchantmentTags.REQUIRES_PARRY) && target.method_58657().method_57534().stream().noneMatch(entry -> entry.method_40225(DSEnchantments.PARRY.getKey()))) {
                return TriState.FALSE;
            }
            else if (enchantment.method_40220(DSEnchantmentTags.REQUIRES_LUNGE) && target.method_58657().method_57534().stream().noneMatch(entry -> entry.method_40225(DSEnchantments.LUNGE.getKey()))) {
                return TriState.FALSE;
            }
            return TriState.DEFAULT;
        });
    }
}
