package com.provismet.dualswords.util.event;

import com.provismet.CombatPlusCore.interfaces.DualWeapon;
import com.provismet.CombatPlusCore.items.component.MeleeWeaponComponent;
import com.provismet.CombatPlusCore.registries.CPCDataComponentTypes;
import com.provismet.CombatPlusCore.utility.item.AttributeIdentifiers;
import com.provismet.CombatPlusCore.utility.tag.CPCItemTags;
import com.provismet.dualswords.DualSwordsMain;
import com.provismet.lilylib.util.MoreMath;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.item.v1.DefaultItemComponentEvents;
import net.minecraft.class_1322;
import net.minecraft.class_2960;
import net.minecraft.class_5134;
import net.minecraft.class_9274;
import net.minecraft.class_9285;
import net.minecraft.class_9334;

public abstract class ItemEvents {
    public static final class_2960 POST_DEFAULT = DualSwordsMain.identifier("post_default");

    public static void RegisterComponentPhase () {
        DefaultItemComponentEvents.MODIFY.addPhaseOrdering(Event.DEFAULT_PHASE, POST_DEFAULT);

        DefaultItemComponentEvents.MODIFY.register(POST_DEFAULT, context -> {
            context.modify(item -> true, (builder, item) -> {
                if (item instanceof DualWeapon dualWeapon) {
                    class_9285 component = builder
                        .getOrDefault(class_9334.field_49636, class_9285.field_49326)
                        .method_57484(
                            class_5134.field_23721,
                            new class_1322(
                                AttributeIdentifiers.OFFHAND_DAMAGE,
                                dualWeapon.getOffhandDamage(item.method_7854()),
                                class_1322.class_1323.field_6328
                            ),
                            class_9274.field_49218
                        );

                    builder.method_57840(class_9334.field_49636, component);
                }
                else {
                    MeleeWeaponComponent component = item.method_7854().method_58695(CPCDataComponentTypes.MELEE_WEAPON, MeleeWeaponComponent.DEFAULT);
                    if (!component.isDual()) return;

                    class_9285 attributes = builder
                        .getOrDefault(class_9334.field_49636, class_9285.field_49326)
                        .method_57484(
                            class_5134.field_23721,
                            new class_1322(
                                AttributeIdentifiers.OFFHAND_DAMAGE,
                                component.dualDamage(),
                                class_1322.class_1323.field_6328
                            ),
                            class_9274.field_49218
                        );

                    builder.method_57840(class_9334.field_49636, attributes);
                }
            });
        });
    }
}
