/*
 * Decompiled with CFR 0.152.
 */
package dev.losterixx.simpleTimber;

import dev.losterixx.simpleTimber.libs.YamlDocument;
import dev.losterixx.simpleTimber.utils.ConfigManager;
import dev.losterixx.simpleTimber.utils.RegisterManager;
import dev.losterixx.simpleTimber.utils.UpdateChecker;
import dev.losterixx.simpleTimber.utils.bStats.Metrics;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0005H\u0016J\u0006\u0010\u0007\u001a\u00020\u0005J\u0006\u0010\b\u001a\u00020\u0005J\u0006\u0010\t\u001a\u00020\nJ\u0006\u0010\u000b\u001a\u00020\u0005\u00a8\u0006\r"}, d2={"Ldev/losterixx/simpleTimber/Main;", "Lorg/bukkit/plugin/java/JavaPlugin;", "<init>", "()V", "onEnable", "", "onDisable", "loadConfigFiles", "loadLangFiles", "isLatestVersion", "", "updateConfigs", "Companion", "SimpleTimber"})
@SourceDebugExtension(value={"SMAP\nMain.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Main.kt\ndev/losterixx/simpleTimber/Main\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,128:1\n1869#2,2:129\n*S KotlinDebug\n*F\n+ 1 Main.kt\ndev/losterixx/simpleTimber/Main\n*L\n86#1:129,2\n*E\n"})
public final class Main
extends JavaPlugin {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static Main instance;
    @NotNull
    public static final String DEFAULT_PREFIX = "<#DB9438><b>STimber</b> <dark_gray>\u26a1 <gray>";
    @NotNull
    private static final MiniMessage miniMessage;

    public void onEnable() {
        this.getLogger().info("Plugin is being enabled...");
        instance = this;
        this.loadLangFiles();
        this.loadConfigFiles();
        this.getLogger().info("Loaded " + ConfigManager.INSTANCE.getAllConfigs().size() + " configs!");
        this.updateConfigs();
        RegisterManager.INSTANCE.registerAll();
        new Metrics((Plugin)this, 25714);
        if (ConfigManager.INSTANCE.getConfig("config").getBoolean("updateChecker.consoleMessage").booleanValue()) {
            this.getServer().getScheduler().runTaskAsynchronously((Plugin)Companion.getInstance(), () -> Main.onEnable$lambda$0(this));
        }
        this.getLogger().info("Plugin has been enabled!");
    }

    public void onDisable() {
        this.getLogger().info("Plugin has been disabled!");
    }

    public final void loadConfigFiles() {
        ConfigManager.createConfig$default(ConfigManager.INSTANCE, "config", "config.yml", null, 4, null);
        this.loadLangFiles();
        String langFile = ConfigManager.INSTANCE.getConfig("config").getString("langFile", null);
        if (langFile == null) {
            this.getLogger().warning("No language file specified in config.yml! Defaulting to english.yml.");
            this.getConfig().set("langFile", (Object)"english");
            ConfigManager.INSTANCE.saveConfig("config");
        }
        Intrinsics.checkNotNull(langFile);
        ConfigManager.INSTANCE.createConfig(langFile, "lang/" + langFile + ".yml", "lang");
        this.getLogger().info("Using language file: " + langFile + ".yml");
    }

    public final void loadLangFiles() {
        Path langDirectory = this.getDataFolder().toPath().resolve("lang");
        if (!Files.exists(langDirectory, new LinkOption[0])) {
            Files.createDirectories(langDirectory, new FileAttribute[0]);
        }
        String[] stringArray = new String[]{"english.yml", "german.yml"};
        List<String> defaultLangFiles = CollectionsKt.listOf(stringArray);
        Iterable $this$forEach$iv = defaultLangFiles;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String fileName = (String)element$iv;
            boolean bl = false;
            String langConfig = StringsKt.removeSuffix(fileName, (CharSequence)".yml");
            ConfigManager.INSTANCE.createConfig(langConfig, "lang/" + fileName, "lang");
        }
        Files.list(langDirectory).filter(arg_0 -> Main.loadLangFiles$lambda$3(Main::loadLangFiles$lambda$2, arg_0)).forEach(arg_0 -> Main.loadLangFiles$lambda$5(Main::loadLangFiles$lambda$4, arg_0));
    }

    public final boolean isLatestVersion() {
        String string = this.getDescription().getVersion();
        Intrinsics.checkNotNullExpressionValue(string, "getVersion(...)");
        String currentVersion = string;
        String latestVersion = UpdateChecker.INSTANCE.getLatestModrinthRelease("simpletimber");
        return latestVersion != null && Intrinsics.areEqual(latestVersion, currentVersion);
    }

    public final void updateConfigs() {
        YamlDocument config = ConfigManager.INSTANCE.getConfig("config");
        Integer configFileVersion = config.getInt("file-version", (Integer)1);
        if (configFileVersion < 2) {
            config.set("respectUnbreaking", (Object)true);
            config.set("file-version", (Object)2);
            ConfigManager.INSTANCE.saveConfig("config");
            this.getLogger().info("Updated config.yml to version 2! Regenerate file to see new comments.");
        } else if (configFileVersion < 3) {
            List<String> list = config.getStringList("validTools");
            Intrinsics.checkNotNullExpressionValue(list, "getStringList(...)");
            Set validTools = CollectionsKt.toMutableSet((Iterable)list);
            if (!validTools.contains("COPPER_AXE")) {
                validTools.add("COPPER_AXE");
                config.set("validTools", CollectionsKt.toList(validTools));
            }
            config.set("file-version", (Object)3);
            ConfigManager.INSTANCE.saveConfig("config");
            this.getLogger().info("Updated config.yml to version 3.");
        }
    }

    private static final void onEnable$lambda$0(Main this$0) {
        if (!this$0.isLatestVersion()) {
            this$0.getLogger().warning("You are not using the latest version of SimpleTimber! Please update to the latest version.");
            this$0.getLogger().warning("Latest version: " + UpdateChecker.INSTANCE.getLatestModrinthRelease("simpletimber"));
            this$0.getLogger().warning("Your version: " + this$0.getDescription().getVersion());
        } else {
            this$0.getLogger().info("You are using the latest version of SimpleTimber!");
        }
    }

    private static final boolean loadLangFiles$lambda$2(Path it) {
        return StringsKt.endsWith$default(((Object)it).toString(), ".yml", false, 2, null);
    }

    private static final boolean loadLangFiles$lambda$3(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Unit loadLangFiles$lambda$4(Path langFile) {
        String langConfig = StringsKt.removeSuffix(((Object)langFile.getFileName()).toString(), (CharSequence)".yml");
        if (!ConfigManager.INSTANCE.existsConfig(langConfig)) {
            ConfigManager.INSTANCE.createConfig(langConfig, "lang/" + langFile.getFileName(), "lang");
        }
        return Unit.INSTANCE;
    }

    private static final void loadLangFiles$lambda$5(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    static {
        MiniMessage miniMessage = MiniMessage.miniMessage();
        Intrinsics.checkNotNullExpressionValue(miniMessage, "miniMessage(...)");
        Main.miniMessage = miniMessage;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001e\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\u00070\f\u00a2\u0006\u0002\b\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Ldev/losterixx/simpleTimber/Main$Companion;", "", "<init>", "()V", "value", "Ldev/losterixx/simpleTimber/Main;", "instance", "getInstance", "()Ldev/losterixx/simpleTimber/Main;", "DEFAULT_PREFIX", "", "miniMessage", "Lnet/kyori/adventure/text/minimessage/MiniMessage;", "Lorg/jetbrains/annotations/NotNull;", "getMiniMessage", "()Lnet/kyori/adventure/text/minimessage/MiniMessage;", "SimpleTimber"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Main getInstance() {
            Main main = instance;
            if (main != null) {
                return main;
            }
            Intrinsics.throwUninitializedPropertyAccessException("instance");
            return null;
        }

        @NotNull
        public final MiniMessage getMiniMessage() {
            return miniMessage;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

