/*
 * Decompiled with CFR 0.152.
 */
package dev.losterixx.simpleTimber.listeners;

import dev.losterixx.simpleTimber.Main;
import dev.losterixx.simpleTimber.libs.YamlDocument;
import dev.losterixx.simpleTimber.utils.ConfigManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.Grouping;
import kotlin.collections.GroupingKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.block.Block;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\t\u001a\u00020\nH\u0002J\b\u0010\u000b\u001a\u00020\nH\u0002J\b\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0007J\f\u0010\u0015\u001a\u00020\u0016*\u00020\u0017H\u0002J\f\u0010\u0018\u001a\u00020\u0016*\u00020\u0017H\u0002J\f\u0010\u0019\u001a\u00020\u0016*\u00020\u001aH\u0002J\f\u0010\u001b\u001a\u00020\u0016*\u00020\u0017H\u0002J\u001e\u0010\u001c\u001a\u00020\u001d*\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u00162\b\b\u0002\u0010\u001f\u001a\u00020\u001dH\u0002J&\u0010 \u001a\u00020\u001d*\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u00162\u0006\u0010!\u001a\u00020\u001d2\b\b\u0002\u0010\u001f\u001a\u00020\u001dH\u0002J\f\u0010\"\u001a\u00020\u001d*\u00020#H\u0002J\u001c\u0010$\u001a\u00020\u0012*\u00020#2\u0006\u0010%\u001a\u00020\u001a2\u0006\u0010&\u001a\u00020\u001dH\u0002J\u000e\u0010'\u001a\b\u0012\u0004\u0012\u00020)0(H\u0002J\u001c\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00170(*\u00020\u00172\b\b\u0002\u0010\u001f\u001a\u00020\u001dH\u0002J\f\u0010+\u001a\u00020\u0017*\u00020\u0017H\u0002J\u001c\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00170(2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00170(H\u0002R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Ldev/losterixx/simpleTimber/listeners/TimberListener;", "Lorg/bukkit/event/Listener;", "<init>", "()V", "mm", "Lnet/kyori/adventure/text/minimessage/MiniMessage;", "Lorg/jetbrains/annotations/NotNull;", "main", "Ldev/losterixx/simpleTimber/Main;", "getConfig", "Ldev/losterixx/simpleTimber/libs/YamlDocument;", "getMessages", "getPrefix", "", "logToSapling", "", "Lorg/bukkit/Material;", "onBlockBreak", "", "event", "Lorg/bukkit/event/block/BlockBreakEvent;", "isLog", "", "Lorg/bukkit/block/Block;", "isLeaf", "isUsingAxe", "Lorg/bukkit/entity/Player;", "isTree", "breakConnectedLogs", "", "breakLeaves", "limit", "breakTreeAnimated", "delay", "getRemainingDurability", "Lorg/bukkit/inventory/ItemStack;", "reduceDurability", "player", "amount", "getAllDirections3D", "", "Lorg/bukkit/util/Vector;", "collectTreeLogs", "getTreeBottom", "findSaplingSpots", "logs", "SimpleTimber"})
@SourceDebugExtension(value={"SMAP\nTimberListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TimberListener.kt\ndev/losterixx/simpleTimber/listeners/TimberListener\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,311:1\n1550#2:312\n1869#2,2:314\n1563#2:316\n1634#2,3:317\n1669#2,8:320\n1869#2,2:328\n1869#2,2:330\n1869#2,2:332\n1617#2,9:334\n1869#2:343\n1870#2:345\n1626#2:346\n1869#2,2:347\n1#3:313\n1#3:344\n*S KotlinDebug\n*F\n+ 1 TimberListener.kt\ndev/losterixx/simpleTimber/listeners/TimberListener\n*L\n75#1:312\n130#1:314,2\n145#1:316\n145#1:317,3\n146#1:320,8\n177#1:328,2\n211#1:330,2\n276#1:332,2\n305#1:334,9\n305#1:343\n305#1:345\n305#1:346\n96#1:347,2\n305#1:344\n*E\n"})
public final class TimberListener
implements Listener {
    @NotNull
    private final MiniMessage mm = Main.Companion.getMiniMessage();
    @NotNull
    private final Main main = Main.Companion.getInstance();
    @NotNull
    private final Map<String, Material> logToSapling;

    public TimberListener() {
        Pair[] pairArray = new Pair[]{TuplesKt.to("OAK_LOG", Material.OAK_SAPLING), TuplesKt.to("BIRCH_LOG", Material.BIRCH_SAPLING), TuplesKt.to("SPRUCE_LOG", Material.SPRUCE_SAPLING), TuplesKt.to("JUNGLE_LOG", Material.JUNGLE_SAPLING), TuplesKt.to("ACACIA_LOG", Material.ACACIA_SAPLING), TuplesKt.to("DARK_OAK_LOG", Material.DARK_OAK_SAPLING), TuplesKt.to("CHERRY_LOG", Material.CHERRY_SAPLING), TuplesKt.to("PALE_OAK_LOG", Material.PALE_OAK_LOG)};
        this.logToSapling = MapsKt.mapOf(pairArray);
    }

    private final YamlDocument getConfig() {
        return ConfigManager.INSTANCE.getConfig("config");
    }

    private final YamlDocument getMessages() {
        String string = this.getConfig().getString("langFile", "english");
        Intrinsics.checkNotNullExpressionValue(string, "getString(...)");
        return ConfigManager.INSTANCE.getConfig(string);
    }

    private final String getPrefix() {
        String string = this.getConfig().getString("prefix");
        if (string == null) {
            string = "<#DB9438><b>STimber</b> <dark_gray>\u26a1 <gray>";
        }
        return string;
    }

    @EventHandler
    public final void onBlockBreak(@NotNull BlockBreakEvent event) {
        int broken;
        Map.Entry entry;
        Object v6;
        boolean unbreakable;
        boolean creative;
        Intrinsics.checkNotNullParameter(event, "event");
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
        Player player2 = player;
        Block block = event.getBlock();
        Intrinsics.checkNotNullExpressionValue(block, "getBlock(...)");
        Block block2 = block;
        ItemStack itemStack = player2.getInventory().getItemInMainHand();
        Intrinsics.checkNotNullExpressionValue(itemStack, "getItemInMainHand(...)");
        ItemStack item = itemStack;
        if (!this.getConfig().getBoolean("enabled").booleanValue()) {
            return;
        }
        if (this.getConfig().getBoolean("sneakPrevent").booleanValue() && player2.isSneaking()) {
            return;
        }
        if (!this.isLog(block2)) {
            return;
        }
        if (!this.isUsingAxe(player2)) {
            return;
        }
        if (!this.isTree(block2)) {
            return;
        }
        Block bottom = this.getTreeBottom(block2);
        if (!(Intrinsics.areEqual(block2, bottom) || Intrinsics.areEqual(block2, bottom.getRelative(0, 1, 0)) || Intrinsics.areEqual(block2, bottom.getRelative(0, 2, 0)))) {
            return;
        }
        boolean bl = creative = player2.getGameMode() == GameMode.CREATIVE;
        if (!this.getConfig().getBoolean("allowCreativeMode").booleanValue() && creative) {
            return;
        }
        Integer limit = this.getConfig().getInt("maxChopLimit", (Integer)1000);
        Intrinsics.checkNotNull(limit);
        int logsToChop = this.collectTreeLogs(block2, limit).size();
        int durability = this.getRemainingDurability(item);
        ItemMeta itemMeta = item.getItemMeta();
        boolean bl2 = itemMeta != null ? itemMeta.isUnbreakable() : (unbreakable = false);
        if (logsToChop > durability && this.getConfig().getBoolean("reduceDurability").booleanValue() && !creative && !unbreakable) {
            player2.sendMessage(this.mm.deserialize((Object)(this.getPrefix() + this.getMessages().getString("listeners.treeCutting.axeTooWeak"))));
            return;
        }
        Set<Block> fullLogSet = this.collectTreeLogs(block2, limit);
        Set saplingSpots = this.getConfig().getBoolean("autoReplantSaplings", (Boolean)false) != false ? this.findSaplingSpots(fullLogSet) : SetsKt.emptySet();
        Iterable $this$groupingBy$iv = TimberListener.collectTreeLogs$default(this, bottom, 0, 1, null);
        boolean $i$f$groupingBy22 = false;
        Iterable $i$f$groupingBy22 = GroupingKt.eachCount((Grouping)new Grouping<Block, Material>($this$groupingBy$iv){
            final /* synthetic */ Iterable $this_groupingBy;
            {
                this.$this_groupingBy = $receiver;
            }

            public Iterator<Block> sourceIterator() {
                return this.$this_groupingBy.iterator();
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public Object keyOf(Object element) {
                Block it = (Block)element;
                boolean bl = false;
                return it.getType();
            }
        }).entrySet();
        Iterator iterator2 = $i$f$groupingBy22.iterator();
        if (!iterator2.hasNext()) {
            v6 = null;
        } else {
            Object t = iterator2.next();
            if (!iterator2.hasNext()) {
                v6 = t;
            } else {
                Map.Entry it = (Map.Entry)t;
                boolean bl3 = false;
                int n = ((Number)it.getValue()).intValue();
                do {
                    Object t2 = iterator2.next();
                    Map.Entry it2 = (Map.Entry)t2;
                    $i$a$-maxByOrNull-TimberListener$onBlockBreak$logType$2 = false;
                    int n2 = ((Number)it2.getValue()).intValue();
                    if (n >= n2) continue;
                    t = t2;
                    n = n2;
                } while (iterator2.hasNext());
                v6 = t;
            }
        }
        if ((entry = (Map.Entry)v6) == null || (entry = (Material)entry.getKey()) == null) {
            Material material = block2.getType();
            entry = material;
            Intrinsics.checkNotNullExpressionValue(material, "getType(...)");
        }
        Map.Entry logType = entry;
        Boolean breakLeaves = this.getConfig().getBoolean("breakLeaves", (Boolean)false);
        Boolean animated = this.getConfig().getBoolean("animatedBreak", (Boolean)true);
        Integer delayTicks = this.getConfig().getInt("animationDelay", (Integer)2);
        if (animated.booleanValue()) {
            Intrinsics.checkNotNull(breakLeaves);
            boolean bl4 = breakLeaves;
            Intrinsics.checkNotNull(delayTicks);
            v10 = this.breakTreeAnimated(bottom, bl4, delayTicks, limit);
        } else {
            Intrinsics.checkNotNull(breakLeaves);
            v10 = broken = this.breakConnectedLogs(bottom, breakLeaves, limit);
        }
        if (this.getConfig().getBoolean("reduceDurability").booleanValue() && !creative && !unbreakable) {
            this.reduceDurability(item, player2, broken);
        }
        if (this.getConfig().getBoolean("autoReplantSaplings", (Boolean)false).booleanValue()) {
            this.main.getServer().getScheduler().runTaskLater((Plugin)this.main, () -> TimberListener.onBlockBreak$lambda$4(this, (Material)logType, saplingSpots), 30L);
        }
    }

    private final boolean isLog(Block $this$isLog) {
        return (StringsKt.endsWith$default($this$isLog.getType().name(), "_LOG", false, 2, null) || StringsKt.endsWith$default($this$isLog.getType().name(), "_STEM", false, 2, null)) && !StringsKt.startsWith$default($this$isLog.getType().name(), "STRIPPED_", false, 2, null);
    }

    private final boolean isLeaf(Block $this$isLeaf) {
        return StringsKt.endsWith$default($this$isLeaf.getType().name(), "_LEAVES", false, 2, null) || $this$isLeaf.getType() == Material.NETHER_WART_BLOCK || $this$isLeaf.getType() == Material.WARPED_WART_BLOCK || $this$isLeaf.getType() == Material.SHROOMLIGHT;
    }

    private final boolean isUsingAxe(Player $this$isUsingAxe) {
        String tool = $this$isUsingAxe.getInventory().getItemInMainHand().getType().name();
        List<String> validTools = this.getConfig().getStringList("validTools");
        return validTools.contains(tool);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isTree(Block $this$isTree) {
        void $this$distinctBy$iv;
        void $this$mapTo$iv$iv;
        if (!this.isLog($this$isTree)) {
            return false;
        }
        Set visited = new LinkedHashSet();
        Queue queue = new LinkedList();
        queue.add($this$isTree);
        int limit = 1000;
        Material material = $this$isTree.getType();
        Intrinsics.checkNotNullExpressionValue(material, "getType(...)");
        Material logType = material;
        String leafPrefix = StringsKt.removeSuffix(StringsKt.removeSuffix(logType.name(), (CharSequence)"_LOG"), (CharSequence)"_STEM");
        Set leafDirections = new LinkedHashSet();
        while (!((Collection)queue).isEmpty()) {
            Block current = (Block)queue.poll();
            Intrinsics.checkNotNull(current);
            if (!visited.add(current)) continue;
            if (visited.size() >= limit) break;
            Iterable $this$forEach$iv = this.getAllDirections3D();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Block rel;
                Vector dir = (Vector)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue(current.getRelative(dir.getBlockX(), dir.getBlockY(), dir.getBlockZ()), "getRelative(...)");
                if (this.isLog(rel) && !visited.contains(rel) && rel.getType() == logType) {
                    queue.add(rel);
                    continue;
                }
                if (!this.isLeaf(rel) || !(StringsKt.startsWith$default(rel.getType().name(), leafPrefix, false, 2, null) || logType == Material.CRIMSON_STEM && rel.getType() == Material.NETHER_WART_BLOCK || logType == Material.WARPED_STEM && rel.getType() == Material.WARPED_WART_BLOCK) && (logType != Material.WARPED_STEM && logType != Material.CRIMSON_STEM || rel.getType() != Material.SHROOMLIGHT)) continue;
                leafDirections.add(dir);
            }
        }
        if (visited.size() < 5) {
            return false;
        }
        Iterable $this$map$iv = leafDirections;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Vector vector = (Vector)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Triple<Integer, Integer, Integer>(it.getBlockX(), it.getBlockY(), it.getBlockZ()));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$distinctBy = false;
        HashSet<String> set$iv = new HashSet<String>();
        ArrayList list$iv = new ArrayList();
        for (Object e$iv : $this$distinctBy$iv) {
            Object item$iv$iv;
            item$iv$iv = (Triple)e$iv;
            boolean bl = false;
            int x = ((Number)((Triple)item$iv$iv).component1()).intValue();
            int y = ((Number)((Triple)item$iv$iv).component2()).intValue();
            int z = ((Number)((Triple)item$iv$iv).component3()).intValue();
            String string = x != 0 ? "X" : (z != 0 ? "Z" : (y != 0 ? "Y" : ""));
            String key$iv = string;
            if (!set$iv.add(key$iv)) continue;
            list$iv.add(e$iv);
        }
        List distinctDirs = list$iv;
        return distinctDirs.size() >= 3;
    }

    private final int breakConnectedLogs(Block $this$breakConnectedLogs, boolean breakLeaves, int limit) {
        Set visited = new LinkedHashSet();
        Queue queue = new LinkedList();
        queue.add($this$breakConnectedLogs);
        int broken = 0;
        while (!((Collection)queue).isEmpty()) {
            Block current = (Block)queue.poll();
            Intrinsics.checkNotNull(current);
            if (!visited.add(current)) continue;
            if (visited.size() >= limit) break;
            current.breakNaturally();
            if (this.isLeaf(current)) {
                current.getLocation().getWorld().playSound(current.getLocation(), Sound.BLOCK_GRASS_BREAK, SoundCategory.BLOCKS, 1.0f, 1.0f);
            } else if (this.isLog(current)) {
                current.getLocation().getWorld().playSound(current.getLocation(), Sound.BLOCK_WOOD_BREAK, SoundCategory.BLOCKS, 1.0f, 1.0f);
                ++broken;
            }
            Iterable $this$forEach$iv = this.getAllDirections3D();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Block rel;
                Vector dir = (Vector)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue(current.getRelative(dir.getBlockX(), dir.getBlockY(), dir.getBlockZ()), "getRelative(...)");
                if (visited.contains(rel) || !this.isLog(rel) && (!breakLeaves || !this.isLeaf(rel))) continue;
                queue.add(rel);
            }
        }
        return broken;
    }

    static /* synthetic */ int breakConnectedLogs$default(TimberListener timberListener, Block block, boolean bl, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 1000;
        }
        return timberListener.breakConnectedLogs(block, bl, n);
    }

    private final int breakTreeAnimated(Block $this$breakTreeAnimated, boolean breakLeaves, int delay, int limit) {
        Set visited = new LinkedHashSet();
        Queue queue = new LinkedList();
        queue.add(TuplesKt.to($this$breakTreeAnimated, 0));
        int broken = 0;
        while (!((Collection)queue).isEmpty()) {
            Pair pair = (Pair)queue.poll();
            Block current = (Block)pair.component1();
            int depth = ((Number)pair.component2()).intValue();
            if (!visited.add(current)) continue;
            if (visited.size() >= limit) break;
            this.main.getServer().getScheduler().runTaskLater((Plugin)this.main, () -> TimberListener.breakTreeAnimated$lambda$9(current, this), (long)(depth * delay));
            if (this.isLog(current)) {
                ++broken;
            }
            Iterable $this$forEach$iv = this.getAllDirections3D();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Block rel;
                Vector dir = (Vector)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue(current.getRelative(dir.getBlockX(), dir.getBlockY(), dir.getBlockZ()), "getRelative(...)");
                if (visited.contains(rel)) continue;
                if (this.isLog(rel)) {
                    queue.add(TuplesKt.to(rel, depth + 1));
                    continue;
                }
                if (!breakLeaves || !this.isLeaf(rel)) continue;
                queue.add(TuplesKt.to(rel, depth + 1));
            }
        }
        return broken;
    }

    static /* synthetic */ int breakTreeAnimated$default(TimberListener timberListener, Block block, boolean bl, int n, int n2, int n3, Object object) {
        if ((n3 & 4) != 0) {
            n2 = 1000;
        }
        return timberListener.breakTreeAnimated(block, bl, n, n2);
    }

    private final int getRemainingDurability(ItemStack $this$getRemainingDurability) {
        ItemMeta itemMeta = $this$getRemainingDurability.getItemMeta();
        Damageable damageable = itemMeta instanceof Damageable ? (Damageable)itemMeta : null;
        if (damageable == null) {
            return Integer.MAX_VALUE;
        }
        Damageable meta = damageable;
        return $this$getRemainingDurability.getType().getMaxDurability() - meta.getDamage();
    }

    private final void reduceDurability(ItemStack $this$reduceDurability, Player player, int amount) {
        Object object;
        ItemMeta itemMeta = $this$reduceDurability.getItemMeta();
        Damageable damageable = itemMeta instanceof Damageable ? (Damageable)itemMeta : null;
        if (damageable == null) {
            return;
        }
        Damageable meta = damageable;
        Boolean respectUnbreaking = ConfigManager.INSTANCE.getConfig("config").getBoolean("respectUnbreaking", (Boolean)true);
        int unbreakingLevel = respectUnbreaking.booleanValue() ? ((object = $this$reduceDurability.getItemMeta()) != null && (object = object.getEnchants()) != null && (object = (Integer)object.get(Enchantment.UNBREAKING)) != null ? (Integer)object : 0) : 0;
        int actualDamage = 0;
        for (int i = 0; i < amount; ++i) {
            int it = i;
            boolean bl = false;
            double chance = 100.0 / (double)(unbreakingLevel + 1);
            if (!(Math.random() * (double)100 < chance)) continue;
            ++actualDamage;
        }
        meta.setDamage(meta.getDamage() + actualDamage);
        if (meta.getDamage() >= $this$reduceDurability.getType().getMaxDurability()) {
            player.getInventory().setItemInMainHand(null);
            player.playSound(player.getLocation(), Sound.ENTITY_ITEM_BREAK, SoundCategory.PLAYERS, 1.0f, 1.0f);
        } else {
            $this$reduceDurability.setItemMeta((ItemMeta)meta);
        }
    }

    private final Set<Vector> getAllDirections3D() {
        Set<Vector> set;
        Set<Vector> $this$getAllDirections3D_u24lambda_u2412 = set = SetsKt.createSetBuilder();
        boolean bl = false;
        for (int x = -1; x < 2; ++x) {
            for (int y = -1; y < 2; ++y) {
                for (int z = -1; z < 2; ++z) {
                    if (x == 0 && y == 0 && z == 0) continue;
                    $this$getAllDirections3D_u24lambda_u2412.add(new Vector(x, y, z));
                }
            }
        }
        return SetsKt.build(set);
    }

    private final Set<Block> collectTreeLogs(Block $this$collectTreeLogs, int limit) {
        Set visited = new LinkedHashSet();
        Set logs = new LinkedHashSet();
        Queue queue = new LinkedList();
        queue.add($this$collectTreeLogs);
        Material material = $this$collectTreeLogs.getType();
        Intrinsics.checkNotNullExpressionValue(material, "getType(...)");
        Material logType = material;
        while (!((Collection)queue).isEmpty()) {
            Block current = (Block)queue.poll();
            Intrinsics.checkNotNull(current);
            if (!visited.add(current)) continue;
            if (visited.size() >= limit) break;
            if (this.isLog(current) && current.getType() == logType) {
                logs.add(current);
            }
            Iterable $this$forEach$iv = this.getAllDirections3D();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Block rel;
                Vector dir = (Vector)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue(current.getRelative(dir.getBlockX(), dir.getBlockY(), dir.getBlockZ()), "getRelative(...)");
                if (visited.contains(rel)) continue;
                if (this.isLog(rel) && rel.getType() == logType) {
                    queue.add(rel);
                    continue;
                }
                if (!this.isLeaf(rel)) continue;
                queue.add(rel);
            }
        }
        return logs;
    }

    static /* synthetic */ Set collectTreeLogs$default(TimberListener timberListener, Block block, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 1000;
        }
        return timberListener.collectTreeLogs(block, n);
    }

    private final Block getTreeBottom(Block $this$getTreeBottom) {
        Block current = $this$getTreeBottom;
        while (true) {
            Block block = current.getRelative(0, -1, 0);
            Intrinsics.checkNotNullExpressionValue(block, "getRelative(...)");
            if (!this.isLog(block)) break;
            Intrinsics.checkNotNullExpressionValue(current.getRelative(0, -1, 0), "getRelative(...)");
        }
        return current;
    }

    /*
     * WARNING - void declaration
     */
    private final Set<Block> findSaplingSpots(Set<? extends Block> logs) {
        void $this$mapNotNullTo$iv$iv;
        Material[] materialArray = new Material[]{Material.DIRT, Material.COARSE_DIRT, Material.ROOTED_DIRT, Material.GRASS_BLOCK, Material.PODZOL};
        Set<Material> validSoils = SetsKt.setOf(materialArray);
        Iterable $this$mapNotNull$iv = logs;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Block it$iv$iv;
            Block below;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            Block log = (Block)element$iv$iv;
            boolean bl2 = false;
            Intrinsics.checkNotNullExpressionValue(log.getRelative(0, -1, 0), "getRelative(...)");
            if ((validSoils.contains(below.getType()) ? log : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return CollectionsKt.toSet((List)destination$iv$iv);
    }

    private static final void onBlockBreak$lambda$4(TimberListener this$0, Material $logType, Set $saplingSpots) {
        Material material = this$0.logToSapling.get($logType.name());
        if (material == null) {
            TimberListener $this$onBlockBreak_u24lambda_u244_u24lambda_u242 = this$0;
            boolean bl = false;
            return;
        }
        Material sapling = material;
        Iterable $this$forEach$iv = $saplingSpots;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Block spot = (Block)element$iv;
            boolean bl = false;
            spot.setType(sapling);
            spot.getWorld().playSound(spot.getLocation(), Sound.BLOCK_GRASS_PLACE, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
    }

    private static final void breakTreeAnimated$lambda$9(Block $current, TimberListener this$0) {
        $current.breakNaturally();
        if (this$0.isLeaf($current)) {
            $current.getLocation().getWorld().playSound($current.getLocation(), Sound.BLOCK_GRASS_BREAK, SoundCategory.BLOCKS, 1.0f, 1.0f);
        } else if (this$0.isLog($current)) {
            $current.getLocation().getWorld().playSound($current.getLocation(), Sound.BLOCK_WOOD_BREAK, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
    }
}

