/*
 * Decompiled with CFR 0.152.
 */
package dev.kostromdan.mods.simple_snowy_fix;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import dev.kostromdan.mods.simple_snowy_fix.SimpleSnowyFixMod;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;
import java.nio.file.Paths;

public class Config {
    public static Path CONFIG_PATH = Paths.get("config", "simple_snowy_fix_common.json");
    private boolean placeSnowOnLeavesUnderLeaves = false;

    public boolean getPlaceSnowOnLeavesUnderLeaves() {
        return this.placeSnowOnLeavesUnderLeaves;
    }

    public void setPlaceSnowOnLeavesUnderLeaves(boolean value) {
        this.placeSnowOnLeavesUnderLeaves = value;
    }

    public static Config loadConfig() {
        File configFile = CONFIG_PATH.toFile();
        if (configFile.exists()) {
            Config config;
            FileReader reader = new FileReader(configFile);
            try {
                Gson gson = new Gson();
                Config config2 = (Config)gson.fromJson((Reader)reader, Config.class);
                config = config2 != null ? config2 : new Config();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    SimpleSnowyFixMod.LOGGER.error("Error reading config file: ", (Throwable)e);
                    return new Config();
                }
                catch (JsonSyntaxException e) {
                    SimpleSnowyFixMod.LOGGER.error("Invalid JSON in config file: ", (Throwable)e);
                    return new Config();
                }
            }
            reader.close();
            return config;
        }
        Config defaultConfig = new Config();
        Config.saveConfig(defaultConfig);
        return defaultConfig;
    }

    public static void saveConfig(Config config) {
        try {
            File configFile = CONFIG_PATH.toFile();
            File parentDir = configFile.getParentFile();
            if (parentDir != null && !parentDir.exists()) {
                parentDir.mkdirs();
            }
            try (FileWriter writer = new FileWriter(configFile);){
                Gson gson = new GsonBuilder().setPrettyPrinting().create();
                gson.toJson((Object)config, (Appendable)writer);
            }
        }
        catch (IOException e) {
            SimpleSnowyFixMod.LOGGER.error("Error writing config file: ", (Throwable)e);
        }
    }
}

