/*
 * Decompiled with CFR 0.152.
 */
package me.supersanta.essential_addons.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.jvm.internal.SourceDebugExtension;
import me.supersanta.essential_addons.EssentialAddons;
import me.supersanta.essential_addons.EssentialSettings;
import me.supersanta.essential_addons.utils.EssentialUtilsKt;
import net.casual.arcade.commands.CommandTree;
import net.casual.arcade.commands.CommandUtilsKt;
import net.casual.arcade.utils.ComponentUtils;
import net.minecraft.class_2168;
import net.minecraft.class_2181;
import net.minecraft.class_2264;
import net.minecraft.class_2265;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_5218;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_7157;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\b\u0010\tJ\u001d\u0010\r\u001a\u00020\f2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00070\nH\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJ;\u0010\u0014\u001a\u00020\f2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00070\n2\b\b\u0002\u0010\u0010\u001a\u00020\u000f2\b\b\u0002\u0010\u0011\u001a\u00020\u000f2\b\b\u0002\u0010\u0013\u001a\u00020\u0012H\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015R\u001c\u0010\u0018\u001a\n \u0017*\u0004\u0018\u00010\u00160\u00168\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001a"}, d2={"Lme/supersanta/essential_addons/commands/BackupCommand;", "Lnet/casual/arcade/commands/CommandTree;", "<init>", "()V", "Lnet/minecraft/class_7157;", "buildContext", "Lcom/mojang/brigadier/builder/LiteralArgumentBuilder;", "Lnet/minecraft/class_2168;", "create", "(Lnet/minecraft/class_7157;)Lcom/mojang/brigadier/builder/LiteralArgumentBuilder;", "Lcom/mojang/brigadier/context/CommandContext;", "context", "", "backupSingleRegion", "(Lcom/mojang/brigadier/context/CommandContext;)I", "Lnet/minecraft/class_2265;", "from", "to", "Lnet/minecraft/class_3218;", "level", "backupRegions", "(Lcom/mojang/brigadier/context/CommandContext;Lnet/minecraft/class_2265;Lnet/minecraft/class_2265;Lnet/minecraft/class_3218;)I", "Ljava/time/format/DateTimeFormatter;", "kotlin.jvm.PlatformType", "DATE_FORMAT", "Ljava/time/format/DateTimeFormatter;", "EssentialAddons"})
@SourceDebugExtension(value={"SMAP\nBackupCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BackupCommand.kt\nme/supersanta/essential_addons/commands/BackupCommand\n+ 2 CommandTree.kt\nnet/casual/arcade/commands/CommandTree$Companion\n+ 3 CommandUtils.kt\nnet/casual/arcade/commands/CommandUtilsKt\n*L\n1#1,98:1\n25#2,2:99\n27#2:113\n105#3,2:101\n105#3,2:103\n105#3,4:105\n107#3,2:109\n107#3,2:111\n*S KotlinDebug\n*F\n+ 1 BackupCommand.kt\nme/supersanta/essential_addons/commands/BackupCommand\n*L\n35#1:99,2\n35#1:113\n37#1:101,2\n39#1:103,2\n41#1:105,4\n39#1:109,2\n37#1:111,2\n*E\n"})
public final class BackupCommand
implements CommandTree {
    @NotNull
    public static final BackupCommand INSTANCE = new BackupCommand();
    private static final DateTimeFormatter DATE_FORMAT = DateTimeFormatter.ofPattern("yyyy.MM.dd-HH:mm:ss");

    private BackupCommand() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public LiteralArgumentBuilder<class_2168> create(@NotNull class_7157 buildContext) {
        void $this$argument$iv;
        void $this$argument$iv2;
        void $this$argument$iv3;
        void name$iv;
        void name$iv2;
        void name$iv3;
        Intrinsics.checkNotNullParameter((Object)buildContext, (String)"buildContext");
        CommandTree.Companion companion = CommandTree.Companion;
        String name$iv4 = "backup";
        boolean $i$f$buildLiteral = false;
        LiteralArgumentBuilder root$iv = LiteralArgumentBuilder.literal((String)name$iv4);
        Intrinsics.checkNotNull((Object)root$iv);
        LiteralArgumentBuilder $this$create_u24lambda_u244 = root$iv;
        boolean bl = false;
        EssentialUtilsKt.requires((ArgumentBuilder)$this$create_u24lambda_u244, (Function0<? extends Object>)((Function0)new MutablePropertyReference0Impl(EssentialSettings.INSTANCE){

            public Object get() {
                return EssentialSettings.commandBackup;
            }

            public void set(Object value) {
                EssentialSettings.commandBackup = (String)value;
            }
        }), "command.backup");
        ArgumentBuilder argumentBuilder = (ArgumentBuilder)$this$create_u24lambda_u244;
        String string = "from";
        class_2264 class_22642 = class_2264.method_9701();
        Intrinsics.checkNotNullExpressionValue((Object)class_22642, (String)"columnPos(...)");
        ArgumentType type$iv = (ArgumentType)class_22642;
        boolean $i$f$argument = false;
        RequiredArgumentBuilder first$iv = RequiredArgumentBuilder.argument((String)name$iv3, (ArgumentType)type$iv);
        Intrinsics.checkNotNull((Object)first$iv);
        RequiredArgumentBuilder $this$create_u24lambda_u244_u24lambda_u243 = first$iv;
        boolean bl2 = false;
        $this$create_u24lambda_u244_u24lambda_u243.executes(INSTANCE::backupSingleRegion);
        ArgumentBuilder argumentBuilder2 = (ArgumentBuilder)$this$create_u24lambda_u244_u24lambda_u243;
        String string2 = "to";
        class_2264 class_22643 = class_2264.method_9701();
        Intrinsics.checkNotNullExpressionValue((Object)class_22643, (String)"columnPos(...)");
        ArgumentType type$iv2 = (ArgumentType)class_22643;
        boolean $i$f$argument2 = false;
        RequiredArgumentBuilder first$iv2 = RequiredArgumentBuilder.argument((String)name$iv2, (ArgumentType)type$iv2);
        Intrinsics.checkNotNull((Object)first$iv2);
        RequiredArgumentBuilder $this$create_u24lambda_u244_u24lambda_u243_u24lambda_u242 = first$iv2;
        boolean bl3 = false;
        $this$create_u24lambda_u244_u24lambda_u243_u24lambda_u242.executes(BackupCommand::create$lambda$4$lambda$3$lambda$2$lambda$0);
        ArgumentBuilder argumentBuilder3 = (ArgumentBuilder)$this$create_u24lambda_u244_u24lambda_u243_u24lambda_u242;
        String string3 = "dimension";
        class_2181 class_21812 = class_2181.method_9288();
        Intrinsics.checkNotNullExpressionValue((Object)class_21812, (String)"dimension(...)");
        ArgumentType type$iv3 = (ArgumentType)class_21812;
        boolean $i$f$argument3 = false;
        RequiredArgumentBuilder first$iv3 = RequiredArgumentBuilder.argument((String)name$iv, (ArgumentType)type$iv3);
        Intrinsics.checkNotNull((Object)first$iv3);
        RequiredArgumentBuilder $this$create_u24lambda_u244_u24lambda_u243_u24lambda_u242_u24lambda_u241 = first$iv3;
        boolean bl4 = false;
        $this$create_u24lambda_u244_u24lambda_u243_u24lambda_u242_u24lambda_u241.executes(p0 -> BackupCommand.backupRegions$default(INSTANCE, p0, null, null, null, 14, null));
        $this$argument$iv3.then((ArgumentBuilder)first$iv3);
        $this$argument$iv2.then((ArgumentBuilder)first$iv2);
        $this$argument$iv.then((ArgumentBuilder)first$iv);
        return root$iv;
    }

    private final int backupSingleRegion(CommandContext<class_2168> context) {
        class_2265 pos = class_2264.method_9702(context, (String)"from");
        Intrinsics.checkNotNull((Object)pos);
        class_3218 class_32182 = ((class_2168)context.getSource()).method_9225();
        Intrinsics.checkNotNullExpressionValue((Object)class_32182, (String)"getLevel(...)");
        return this.backupRegions(context, pos, pos, class_32182);
    }

    private final int backupRegions(CommandContext<class_2168> context, class_2265 from, class_2265 to, class_3218 level) {
        MinecraftServer server = ((class_2168)context.getSource()).method_9211();
        server.method_3723(true, true, true);
        class_5321 dimension = level.method_27983();
        Intrinsics.checkNotNull((Object)server);
        Path regionPath = EssentialUtilsKt.getStorageAccess(server).method_27424(dimension).resolve("region");
        Path worldPath = server.method_27050(class_5218.field_24188);
        String date = DATE_FORMAT.format(LocalDateTime.now());
        Path backupPath = worldPath.resolve("backups").resolve(date).resolve(dimension.method_29177().toString());
        Intrinsics.checkNotNull((Object)backupPath);
        FileAttribute[] fileAttributeArray = new FileAttribute[]{};
        Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories(backupPath, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"createDirectories(...)");
        Intrinsics.checkNotNull((Object)regionPath);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.notExists(regionPath, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            Object object = context.getSource();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getSource(...)");
            return CommandUtilsKt.fail((class_2168)((class_2168)object), (String)("Dimension " + dimension.method_29177() + " has no regions"));
        }
        try {
            int regionXFrom = Math.floorDiv(from.comp_638(), 512);
            int regionZFrom = Math.floorDiv(from.comp_639(), 512);
            int regionXTo = Math.floorDiv(to.comp_638(), 512);
            int regionZTo = Math.floorDiv(to.comp_639(), 512);
            int x = Math.min(regionXFrom, regionXTo);
            int n = Math.max(regionXFrom, regionXTo);
            if (x <= n) {
                while (true) {
                    int n2;
                    int z;
                    if ((z = Math.min(regionZFrom, regionZTo)) <= (n2 = Math.max(regionZFrom, regionZTo))) {
                        while (true) {
                            String fileName = "r." + x + "." + z + ".mca";
                            Path region = regionPath.resolve(fileName);
                            Intrinsics.checkNotNull((Object)region);
                            LinkOption[] linkOptionArray2 = new LinkOption[]{};
                            if (!Files.notExists(region, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) {
                                Path path;
                                Path path2 = region;
                                Intrinsics.checkNotNullExpressionValue((Object)backupPath.resolve(fileName), (String)"resolve(...)");
                                CopyOption[] copyOptionArray = new CopyOption[]{};
                                Intrinsics.checkNotNullExpressionValue((Object)Files.copy(path2, path, Arrays.copyOf(copyOptionArray, copyOptionArray.length)), (String)"copy(...)");
                            }
                            if (z == n2) break;
                            ++z;
                        }
                    }
                    if (x == n) break;
                    ++x;
                }
            }
            Object object = context.getSource();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getSource(...)");
            class_2168 class_21682 = (class_2168)object;
            class_5250 class_52502 = class_2561.method_43470((String)"Successfully created backup");
            Intrinsics.checkNotNullExpressionValue((Object)class_52502, (String)"literal(...)");
            return CommandUtilsKt.success$default((class_2168)class_21682, (class_2561)((class_2561)ComponentUtils.lime((class_5250)class_52502)), (boolean)false, (int)2, null);
        }
        catch (IOException e) {
            EssentialAddons.INSTANCE.getLogger().error("Failed to create backup", (Throwable)e);
            Object object = context.getSource();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getSource(...)");
            return CommandUtilsKt.fail((class_2168)((class_2168)object), (String)"Failed to create backup");
        }
    }

    static /* synthetic */ int backupRegions$default(BackupCommand backupCommand, CommandContext commandContext, class_2265 class_22652, class_2265 class_22653, class_3218 class_32182, int n, Object object) {
        if ((n & 2) != 0) {
            class_2265 class_22654 = class_2264.method_9702((CommandContext)commandContext, (String)"from");
            Intrinsics.checkNotNullExpressionValue((Object)class_22654, (String)"getColumnPos(...)");
            class_22652 = class_22654;
        }
        if ((n & 4) != 0) {
            class_2265 class_22655 = class_2264.method_9702((CommandContext)commandContext, (String)"to");
            Intrinsics.checkNotNullExpressionValue((Object)class_22655, (String)"getColumnPos(...)");
            class_22653 = class_22655;
        }
        if ((n & 8) != 0) {
            class_3218 class_32183 = class_2181.method_9289((CommandContext)commandContext, (String)"dimension");
            Intrinsics.checkNotNullExpressionValue((Object)class_32183, (String)"getDimension(...)");
            class_32182 = class_32183;
        }
        return backupCommand.backupRegions((CommandContext<class_2168>)commandContext, class_22652, class_22653, class_32182);
    }

    public void register(@NotNull CommandDispatcher<class_2168> dispatcher, @NotNull class_7157 buildContext) {
        super.register(dispatcher, buildContext);
    }

    private static final int create$lambda$4$lambda$3$lambda$2$lambda$0(CommandContext context) {
        Intrinsics.checkNotNull((Object)context);
        class_3218 class_32182 = ((class_2168)context.getSource()).method_9225();
        Intrinsics.checkNotNullExpressionValue((Object)class_32182, (String)"getLevel(...)");
        return BackupCommand.backupRegions$default(INSTANCE, context, null, null, class_32182, 6, null);
    }
}

