/*
 * Decompiled with CFR 0.152.
 */
package me.supersanta.essential_addons.utils;

import carpet.api.settings.SettingsManager;
import carpet.utils.Translations;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.supersanta.essential_addons.EssentialSettings;
import net.fabricmc.api.DedicatedServerModInitializer;
import net.fabricmc.loader.api.FabricLoader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 \u00062\u00020\u0001:\u0001\u0006B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0003\u00a8\u0006\u0007"}, d2={"Lme/supersanta/essential_addons/utils/EssentialRuleGenerator;", "Lnet/fabricmc/api/DedicatedServerModInitializer;", "<init>", "()V", "", "onInitializeServer", "Companion", "EssentialAddons"})
@SourceDebugExtension(value={"SMAP\nEssentialRuleGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EssentialRuleGenerator.kt\nme/supersanta/essential_addons/utils/EssentialRuleGenerator\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,96:1\n37#2:97\n36#2,3:98\n*S KotlinDebug\n*F\n+ 1 EssentialRuleGenerator.kt\nme/supersanta/essential_addons/utils/EssentialRuleGenerator\n*L\n22#1:97\n22#1:98,3\n*E\n"})
public final class EssentialRuleGenerator
implements DedicatedServerModInitializer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String START = "# EssentialAddons\n\n[![Discord](https://badgen.net/discord/online-members/gn99m4QRY4?icon=discord&label=Discord&list=what)](https://discord.gg/gn99m4QRY4)\n[![GitHub downloads](https://img.shields.io/github/downloads/super-santa/essentialaddons/total?label=Github%20downloads&logo=github)](https://github.com/Super-Santa/EssentialAddons/releases)\n[![Modrinth downloads](https://img.shields.io/modrinth/dt/EssentialAddons?label=Modrinth%20downloads&logo=modrinth)](https://modrinth.com/mod/essentialaddons)\n\n[Fabric Carpet](https://github.com/gnembon/fabric-carpet) extension that adds things from the Spigot plugin Essentials, or other features I think are needed for Minecraft.\n\n## !!! Find Updated Releases on [Modrinth](https://modrinth.com/mod/essentialaddons) !!!\n\nFeatures can be enabled through the `/carpet` command:\n```\n/carpet <rule_name> <rule_value>\n\n# For example:\n/carpet phantomsObeyMobcaps true\n/carpet commandCameraMode ops\n/carpet stackableShulkersInPlayerInventories true\n```\n\n\nPermissions can be customised for commands through a permissions mod such as [LuckPerms](https://luckperms.net/),\nthe name of the permissions are as follows:\n```\nessential-addons.command.<command_name>\n\n# For example:\nessential-addons.command.cs\nessential-addons.command.hat\nessential-addons.command.lag-spike\n```\n";

    public void onInitializeServer() {
        List<Object> list = Arrays.stream(FabricLoader.getInstance().getLaunchArguments(true)).filter(arg_0 -> EssentialRuleGenerator.onInitializeServer$lambda$1(EssentialRuleGenerator::onInitializeServer$lambda$0, arg_0)).toList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"toList(...)");
        Collection $this$toTypedArray$iv = list;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] args = thisCollection$iv.toArray(new String[0]);
        OptionParser parser = new OptionParser();
        ArgumentAcceptingOptionSpec pathSpec = parser.accepts("generate").withRequiredArg();
        parser.allowsUnrecognizedOptions();
        OptionSet options = parser.parse(Arrays.copyOf(args, args.length));
        if (!options.has((OptionSpec)pathSpec)) {
            return;
        }
        Logger logger = LogManager.getLogger((String)"EssentialRuleGenerator");
        PrintStream outputStream = null;
        try {
            Path path = Path.of((String)options.valueOf((OptionSpec)pathSpec), new String[0]);
            Intrinsics.checkNotNull((Object)path);
            logger.info("Generating Rules for Path: {}", (Object)((Object)path.toAbsolutePath()).toString());
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            outputStream = new PrintStream(Files.newOutputStream(path, new OpenOption[0]));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Translations.updateLanguage();
        SettingsManager manager = new SettingsManager("1.0.0", "carpet", "EssentialAddons");
        manager.parseSettingsClass(EssentialSettings.class);
        logger.info("Rule Count: {}", (Object)manager.getCarpetRules().size());
        outputStream.println(START);
        manager.dumpAllRulesToStream(outputStream, null);
        outputStream.close();
        logger.info("Complete");
        System.exit(0);
        throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
    }

    private static final boolean onInitializeServer$lambda$0(String opt) {
        return !Intrinsics.areEqual((Object)opt, (Object)"--");
    }

    private static final boolean onInitializeServer$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lme/supersanta/essential_addons/utils/EssentialRuleGenerator$Companion;", "", "<init>", "()V", "", "START", "Ljava/lang/String;", "EssentialAddons"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

