/*
 * Decompiled with CFR 0.152.
 */
package me.supersanta.essential_addons;

import carpet.CarpetExtension;
import carpet.CarpetServer;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.codecs.UnboundedMapCodec;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import me.supersanta.essential_addons.EssentialSettings;
import me.supersanta.essential_addons.commands.BackupCommand;
import me.supersanta.essential_addons.commands.CameraModeCommand;
import me.supersanta.essential_addons.commands.DefuseCommand;
import me.supersanta.essential_addons.commands.EnderchestCommand;
import me.supersanta.essential_addons.commands.ExtinguishCommand;
import me.supersanta.essential_addons.commands.FlyCommand;
import me.supersanta.essential_addons.commands.GMCommand;
import me.supersanta.essential_addons.commands.GodCommand;
import me.supersanta.essential_addons.commands.HatCommand;
import me.supersanta.essential_addons.commands.HealCommand;
import me.supersanta.essential_addons.commands.LagSpikeCommand;
import me.supersanta.essential_addons.commands.ModsCommand;
import me.supersanta.essential_addons.commands.MoreCommand;
import me.supersanta.essential_addons.commands.NearCommand;
import me.supersanta.essential_addons.commands.NightVisionCommand;
import me.supersanta.essential_addons.commands.RenameCommand;
import me.supersanta.essential_addons.commands.RepairCommand;
import me.supersanta.essential_addons.commands.StrengthCommand;
import me.supersanta.essential_addons.commands.SubscribeCommand;
import me.supersanta.essential_addons.commands.TeamTeleportBlacklistCommand;
import me.supersanta.essential_addons.commands.TopCommand;
import me.supersanta.essential_addons.commands.ViewDistanceCommand;
import me.supersanta.essential_addons.commands.WarpCommand;
import me.supersanta.essential_addons.commands.WorkbenchCommand;
import me.supersanta.essential_addons.feature.careful_break.CarefulBreak;
import me.supersanta.essential_addons.feature.extensions.PlayerActionPackExtension;
import me.supersanta.essential_addons.feature.extensions.PlayerCameraModeExtension;
import me.supersanta.essential_addons.feature.extensions.PlayerSubscriptionsExtension;
import me.supersanta.essential_addons.feature.extensions.PlayerWarpsExtension;
import me.supersanta.essential_addons.feature.extensions.TeamTeleportBlacklistExtension;
import me.supersanta.essential_addons.feature.logging.AutoSaveLogger;
import me.supersanta.essential_addons.feature.reload_fake_players.ReloadFakePlayers;
import me.supersanta.essential_addons.feature.remove_after_threshold.RemoveAfterThreshold;
import me.supersanta.essential_addons.feature.teleport_blacklist.TeleportBlacklist;
import me.supersanta.essential_addons.utils.EssentialRegistries;
import net.casual.arcade.commands.CommandTree;
import net.casual.arcade.commands.manager.CommandManager;
import net.casual.arcade.commands.manager.GlobalCommandManager;
import net.casual.arcade.utils.JsonUtils;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_2960;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000f\u0010\u0006\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\u0006\u0010\u0004J\u000f\u0010\u0007\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\u0007\u0010\u0004J\u0017\u0010\n\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000f\u0010\f\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\f\u0010\u0004J\u000f\u0010\u000e\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ#\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\u00112\u0006\u0010\u0010\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0015\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\r\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0017\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\rH\u0007\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0015\u0010\u001a\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\u001a\u0010\u000bR\u0014\u0010\u001b\u001a\u00020\r8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u001b\u0010\u001cR\u0018\u0010\u001e\u001a\u0004\u0018\u00010\u001d8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u001fR\u0017\u0010!\u001a\u00020 8\u0006\u00a2\u0006\f\n\u0004\b!\u0010\"\u001a\u0004\b#\u0010$R\u0017\u0010&\u001a\u00020%8\u0006\u00a2\u0006\f\n\u0004\b&\u0010'\u001a\u0004\b(\u0010)\u00a8\u0006*"}, d2={"Lme/supersanta/essential_addons/EssentialAddons;", "Lnet/fabricmc/api/ModInitializer;", "Lcarpet/CarpetExtension;", "<init>", "()V", "", "onInitialize", "onGameStarted", "Lnet/minecraft/server/MinecraftServer;", "server", "onServerLoaded", "(Lnet/minecraft/server/MinecraftServer;)V", "registerLoggers", "", "version", "()Ljava/lang/String;", "lang", "", "canHasTranslations", "(Ljava/lang/String;)Ljava/util/Map;", "path", "Lnet/minecraft/class_2960;", "id", "(Ljava/lang/String;)Lnet/minecraft/class_2960;", "permission", "(Ljava/lang/String;)Ljava/lang/String;", "registerCommands", "MOD_ID", "Ljava/lang/String;", "Lnet/casual/arcade/commands/manager/CommandManager;", "commands", "Lnet/casual/arcade/commands/manager/CommandManager;", "Lnet/fabricmc/loader/api/ModContainer;", "container", "Lnet/fabricmc/loader/api/ModContainer;", "getContainer", "()Lnet/fabricmc/loader/api/ModContainer;", "Lorg/apache/logging/log4j/Logger;", "logger", "Lorg/apache/logging/log4j/Logger;", "getLogger", "()Lorg/apache/logging/log4j/Logger;", "EssentialAddons"})
public final class EssentialAddons
implements ModInitializer,
CarpetExtension {
    @NotNull
    public static final EssentialAddons INSTANCE = new EssentialAddons();
    @NotNull
    public static final String MOD_ID = "essential-addons";
    @Nullable
    private static CommandManager commands;
    @NotNull
    private static final ModContainer container;
    @NotNull
    private static final Logger logger;

    private EssentialAddons() {
    }

    @NotNull
    public final ModContainer getContainer() {
        return container;
    }

    @NotNull
    public final Logger getLogger() {
        return logger;
    }

    public void onInitialize() {
        CarpetServer.manageExtension((CarpetExtension)this);
        EssentialRegistries.INSTANCE.load();
        CarefulBreak.INSTANCE.registerEvents$EssentialAddons();
        ReloadFakePlayers.INSTANCE.registerEvents$EssentialAddons();
        RemoveAfterThreshold.INSTANCE.registerEvents$EssentialAddons();
        TeleportBlacklist.INSTANCE.registerEvents$EssentialAddons();
        PlayerActionPackExtension.Companion.registerEvents$EssentialAddons();
        PlayerCameraModeExtension.Companion.registerEvents$EssentialAddons();
        PlayerSubscriptionsExtension.Companion.registerEvents$EssentialAddons();
        PlayerWarpsExtension.Companion.registerEvents$EssentialAddons();
        TeamTeleportBlacklistExtension.Companion.registerEvents$EssentialAddons();
    }

    public void onGameStarted() {
        CarpetServer.settingsManager.parseSettingsClass(EssentialSettings.class);
    }

    public void onServerLoaded(@NotNull MinecraftServer server) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        this.registerCommands(server);
    }

    public void registerLoggers() {
        AutoSaveLogger.INSTANCE.register$EssentialAddons();
    }

    @NotNull
    public String version() {
        return MOD_ID;
    }

    @NotNull
    public Map<String, String> canHasTranslations(@NotNull String lang) {
        Intrinsics.checkNotNullParameter((Object)lang, (String)"lang");
        Optional path = container.findPath("assets/essential-addons/lang/" + lang + ".json");
        if (path.isEmpty()) {
            return MapsKt.emptyMap();
        }
        UnboundedMapCodec codec = Codec.unboundedMap((Codec)((Codec)Codec.STRING), (Codec)((Codec)Codec.STRING));
        try {
            Intrinsics.checkNotNull((Object)codec);
            Decoder decoder = (Decoder)codec;
            Object t = path.get();
            Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
            Path path2 = (Path)t;
            OpenOption[] openOptionArray = new OpenOption[]{};
            InputStream inputStream = Files.newInputStream(path2, Arrays.copyOf(openOptionArray, openOptionArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"newInputStream(...)");
            DataResult result = JsonUtils.INSTANCE.decodeWith(decoder, inputStream);
            Map map = result.result().orElseGet(EssentialAddons::canHasTranslations$lambda$0);
            Intrinsics.checkNotNullExpressionValue((Object)map, (String)"orElseGet(...)");
            return map;
        }
        catch (IOException e) {
            return MapsKt.emptyMap();
        }
    }

    @NotNull
    public final class_2960 id(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        class_2960 class_29602 = class_2960.method_60655((String)MOD_ID, (String)path);
        Intrinsics.checkNotNullExpressionValue((Object)class_29602, (String)"fromNamespaceAndPath(...)");
        return class_29602;
    }

    @JvmStatic
    @NotNull
    public static final String permission(@NotNull String permission) {
        Intrinsics.checkNotNullParameter((Object)permission, (String)"permission");
        return "essential-addons." + permission;
    }

    public final void registerCommands(@NotNull MinecraftServer server) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        CommandManager manager = new CommandManager(server);
        manager.register((CommandTree)BackupCommand.INSTANCE);
        manager.register((CommandTree)CameraModeCommand.INSTANCE);
        manager.register((CommandTree)DefuseCommand.INSTANCE);
        manager.register((CommandTree)EnderchestCommand.INSTANCE);
        manager.register((CommandTree)ExtinguishCommand.INSTANCE);
        manager.register((CommandTree)FlyCommand.INSTANCE);
        manager.register((CommandTree)GMCommand.INSTANCE);
        manager.register((CommandTree)GodCommand.INSTANCE);
        manager.register((CommandTree)HatCommand.INSTANCE);
        manager.register((CommandTree)HealCommand.INSTANCE);
        manager.register((CommandTree)LagSpikeCommand.INSTANCE);
        manager.register((CommandTree)ModsCommand.INSTANCE);
        manager.register((CommandTree)MoreCommand.INSTANCE);
        manager.register((CommandTree)NearCommand.INSTANCE);
        manager.register((CommandTree)NightVisionCommand.INSTANCE);
        manager.register((CommandTree)RenameCommand.INSTANCE);
        manager.register((CommandTree)RepairCommand.INSTANCE);
        manager.register((CommandTree)StrengthCommand.INSTANCE);
        manager.register((CommandTree)SubscribeCommand.INSTANCE);
        manager.register((CommandTree)TeamTeleportBlacklistCommand.INSTANCE);
        manager.register((CommandTree)TopCommand.INSTANCE);
        manager.register((CommandTree)ViewDistanceCommand.INSTANCE);
        manager.register((CommandTree)WarpCommand.INSTANCE);
        manager.register((CommandTree)WorkbenchCommand.INSTANCE);
        CommandManager old = commands;
        if (old != null) {
            GlobalCommandManager.INSTANCE.removeManager(old);
        }
        GlobalCommandManager.INSTANCE.addManager(manager);
        commands = manager;
    }

    private static final Map canHasTranslations$lambda$0() {
        return MapsKt.emptyMap();
    }

    static {
        Object t = FabricLoader.getInstance().getModContainer(MOD_ID).get();
        Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
        container = (ModContainer)t;
        Logger logger = LogManager.getLogger((String)"EssentialAddons");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        EssentialAddons.logger = logger;
    }
}

