/*
 * Decompiled with CFR 0.152.
 */
package essentialaddons.commands;

import carpet.CarpetSettings;
import carpet.patches.EntityPlayerMPFake;
import carpet.utils.Messenger;
import com.google.common.collect.Sets;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import essentialaddons.EssentialAddons;
import essentialaddons.EssentialSettings;
import essentialaddons.EssentialUtils;
import essentialaddons.feature.GhostPlayerEntity;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2181;
import net.minecraft.class_2277;
import net.minecraft.class_243;
import net.minecraft.class_3222;
import net.minecraft.class_3312;
import net.minecraft.class_3324;
import net.minecraft.class_4844;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;

public class CommandGhostPlayer {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"ghostplayer").requires(EssentialUtils.enabled(() -> EssentialSettings.commandGhostPlayer, "essentialaddons.command.ghostplayer"))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> class_2172.method_9265(CommandGhostPlayer.getPlayers((class_2168)context.getSource()), (SuggestionsBuilder)builder)).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"spawn").executes(context -> CommandGhostPlayer.fakePlayerSpawn((CommandContext<class_2168>)context, StringArgumentType.getString((CommandContext)context, (String)"player"), ((class_2168)context.getSource()).method_9207().method_19538(), null))).then(class_2170.method_9247((String)"at").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"pos", (ArgumentType)class_2277.method_9737()).executes(context -> CommandGhostPlayer.fakePlayerSpawn((CommandContext<class_2168>)context, StringArgumentType.getString((CommandContext)context, (String)"player"), class_2277.method_9736((CommandContext)context, (String)"pos"), null))).then(class_2170.method_9247((String)"in").then(class_2170.method_9244((String)"dimension", (ArgumentType)class_2181.method_9288()).executes(context -> CommandGhostPlayer.fakePlayerSpawn((CommandContext<class_2168>)context, StringArgumentType.getString((CommandContext)context, (String)"player"), class_2277.method_9736((CommandContext)context, (String)"pos"), (class_5321<class_1937>)class_2181.method_9289((CommandContext)context, (String)"dimension").method_27983())))))))).then(class_2170.method_9247((String)"kill").executes(context -> {
            String username = StringArgumentType.getString((CommandContext)context, (String)"player");
            class_3222 player = ((class_2168)context.getSource()).method_9211().method_3760().method_14566(username);
            if (!(player instanceof EntityPlayerMPFake) && !(player instanceof GhostPlayerEntity)) {
                Messenger.m((class_2168)((class_2168)context.getSource()), (Object[])new Object[]{"r Cannot kill this player"});
                return 0;
            }
            player.method_51469().method_14178().method_18755((class_1297)player);
            player.method_5768();
            return 0;
        }))));
    }

    private static int fakePlayerSpawn(CommandContext<class_2168> context, String username, class_243 pos, class_5321<class_1937> dim) throws CommandSyntaxException {
        if (CommandGhostPlayer.canSpawn(context)) {
            class_2168 source = (class_2168)context.getSource();
            dim = dim == null ? source.method_9225().method_27983() : dim;
            class_3222 player = source.method_9207();
            GhostPlayerEntity.createFake(username, source.method_9211(), pos, player.method_36454(), player.method_36455(), (class_5321<class_1937>)dim, () -> EssentialUtils.sendRawFeedback((class_2168)context.getSource(), false, "Failed to spawn player"));
        }
        return 0;
    }

    private static boolean canSpawn(CommandContext<class_2168> context) {
        String playerName = StringArgumentType.getString(context, (String)"player");
        MinecraftServer server = ((class_2168)context.getSource()).method_9211();
        class_3324 manager = server.method_3760();
        class_3222 player = manager.method_14566(playerName);
        if (player != null) {
            Messenger.m((class_2168)((class_2168)context.getSource()), (Object[])new Object[]{"r Player ", "rb " + playerName, "r  is already logged on"});
            return false;
        }
        class_3312 cache = server.method_3793();
        if (cache == null) {
            EssentialAddons.LOGGER.error("Server user cache was null!!??");
            return false;
        }
        GameProfile profile = cache.method_14515(playerName).orElse(null);
        if (profile == null) {
            if (!CarpetSettings.allowSpawningOfflinePlayers) {
                Messenger.m((class_2168)((class_2168)context.getSource()), (Object[])new Object[]{"r Player " + playerName + " is either banned by Mojang, or auth servers are down. Banned players can only be summoned in Singleplayer and in servers in off-line mode."});
                return false;
            }
            profile = new GameProfile(class_4844.method_43344((String)playerName), playerName);
        }
        if (manager.method_14563().method_14650(profile)) {
            Messenger.m((class_2168)((class_2168)context.getSource()), (Object[])new Object[]{"r Player ", "rb " + playerName, "r  is banned on this server"});
            return false;
        }
        if (manager.method_14614() && manager.method_14587(profile) && !((class_2168)context.getSource()).method_9259(2)) {
            Messenger.m((class_2168)((class_2168)context.getSource()), (Object[])new Object[]{"r Whitelisted players can only be spawned by operators"});
            return false;
        }
        return true;
    }

    private static Collection<String> getPlayers(class_2168 source) {
        LinkedHashSet players = Sets.newLinkedHashSet(Arrays.asList("Steve", "Alex"));
        players.addAll(source.method_9262());
        return players;
    }

    public static class_3222 getPlayer(CommandContext<class_2168> context) {
        String playerName = StringArgumentType.getString(context, (String)"player");
        MinecraftServer server = ((class_2168)context.getSource()).method_9211();
        return server.method_3760().method_14566(playerName);
    }
}

