/*
 * Decompiled with CFR 0.152.
 */
package essentialaddons.feature;

import essentialaddons.EssentialAddons;
import essentialaddons.EssentialSettings;
import essentialaddons.mixins.gameRuleSync.RuleInvoker;
import essentialaddons.utils.ducks.IRule;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2658;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_8710;
import net.minecraft.class_9139;

public class GameRuleNetworkHandler {
    private static final int VERSION = 101;
    public static final GameRuleNetworkHandler INSTANCE = new GameRuleNetworkHandler();
    private final Set<class_3244> validPlayers = new HashSet<class_3244>();
    private final Map<String, class_1928.class_4313<?>> keyMap = new HashMap();

    private GameRuleNetworkHandler() {
    }

    public void sayHello(class_3222 player) {
        class_2658 packet = new class_2658((class_8710)new GameRuleHelloPayload("essential_addons", 101));
        player.field_13987.method_14364((class_2596)packet);
    }

    public void updateAllPlayerStatuses() {
        for (class_3244 handler : this.validPlayers) {
            this.updatePlayerStatus(handler.field_14140);
        }
    }

    public void updatePlayerStatus(class_3222 player) {
        boolean canUpdateGamerules = EssentialSettings.gameRuleSync && (EssentialSettings.gameRuleNonOp || player.method_5687(2));
        class_2658 packet = new class_2658((class_8710)new GameRulePermissionsPayload(canUpdateGamerules));
        player.field_13987.method_14364((class_2596)packet);
    }

    public void sendAllRules() {
        HashMap<class_1937, class_2658> cache = new HashMap<class_1937, class_2658>();
        for (class_3244 handler : this.validPlayers) {
            class_2658 packet = cache.computeIfAbsent(handler.field_14140.method_37908(), world -> {
                class_2487 gamerules = world.method_8450().method_8358();
                return new class_2658((class_8710)new GameRulesChangedPayload(gamerules));
            });
            handler.method_14364((class_2596)packet);
        }
    }

    public void sendAllRules(class_3222 player) {
        class_2487 gamerules = player.method_37908().method_8450().method_8358();
        class_2658 packet = new class_2658((class_8710)new GameRulesChangedPayload(gamerules));
        player.field_13987.method_14364((class_2596)packet);
    }

    public void onRuleChange(String ruleName, String ruleValue) {
        class_2487 gamerules = new class_2487();
        gamerules.method_10582(ruleName, ruleValue);
        class_2658 packet = new class_2658((class_8710)new GameRulesChangedPayload(gamerules));
        for (class_3244 handler : this.validPlayers) {
            handler.method_14364((class_2596)packet);
        }
    }

    public void addGameRuleKey(class_1928.class_4313<?> gameRuleKey) {
        this.keyMap.put(gameRuleKey.method_20771(), gameRuleKey);
    }

    public void registerGameRulePayloads() {
        PayloadTypeRegistry.playC2S().register(GameRuleHelloPayload.ID, GameRuleHelloPayload.CODEC);
        PayloadTypeRegistry.playC2S().register(SetGameRulePayload.ID, SetGameRulePayload.CODEC);
        PayloadTypeRegistry.playS2C().register(GameRuleHelloPayload.ID, GameRuleHelloPayload.CODEC);
        PayloadTypeRegistry.playS2C().register(GameRulePermissionsPayload.ID, GameRulePermissionsPayload.CODEC);
        PayloadTypeRegistry.playS2C().register(GameRulesChangedPayload.ID, GameRulesChangedPayload.CODEC);
        ServerPlayNetworking.registerGlobalReceiver(GameRuleHelloPayload.ID, (payload, context) -> this.handleHello(context.player().field_13987, (GameRuleHelloPayload)payload));
        ServerPlayNetworking.registerGlobalReceiver(SetGameRulePayload.ID, (payload, context) -> this.handleGameRuleSet(context.player().field_13987, (SetGameRulePayload)payload));
    }

    private void handleHello(class_3244 handler, GameRuleHelloPayload payload) {
        if (101 >= payload.version) {
            this.validPlayers.add(handler);
            this.updatePlayerStatus(handler.field_14140);
            if (EssentialSettings.gameRuleSync) {
                this.sendAllRules(handler.field_14140);
            }
        }
    }

    private void handleGameRuleSet(class_3244 handler, SetGameRulePayload payload) {
        class_3222 player = handler.field_14140;
        String playerName = player.method_5820();
        if (!this.validPlayers.contains(handler)) {
            EssentialAddons.LOGGER.warn("{} tried to send data without saying hello!", (Object)playerName);
            return;
        }
        if (!EssentialSettings.gameRuleSync) {
            EssentialAddons.LOGGER.warn("{} tried to set gamerules without it being enabled!", (Object)playerName);
            return;
        }
        class_1928.class_4313<?> gameRuleKey = this.keyMap.get(payload.name);
        if (gameRuleKey == null) {
            EssentialAddons.LOGGER.warn("Received bad Game Rule packet from {}!", (Object)playerName);
            return;
        }
        class_1928.class_4315 rule = player.field_13995.method_3767().method_20746(gameRuleKey);
        ((RuleInvoker)rule).deserialize(payload.value);
        ((IRule)rule).essentialaddons$ruleChanged(player);
    }

    public record GameRuleHelloPayload(String brand, int version) implements class_8710
    {
        public static final class_8710.class_9154<GameRuleHelloPayload> ID = new class_8710.class_9154(class_2960.method_60654((String)"essential:game_rule_hello"));
        public static final class_9139<class_2540, GameRuleHelloPayload> CODEC = class_9139.method_56438((payload, buf) -> buf.method_10814(payload.brand).method_53002(payload.version), buf -> new GameRuleHelloPayload(buf.method_19772(), buf.readInt()));

        public class_8710.class_9154<? extends class_8710> method_56479() {
            return ID;
        }
    }

    public record GameRulePermissionsPayload(boolean canUpdateGamerules) implements class_8710
    {
        public static final class_8710.class_9154<GameRulePermissionsPayload> ID = new class_8710.class_9154(class_2960.method_60654((String)"essential:game_rule_permissions"));
        public static final class_9139<class_2540, GameRulePermissionsPayload> CODEC = class_9139.method_56438((payload, buf) -> buf.method_52964(payload.canUpdateGamerules), buf -> new GameRulePermissionsPayload(buf.readBoolean()));

        public class_8710.class_9154<? extends class_8710> method_56479() {
            return ID;
        }
    }

    public record GameRulesChangedPayload(class_2487 compound) implements class_8710
    {
        public static final class_8710.class_9154<GameRulesChangedPayload> ID = new class_8710.class_9154(class_2960.method_60654((String)"essential:game_rules_changed"));
        public static final class_9139<class_2540, GameRulesChangedPayload> CODEC = class_9139.method_56438((payload, buf) -> buf.method_10794((class_2520)payload.compound), buf -> new GameRulesChangedPayload(buf.method_10798()));

        public class_8710.class_9154<? extends class_8710> method_56479() {
            return ID;
        }
    }

    public record SetGameRulePayload(String name, String value) implements class_8710
    {
        public static final class_8710.class_9154<SetGameRulePayload> ID = new class_8710.class_9154(class_2960.method_60654((String)"essential:set_game_rule"));
        public static final class_9139<class_2540, SetGameRulePayload> CODEC = class_9139.method_56438((payload, buf) -> buf.method_10814(payload.name).method_10814(payload.value), buf -> new SetGameRulePayload(buf.method_19772(), buf.method_19772()));

        public class_8710.class_9154<? extends class_8710> method_56479() {
            return ID;
        }
    }
}

