/*
 * Decompiled with CFR 0.152.
 */
package essentialaddons.utils;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import essentialaddons.utils.Config;
import essentialaddons.utils.Location;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_7924;

public class ConfigCameraData
implements Config {
    public static final ConfigCameraData INSTANCE = new ConfigCameraData();
    private final Map<UUID, Location> playerLocationMap = new HashMap<UUID, Location>();

    private ConfigCameraData() {
    }

    public void addPlayer(class_3222 player) {
        this.playerLocationMap.put(player.method_5667(), new Location((class_1297)player));
    }

    public boolean hasPlayerLocation(class_3222 player) {
        return this.playerLocationMap.containsKey(player.method_5667());
    }

    public boolean restorePlayer(class_3222 player) {
        Location playerLocation = this.playerLocationMap.remove(player.method_5667());
        if (playerLocation == null) {
            return false;
        }
        class_3218 world = player.field_13995.method_3847(playerLocation.worldRegistry());
        player.method_14251(world, playerLocation.position().field_1352, playerLocation.position().field_1351, playerLocation.position().field_1350, playerLocation.yaw(), playerLocation.pitch());
        return true;
    }

    @Override
    public String getConfigName() {
        return "CameraData";
    }

    @Override
    public Path getConfigPath() {
        return this.getConfigRootPath().resolve("cameradata.json");
    }

    @Override
    public JsonArray getSaveData() {
        JsonArray playerLocations = new JsonArray();
        this.playerLocationMap.forEach((uuid, location) -> {
            JsonObject playerData = new JsonObject();
            playerData.addProperty("uuid", uuid.toString());
            playerData.addProperty("dimension", location.worldRegistry().method_29177().toString());
            playerData.addProperty("x", (Number)location.position().field_1352);
            playerData.addProperty("y", (Number)location.position().field_1351);
            playerData.addProperty("z", (Number)location.position().field_1350);
            playerData.addProperty("yaw", (Number)Float.valueOf(location.yaw()));
            playerData.addProperty("pitch", (Number)Float.valueOf(location.pitch()));
            playerLocations.add((JsonElement)playerData);
        });
        return playerLocations;
    }

    @Override
    public void readConfig(JsonArray playerLocations) {
        playerLocations.forEach(jsonElement -> {
            JsonObject playerData = jsonElement.getAsJsonObject();
            UUID playerUUID = UUID.fromString(playerData.get("uuid").getAsString());
            class_5321 worldRegistry = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)class_2960.method_12829((String)playerData.get("dimension").getAsString()));
            class_243 position = new class_243(playerData.get("x").getAsDouble(), playerData.get("y").getAsDouble(), playerData.get("z").getAsDouble());
            float yaw = playerData.get("yaw").getAsFloat();
            float pitch = playerData.get("pitch").getAsFloat();
            Location playerLocation = new Location((class_5321<class_1937>)worldRegistry, position, yaw, pitch);
            this.playerLocationMap.put(playerUUID, playerLocation);
        });
    }
}

