/*
 * Decompiled with CFR 0.152.
 */
package essentialaddons.utils;

import carpet.fakes.ServerPlayerInterface;
import carpet.helpers.EntityPlayerActionPack;
import carpet.patches.EntityPlayerMPFake;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import essentialaddons.EssentialAddons;
import essentialaddons.feature.ReloadFakePlayers;
import essentialaddons.mixins.reloadFakePlayers.ActionMixin;
import essentialaddons.mixins.reloadFakePlayers.EntityPlayerActionPackAccessor;
import essentialaddons.utils.Config;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import net.minecraft.server.MinecraftServer;

public class ConfigFakePlayerData
implements Config {
    public static final ConfigFakePlayerData INSTANCE = new ConfigFakePlayerData();
    private final Set<EntityPlayerMPFake> fakePlayers = new HashSet<EntityPlayerMPFake>();

    private ConfigFakePlayerData() {
    }

    public void addFakePlayer(EntityPlayerMPFake fakePlayer) {
        this.fakePlayers.add(fakePlayer);
    }

    public void removeFakePlayer(EntityPlayerMPFake fakePlayer) {
        this.fakePlayers.remove(fakePlayer);
    }

    @Override
    public String getConfigName() {
        return "FakePlayerData";
    }

    @Override
    public Path getConfigPath() {
        return this.getConfigRootPath().resolve("fakeplayerdata.json");
    }

    @Override
    public JsonArray getSaveData() {
        JsonArray totalPlayerData = new JsonArray();
        this.fakePlayers.forEach(player -> {
            EntityPlayerActionPackAccessor actionPackAccessor = (EntityPlayerActionPackAccessor)((ServerPlayerInterface)player).getActionPack();
            JsonObject playerData = new JsonObject();
            playerData.addProperty("uuid", player.method_5667().toString());
            playerData.addProperty("username", player.method_7334().getName());
            playerData.addProperty("sneaking", Boolean.valueOf(actionPackAccessor.isSneaking()));
            playerData.addProperty("sprinting", Boolean.valueOf(actionPackAccessor.isSprinting()));
            playerData.addProperty("forward", (Number)Float.valueOf(actionPackAccessor.getForward()));
            playerData.addProperty("strafing", (Number)Float.valueOf(actionPackAccessor.getStrafing()));
            JsonArray playerActions = new JsonArray();
            actionPackAccessor.getActions().forEach((actionType, action) -> {
                JsonObject actionData = new JsonObject();
                ActionMixin actionAccessor = (ActionMixin)action;
                actionData.addProperty("type", actionType.toString());
                actionData.addProperty("limit", (Number)action.limit);
                actionData.addProperty("interval", (Number)action.interval);
                actionData.addProperty("offset", (Number)action.offset);
                actionData.addProperty("count", (Number)actionAccessor.getCount());
                actionData.addProperty("next", (Number)actionAccessor.getNext());
                actionData.addProperty("continuous", Boolean.valueOf(actionAccessor.isContinuous()));
                playerActions.add((JsonElement)actionData);
            });
            playerData.add("actions", (JsonElement)playerActions);
            totalPlayerData.add((JsonElement)playerData);
        });
        return totalPlayerData;
    }

    @Override
    public void readConfig(JsonArray configData) {
    }

    public void readConfig(MinecraftServer server) {
        JsonArray totalPlayerData = this.getConfigData();
        HashSet loadedPlayers = new HashSet();
        totalPlayerData.forEach(jsonElement -> {
            JsonObject playerData = jsonElement.getAsJsonObject();
            UUID playerUUID = UUID.fromString(playerData.get("uuid").getAsString());
            if (!loadedPlayers.contains(playerUUID)) {
                String username = playerData.get("username").getAsString();
                boolean isSneaking = playerData.get("sneaking").getAsBoolean();
                boolean isSprinting = playerData.get("sprinting").getAsBoolean();
                float forward = playerData.get("forward").getAsFloat();
                float strafing = playerData.get("strafing").getAsFloat();
                TreeMap<EntityPlayerActionPack.ActionType, EntityPlayerActionPack.Action> actionMap = new TreeMap<EntityPlayerActionPack.ActionType, EntityPlayerActionPack.Action>();
                JsonArray playerActions = playerData.get("actions").getAsJsonArray();
                playerActions.forEach(element -> {
                    JsonObject actionData = element.getAsJsonObject();
                    EntityPlayerActionPack.ActionType type = EntityPlayerActionPack.ActionType.valueOf((String)actionData.get("type").getAsString());
                    EntityPlayerActionPack.Action action = ActionMixin.init(actionData.get("limit").getAsInt(), actionData.get("interval").getAsInt(), actionData.get("offset").getAsInt(), actionData.get("continuous").getAsBoolean());
                    ((ActionMixin)action).setCount(actionData.get("count").getAsInt());
                    ((ActionMixin)action).setNext(actionData.get("next").getAsInt());
                    actionMap.put(type, action);
                });
                loadedPlayers.add(playerUUID);
                ReloadFakePlayers.loadPlayer(server, playerUUID, username, isSneaking, isSprinting, forward, strafing, actionMap);
            } else {
                EssentialAddons.LOGGER.warn("Tried to load duplicate player: {}", (Object)playerUUID);
            }
        });
    }
}

