/*
 * Decompiled with CFR 0.152.
 */
package essentialaddons.utils;

import essentialaddons.EssentialSettings;
import essentialaddons.utils.ConfigSubscribeData;
import java.util.function.Supplier;
import net.minecraft.class_3222;

public enum Subscription {
    TELEPORT_BLACKLIST("teleport_blacklist", () -> EssentialSettings.cameraModeTeleportBlacklist),
    ESSENTIAL_CAREFUL_BREAK("essential_careful_break", () -> EssentialSettings.essentialCarefulBreak),
    ESSENTIAL_CAREFUL_DROP("essential_careful_drop", () -> EssentialSettings.essentialCarefulDrop),
    ALWAYS_CAREFUL("always_careful", () -> EssentialSettings.essentialCarefulBreak || EssentialSettings.essentialCarefulDrop);

    private final String prettyName;
    private final Supplier<Boolean> requirement;

    private Subscription(String prettyName, Supplier<Boolean> requirement) {
        this.prettyName = prettyName;
        this.requirement = requirement;
    }

    public String getName() {
        return this.prettyName;
    }

    public Supplier<Boolean> getRequirement() {
        return this.requirement;
    }

    public boolean hasPlayer(class_3222 player) {
        return ConfigSubscribeData.INSTANCE.isPlayerSubscribedTo(player, this);
    }

    public boolean togglePlayer(class_3222 player) {
        boolean shouldDisable = this.hasPlayer(player);
        if (shouldDisable) {
            this.removePlayer(player);
        } else {
            this.addPlayer(player);
        }
        return !shouldDisable;
    }

    public void addPlayer(class_3222 player) {
        ConfigSubscribeData.INSTANCE.addPlayerSubscription(player, this);
    }

    public void removePlayer(class_3222 player) {
        ConfigSubscribeData.INSTANCE.removePlayerSubscription(player, this);
    }

    public static Subscription fromString(String name) {
        for (Subscription subscription : Subscription.values()) {
            if (!subscription.prettyName.equals(name)) continue;
            return subscription;
        }
        return null;
    }

    public static boolean canUseSubscribeCommand() {
        for (Subscription subscription : Subscription.values()) {
            if (!subscription.getRequirement().get().booleanValue()) continue;
            return true;
        }
        return false;
    }
}

