/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.configuration.client;

import dev.toma.configuration.client.screen.ConfigGroupScreen;
import dev.toma.configuration.client.screen.ConfigScreen;
import dev.toma.configuration.client.theme.ConfigTheme;
import dev.toma.configuration.client.theme.ConfigurationThemes;
import dev.toma.configuration.config.Config;
import dev.toma.configuration.config.ConfigHolder;
import dev.toma.configuration.config.value.ConfigValue;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.class_437;
import org.jetbrains.annotations.ApiStatus;

public final class ConfigurationClient {
    @ApiStatus.Internal
    private static final Map<String, ConfigTheme> CONFIG_THEMES = new HashMap<String, ConfigTheme>();

    public static class_437 getConfigScreen(Class<?> configClass, class_437 previous) {
        Config cfg = configClass.getAnnotation(Config.class);
        if (cfg == null) {
            return null;
        }
        String id = cfg.id();
        return ConfigurationClient.getConfigScreen(id, previous);
    }

    public static class_437 getConfigScreen(String configId, class_437 previous) {
        return ConfigHolder.getConfig(configId).map(holder -> {
            Map<String, ConfigValue<?>> valueMap = holder.getValueMap();
            return new ConfigScreen((ConfigHolder<?>)holder, holder.getTitle(), valueMap, previous);
        }).orElse(null);
    }

    public static class_437 getConfigScreenByGroup(String group, class_437 previous) {
        List<ConfigHolder<?>> list = ConfigHolder.getConfigsByGroup(group);
        if (list.isEmpty()) {
            return null;
        }
        return ConfigurationClient.getConfigScreenByGroup(list, group, previous);
    }

    public static void setCustomConfigTheme(ConfigHolder<?> holder, Consumer<ConfigTheme> themeConfiguration) {
        ConfigTheme theme = ConfigurationClient.getConfigTheme(holder).copy();
        themeConfiguration.accept(theme);
        CONFIG_THEMES.put(holder.getConfigId(), theme);
    }

    public static ConfigTheme getConfigTheme(ConfigHolder<?> holder) {
        return CONFIG_THEMES.computeIfAbsent(holder.getConfigId(), id -> {
            ConfigTheme theme = new ConfigTheme();
            ConfigurationThemes.DEFAULT_THEME.accept(theme);
            return theme;
        });
    }

    @ApiStatus.Internal
    public static class_437 getConfigScreenByGroup(List<ConfigHolder<?>> group, String groupId, class_437 previous) {
        return new ConfigGroupScreen(previous, groupId, group);
    }
}

