/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.configuration.client.screen;

import dev.toma.configuration.Configuration;
import dev.toma.configuration.client.screen.AbstractConfigScreen;
import dev.toma.configuration.client.theme.ConfigTheme;
import dev.toma.configuration.client.theme.adapter.DisplayAdapter;
import dev.toma.configuration.client.widget.ConfigEntryWidget;
import dev.toma.configuration.client.widget.ThemedButtonWidget;
import dev.toma.configuration.client.widget.render.TextureRenderer;
import dev.toma.configuration.config.ConfigHolder;
import dev.toma.configuration.config.adapter.TypeAdapter;
import dev.toma.configuration.config.adapter.TypeAdapterManager;
import dev.toma.configuration.config.value.AbstractArrayValue;
import dev.toma.configuration.config.value.ConfigValue;
import dev.toma.configuration.config.value.ValueData;
import java.lang.reflect.Field;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import org.apache.logging.log4j.message.FormattedMessage;
import org.apache.logging.log4j.message.Message;

public class ArrayConfigScreen<V, C extends AbstractArrayValue<V>>
extends AbstractConfigScreen {
    public static final class_2561 ADD_ELEMENT = class_2561.method_43471((String)"text.configuration.value.add_element");
    public static final class_2960 REMOVE_ICON = class_2960.method_60655((String)"configuration", (String)"textures/icons/remove.png");
    public final C array;
    private final boolean fixedSize;
    private Supplier<Integer> sizeSupplier = () -> 0;
    private DummyConfigValueFactory valueFactory;
    private ElementAddHandler addHandler;
    private ElementRemoveHandler<V[]> removeHandler;

    public ArrayConfigScreen(ConfigHolder<?> holder, C array, class_437 previous) {
        super(((ConfigValue)array).getValueData().getTitle(), previous, holder);
        this.array = array;
        this.fixedSize = ((AbstractArrayValue)array).isFixedSize();
    }

    public void fetchSize(Supplier<Integer> integerSupplier) {
        this.sizeSupplier = integerSupplier;
    }

    public void valueFactory(DummyConfigValueFactory factory) {
        this.valueFactory = factory;
    }

    public void addElement(ElementAddHandler handler) {
        this.addHandler = handler;
    }

    public void removeElement(ElementRemoveHandler<V[]> handler) {
        this.removeHandler = handler;
    }

    protected void method_25426() {
        int viewportMin = 35;
        int viewportHeight = this.field_22790 - 35 - 30;
        int spacing = 22;
        this.pageSize = (viewportHeight - 20) / spacing;
        this.correctScrollingIndex(this.getTotalSize());
        int errorOffset = viewportHeight - 20 - (this.pageSize * spacing - 5);
        int offset = 0;
        Class<?> compType = ((Object[])((ConfigValue)this.array).get()).getClass().getComponentType();
        DisplayAdapter adapter = this.theme.getAdapter(compType);
        TypeAdapter.AdapterContext context = ((ConfigValue)this.array).getSerializationContext();
        Field owner = context.getOwner();
        for (int i = this.index; i < this.index + this.pageSize; ++i) {
            int j = i - this.index;
            if (i >= this.sizeSupplier.get()) {
                if (this.fixedSize) break;
                ThemedButtonWidget addElement = (ThemedButtonWidget)this.method_37063((class_364)new ThemedButtonWidget(30, 45 + j * spacing + offset, this.field_22789 - 60, 20, ADD_ELEMENT, this.theme));
                addElement.setBackgroundRenderer(this.theme.getButtonBackground(addElement));
                addElement.setClickListener((widget, mouseX, mouseY) -> {
                    this.addHandler.insertElement();
                    this.method_25423(this.field_22787, this.field_22789, this.field_22790);
                });
                break;
            }
            int correct = errorOffset / (this.pageSize - j);
            errorOffset -= correct;
            ConfigValue<?> dummy = this.valueFactory.create(((ConfigValue)this.array).getId(), i);
            dummy.processAnnotations(owner);
            class_2561 label = this.getEntryLabel(dummy, i);
            ConfigEntryWidget widget2 = (ConfigEntryWidget)this.method_37063((class_364)new ConfigEntryWidget(30, 45 + j * spacing + (offset += correct), this.field_22789 - 60, 20, label, dummy, this.getConfigId(), this.theme));
            widget2.setDescriptionRenderer(this);
            if (adapter == null) {
                Configuration.LOGGER.error(MARKER, "Missing display adapter for {} type, will not be displayed in GUI", (Object)compType.getSimpleName());
                continue;
            }
            try {
                adapter.placeWidgets(this.holder, dummy, owner, this.theme, widget2);
            }
            catch (ClassCastException e) {
                Configuration.LOGGER.error(MARKER, (Message)new FormattedMessage("Unable to create config field for {}", (Object)compType.getSimpleName()), (Throwable)e);
            }
            if (this.fixedSize) continue;
            int elementIndex = i;
            ThemedButtonWidget removeButton = (ThemedButtonWidget)this.method_37063((class_364)new ThemedButtonWidget(this.field_22789 - 29, widget2.method_46427(), 20, 20, class_5244.field_39003, this.theme));
            removeButton.setClickListener((widget1, mouseX, mouseY) -> {
                this.removeHandler.removeElementAt(elementIndex, (index1, src, dest) -> {
                    System.arraycopy(src, 0, dest, 0, index1);
                    System.arraycopy(src, index1 + 1, dest, index1, this.sizeSupplier.get() - 1 - index1);
                    return dest;
                });
                this.method_25423(this.field_22787, this.field_22789, this.field_22790);
            });
            removeButton.setBackgroundRenderer(this.theme.getButtonBackground(removeButton));
            removeButton.setForegroundRenderer(new TextureRenderer(REMOVE_ICON, 2, 2, 16, 16));
        }
        this.addSettingsButton();
        this.addFooter();
    }

    private <T> class_2561 getEntryLabel(ConfigValue<T> value, int index) {
        ValueData<T> valueData = value.getValueData();
        String languageKey = valueData.getLanguageKey(valueData.getAttributes()) + ".entry";
        class_5250 translated = class_2561.method_43471((String)languageKey);
        return class_2561.method_43470((String)("[" + index + "] " + translated.getString()));
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        if (ArrayConfigScreen.canRenderBackground(this.field_22787)) {
            ConfigTheme.Header themeHeader = this.theme.getHeader();
            ConfigTheme.Footer footer = this.theme.getFooter();
            class_2561 headerLabel = themeHeader.customText() != null ? themeHeader.customText() : this.field_22785;
            int titleWidth = this.field_22793.method_27525((class_5348)headerLabel);
            graphics.method_25294(0, 0, this.field_22789, 35, themeHeader.backgroundColor());
            int n = (this.field_22789 - titleWidth) / 2;
            Objects.requireNonNull(this.field_22793);
            graphics.method_27535(this.field_22793, headerLabel, n, (35 - 9) / 2, themeHeader.foregroundColor());
            graphics.method_25294(0, this.field_22790 - 30, this.field_22789, this.field_22790, footer.backgroundColor());
            Integer fillColor = this.theme.getBackgroundFillColor();
            if (fillColor != null) {
                graphics.method_25294(0, 35, this.field_22789, this.field_22790 - 30, fillColor.intValue());
            }
        }
        this.field_33816.forEach(renderable -> renderable.method_25394(graphics, mouseX, mouseY, partialTicks));
        ConfigTheme.Scrollbar scrollbar = this.theme.getScrollbar();
        ArrayConfigScreen.renderScrollbar(graphics, this.field_22789 - scrollbar.width(), 35, scrollbar.width(), this.field_22790 - 30 - 35, this.index, this.getTotalSize(), this.pageSize, scrollbar.backgroundColor());
        this.renderPost(graphics, partialTicks);
    }

    public boolean method_25401(double mouseX, double mouseY, double amountX, double amountY) {
        int scale = (int)(-amountY);
        int next = this.index + scale;
        if (next >= 0 && next + this.pageSize <= this.getTotalSize()) {
            this.index = next;
            this.method_25423(this.field_22787, this.field_22789, this.field_22790);
            return true;
        }
        return false;
    }

    private int getTotalSize() {
        int elementSize = this.sizeSupplier.get();
        if (!this.fixedSize) {
            ++elementSize;
        }
        return elementSize;
    }

    public static <V> TypeAdapter.AdapterContext callbackCtx(Field parent, Class<V> componentType, BiConsumer<V, Integer> callback, int index) {
        return new DummyCallbackAdapter<V>(componentType, parent, callback, index);
    }

    @FunctionalInterface
    public static interface DummyConfigValueFactory {
        public ConfigValue<?> create(String var1, int var2);
    }

    @FunctionalInterface
    public static interface ElementAddHandler {
        public void insertElement();
    }

    @FunctionalInterface
    public static interface ElementRemoveHandler<V> {
        public void removeElementAt(int var1, ArrayTrimmer<V> var2);

        @FunctionalInterface
        public static interface ArrayTrimmer<V> {
            public V trim(int var1, V var2, V var3);
        }
    }

    private static class DummyCallbackAdapter<V>
    implements TypeAdapter.AdapterContext {
        private final TypeAdapter<?> typeAdapter;
        private final Field parentField;
        private final BiConsumer<V, Integer> setCallback;
        private final int index;

        private DummyCallbackAdapter(Class<V> type, Field parentField, BiConsumer<V, Integer> setCallback, int index) {
            this.typeAdapter = TypeAdapterManager.forType(type).adapter();
            this.parentField = parentField;
            this.setCallback = setCallback;
            this.index = index;
        }

        @Override
        public TypeAdapter<?> getAdapter() {
            return this.typeAdapter;
        }

        @Override
        public Field getOwner() {
            return this.parentField;
        }

        @Override
        public void setFieldValue(Object value) {
            this.setCallback.accept(value, this.index);
        }

        @Override
        public void setValue(Object value) {
            this.setCallback.accept(value, this.index);
        }
    }
}

