/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.configuration.client.screen;

import dev.toma.configuration.Configuration;
import dev.toma.configuration.ConfigurationOptions;
import dev.toma.configuration.client.screen.AbstractConfigScreen;
import dev.toma.configuration.client.theme.ConfigTheme;
import dev.toma.configuration.client.theme.adapter.DisplayAdapter;
import dev.toma.configuration.client.widget.ConfigEntryWidget;
import dev.toma.configuration.config.ConfigHolder;
import dev.toma.configuration.config.adapter.TypeAdapter;
import dev.toma.configuration.config.value.ConfigValue;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_5348;
import org.apache.logging.log4j.message.FormattedMessage;
import org.apache.logging.log4j.message.Message;

public class ConfigScreen
extends AbstractConfigScreen {
    private final Map<String, ConfigValue<?>> configValueMap;
    private final Map<String, ConfigValue<?>> valueMap = new LinkedHashMap();

    public ConfigScreen(ConfigHolder<?> configHolder, class_2561 screenTitle, Map<String, ConfigValue<?>> valueMap, class_437 previous) {
        super(screenTitle, previous, configHolder);
        this.configValueMap = valueMap;
    }

    protected void method_25426() {
        int viewportMin = 35;
        int viewportHeight = this.field_22790 - 35 - 30;
        this.valueMap.clear();
        ConfigurationOptions options = Configuration.options.getConfigInstance();
        for (Map.Entry<String, ConfigValue<?>> entry : this.configValueMap.entrySet()) {
            ConfigValue<?> value = entry.getValue();
            if (!value.getFieldVisibility().isVisible(options)) continue;
            this.valueMap.put(entry.getKey(), value);
        }
        int spacing = 22;
        this.pageSize = (viewportHeight - 20) / spacing;
        this.correctScrollingIndex(this.valueMap.size());
        ArrayList values = new ArrayList(this.valueMap.values());
        int errorOffset = viewportHeight - 20 - (this.pageSize * spacing - 5);
        int offset = 0;
        for (int i = this.index; i < this.index + this.pageSize; ++i) {
            int j = i - this.index;
            if (i >= values.size()) break;
            int correct = errorOffset / (this.pageSize - j);
            errorOffset -= correct;
            ConfigValue value = (ConfigValue)values.get(i);
            ConfigEntryWidget widget = (ConfigEntryWidget)this.method_37063((class_364)new ConfigEntryWidget(30, 45 + j * spacing + (offset += correct), this.field_22789 - 60, 20, value, this.getConfigId(), this.theme));
            widget.setDescriptionRenderer(this);
            TypeAdapter.AdapterContext context = value.getSerializationContext();
            Field field = context.getOwner();
            DisplayAdapter adapter = this.theme.getAdapter(field.getType());
            if (adapter == null) {
                Configuration.LOGGER.error(MARKER, "Missing display adapter for {} type, will not be displayed in GUI", (Object)field.getType().getSimpleName());
                continue;
            }
            try {
                adapter.placeWidgets(this.holder, value, field, this.theme, widget);
                continue;
            }
            catch (ClassCastException e) {
                Configuration.LOGGER.error(MARKER, (Message)new FormattedMessage("Unable to create config field for {}", (Object)field.getType().getSimpleName()), (Throwable)e);
            }
        }
        this.addSettingsButton();
        this.addFooter();
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        if (ConfigScreen.canRenderBackground(this.field_22787)) {
            ConfigTheme.Header themeHeader = this.theme.getHeader();
            ConfigTheme.Footer footer = this.theme.getFooter();
            class_2561 headerLabel = themeHeader.customText() != null ? themeHeader.customText() : this.field_22785;
            int titleWidth = this.field_22793.method_27525((class_5348)headerLabel);
            graphics.method_25294(0, 0, this.field_22789, 35, themeHeader.backgroundColor());
            int n = (this.field_22789 - titleWidth) / 2;
            Objects.requireNonNull(this.field_22793);
            graphics.method_51439(this.field_22793, headerLabel, n, (35 - 9) / 2, themeHeader.foregroundColor(), true);
            graphics.method_25294(0, this.field_22790 - 30, this.field_22789, this.field_22790, footer.backgroundColor());
            Integer fillColor = this.theme.getBackgroundFillColor();
            if (fillColor != null) {
                graphics.method_25294(0, 35, this.field_22789, this.field_22790 - 30, fillColor.intValue());
            }
        }
        this.field_33816.forEach(renderable -> renderable.method_25394(graphics, mouseX, mouseY, partialTicks));
        ConfigTheme.Scrollbar scrollbar = this.theme.getScrollbar();
        ConfigScreen.renderScrollbar(graphics, this.field_22789 - scrollbar.width(), 35, scrollbar.width(), this.field_22790 - 30 - 35, this.index, this.valueMap.size(), this.pageSize, scrollbar.backgroundColor());
        this.renderPost(graphics, partialTicks);
    }

    public boolean method_25401(double mouseX, double mouseY, double amountX, double amountY) {
        int scale = (int)(-amountY);
        int next = this.index + scale;
        if (next >= 0 && next + this.pageSize <= this.valueMap.size()) {
            this.index = next;
            this.method_25423(this.field_22787, this.field_22789, this.field_22790);
            return true;
        }
        return false;
    }
}

