/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.configuration.client.widget;

import dev.toma.configuration.client.theme.ConfigTheme;
import dev.toma.configuration.client.widget.AbstractThemeWidget;
import java.text.DecimalFormat;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.class_10799;
import net.minecraft.class_1144;
import net.minecraft.class_11905;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_3544;
import net.minecraft.class_5250;
import net.minecraft.class_5481;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import net.minecraft.class_8666;

public class EditBoxWidget
extends AbstractThemeWidget {
    public static final class_8666 SPRITES = new class_8666(class_2960.method_60656((String)"widget/text_field"), class_2960.method_60656((String)"widget/text_field_highlighted"));
    private static final int CURSOR_INSERT_COLOR = -3092272;
    private static final String CURSOR_APPEND_CHARACTER = "_";
    private static final int CURSOR_BLINK_INTERVAL_MS = 300;
    private final class_327 font;
    private String value;
    private int maxLength;
    private boolean bordered;
    private boolean canLoseFocus;
    private int displayPos;
    private int cursorPos;
    private int highlightPos;
    private String suggestion;
    private Consumer<String> responder;
    private Predicate<String> filter;
    private BiFunction<String, Integer, class_5481> formatter;
    private class_2561 hint;
    private long focusedTime;
    private NumberFormatter numberFormatter;

    public EditBoxWidget(int x, int y, int width, int height, ConfigTheme theme, class_327 font) {
        super(x, y, width, height, theme);
        this.font = font;
        this.value = "";
        this.maxLength = 32;
        this.bordered = true;
        this.canLoseFocus = true;
        this.filter = Objects::nonNull;
        this.formatter = (text, i) -> class_5481.method_30747((String)text, (class_2583)class_2583.field_24360);
        this.focusedTime = class_156.method_658();
    }

    public void setFormatter(DecimalFormat formatter, Supplier<Number> provider) {
        this.numberFormatter = formatter != null ? new NumberFormatter(formatter, provider) : null;
    }

    public void setResponder(Consumer<String> $$0) {
        this.responder = $$0;
    }

    public void setFormatter(BiFunction<String, Integer, class_5481> $$0) {
        this.formatter = $$0;
    }

    protected class_5250 method_25360() {
        class_2561 $$0 = this.method_25369();
        return class_2561.method_43469((String)"gui.narrate.editBox", (Object[])new Object[]{$$0, this.value});
    }

    public void setValue(String value) {
        if (this.filter.test(value)) {
            this.value = value.length() > this.maxLength ? value.substring(0, this.maxLength) : value;
            this.moveCursorToEnd(false);
            this.setHighlightPos(this.cursorPos);
            this.onValueChange(value);
        }
    }

    public String getValue() {
        return this.value;
    }

    public String getHighlighted() {
        int $$0 = Math.min(this.cursorPos, this.highlightPos);
        int $$1 = Math.max(this.cursorPos, this.highlightPos);
        return this.value.substring($$0, $$1);
    }

    public void setFilter(Predicate<String> filter) {
        this.filter = filter;
    }

    public void insertText(String text) {
        int selectMin = Math.min(this.cursorPos, this.highlightPos);
        int selectMax = Math.max(this.cursorPos, this.highlightPos);
        int maxWidth = this.maxLength - this.value.length() - (selectMin - selectMax);
        if (maxWidth > 0) {
            String transformedText;
            String filteredText = class_3544.method_57180((String)text);
            int width = filteredText.length();
            if (maxWidth < width) {
                if (Character.isHighSurrogate(filteredText.charAt(maxWidth - 1))) {
                    --maxWidth;
                }
                filteredText = filteredText.substring(0, maxWidth);
                width = maxWidth;
            }
            if (this.filter.test(transformedText = new StringBuilder(this.value).replace(selectMin, selectMax, filteredText).toString())) {
                this.value = transformedText;
                this.setCursorPosition(selectMin + width);
                this.setHighlightPos(this.cursorPos);
                this.onValueChange(this.value);
            }
        }
    }

    private void onValueChange(String text) {
        if (this.responder != null) {
            this.responder.accept(text);
        }
    }

    private void deleteText(int count, boolean words) {
        if (words) {
            this.deleteWords(count);
        } else {
            this.deleteChars(count);
        }
    }

    public void deleteWords(int count) {
        if (!this.value.isEmpty()) {
            if (this.highlightPos != this.cursorPos) {
                this.insertText("");
            } else {
                this.deleteCharsToPos(this.getWordPosition(count));
            }
        }
    }

    public void deleteChars(int count) {
        this.deleteCharsToPos(this.getCursorPos(count));
    }

    public void deleteCharsToPos(int pos) {
        if (!this.value.isEmpty()) {
            if (this.highlightPos != this.cursorPos) {
                this.insertText("");
            } else {
                String $$3;
                int $$2;
                int $$1 = Math.min(pos, this.cursorPos);
                if ($$1 != ($$2 = Math.max(pos, this.cursorPos)) && this.filter.test($$3 = new StringBuilder(this.value).delete($$1, $$2).toString())) {
                    this.value = $$3;
                    this.moveCursorTo($$1, false);
                }
            }
        }
    }

    public int getWordPosition(int $$0) {
        return this.getWordPosition($$0, this.getCursorPosition());
    }

    private int getWordPosition(int $$0, int $$1) {
        return this.getWordPosition($$0, $$1, true);
    }

    private int getWordPosition(int $$0, int $$1, boolean $$2) {
        int $$3 = $$1;
        boolean $$4 = $$0 < 0;
        int $$5 = Math.abs($$0);
        for (int $$6 = 0; $$6 < $$5; ++$$6) {
            if (!$$4) {
                int $$7 = this.value.length();
                if (($$3 = this.value.indexOf(32, $$3)) == -1) {
                    $$3 = $$7;
                    continue;
                }
                while ($$2 && $$3 < $$7 && this.value.charAt($$3) == ' ') {
                    ++$$3;
                }
                continue;
            }
            while ($$2 && $$3 > 0 && this.value.charAt($$3 - 1) == ' ') {
                --$$3;
            }
            while ($$3 > 0 && this.value.charAt($$3 - 1) != ' ') {
                --$$3;
            }
        }
        return $$3;
    }

    public void moveCursor(int $$0, boolean $$1) {
        this.moveCursorTo(this.getCursorPos($$0), $$1);
    }

    private int getCursorPos(int $$0) {
        return class_156.method_27761((String)this.value, (int)this.cursorPos, (int)$$0);
    }

    public void moveCursorTo(int $$0, boolean $$1) {
        this.setCursorPosition($$0);
        if (!$$1) {
            this.setHighlightPos(this.cursorPos);
        }
        this.onValueChange(this.value);
    }

    public void setCursorPosition(int $$0) {
        this.cursorPos = class_3532.method_15340((int)$$0, (int)0, (int)this.value.length());
        this.scrollTo(this.cursorPos);
    }

    public void moveCursorToStart(boolean $$0) {
        this.moveCursorTo(0, $$0);
    }

    public void moveCursorToEnd(boolean $$0) {
        this.moveCursorTo(this.value.length(), $$0);
    }

    public boolean method_25404(class_11908 event) {
        if (this.method_37303() && this.method_25370()) {
            switch (event.comp_4795()) {
                case 259: {
                    this.deleteText(-1, event.method_74240());
                    return true;
                }
                default: {
                    if (event.method_74241()) {
                        this.moveCursorToEnd(false);
                        this.setHighlightPos(0);
                        return true;
                    }
                    if (event.method_74242()) {
                        class_310.method_1551().field_1774.method_1455(this.getHighlighted());
                        return true;
                    }
                    if (event.method_74243()) {
                        this.insertText(class_310.method_1551().field_1774.method_1460());
                        return true;
                    }
                    if (event.method_74244()) {
                        class_310.method_1551().field_1774.method_1455(this.getHighlighted());
                        this.insertText("");
                        return true;
                    }
                    return false;
                }
                case 261: {
                    this.deleteText(1, event.method_74240());
                    return true;
                }
                case 262: {
                    if (event.method_74240()) {
                        this.moveCursorTo(this.getWordPosition(1), event.method_74239());
                    } else {
                        this.moveCursor(1, event.method_74239());
                    }
                    return true;
                }
                case 263: {
                    if (event.method_74240()) {
                        this.moveCursorTo(this.getWordPosition(-1), event.method_74239());
                    } else {
                        this.moveCursor(-1, event.method_74239());
                    }
                    return true;
                }
                case 268: {
                    this.moveCursorToStart(event.method_74239());
                    return true;
                }
                case 269: 
            }
            this.moveCursorToEnd(event.method_74239());
            return true;
        }
        return false;
    }

    public boolean canConsumeInput() {
        return this.method_37303() && this.method_25370();
    }

    public boolean method_25400(class_11905 event) {
        if (!this.canConsumeInput()) {
            return false;
        }
        if (event.method_74227()) {
            if (this.method_37303()) {
                this.insertText(event.method_74226());
            }
            return true;
        }
        return false;
    }

    public void method_25348(class_11909 event, boolean doubleClick) {
        if (doubleClick) {
            this.selectWord(event);
        } else {
            this.moveCursorTo(this.findClickedPositionInText(event), event.method_74239());
        }
    }

    private int findClickedPositionInText(class_11909 event) {
        int i = Math.min(class_3532.method_15357((double)event.comp_4798()), this.getInnerWidth());
        String s = this.value.substring(this.displayPos);
        return this.displayPos + this.font.method_27523(s, i).length();
    }

    private void selectWord(class_11909 event) {
        int i = this.findClickedPositionInText(event);
        int j = this.getWordPosition(-1, i);
        int k = this.getWordPosition(1, i);
        this.moveCursorTo(j, false);
        this.moveCursorTo(k, true);
    }

    public void method_25354(class_1144 manager) {
    }

    public void method_48579(class_332 graphics, int mouseX, int mouseY, float deltaTick) {
        if (this.isVisible()) {
            int var10005;
            int var10004;
            int var10003;
            if (this.isBordered()) {
                this.renderBackground(graphics);
            }
            int textColor = this.theme.getWidgetTextColor(this.field_22763, this.method_25367());
            int position = this.cursorPos - this.displayPos;
            String displayValue = this.numberFormatter != null && !this.method_25370() ? this.numberFormatter.applyFormat() : this.value;
            String label = this.font.method_27523(displayValue.substring(this.displayPos), this.getInnerWidth());
            boolean cursorAtEnd = position >= 0 && position <= label.length();
            boolean blink = this.method_25370() && (class_156.method_658() - this.focusedTime) / 300L % 2L == 0L && cursorAtEnd;
            int left = this.bordered ? this.method_46426() + 4 : this.method_46426();
            int top = this.bordered ? this.method_46427() + (this.field_22759 - 8) / 2 : this.method_46427();
            int textLeft = left;
            int $$13 = class_3532.method_15340((int)(this.highlightPos - this.displayPos), (int)0, (int)label.length());
            if (!label.isEmpty()) {
                String renderString = cursorAtEnd ? label.substring(0, position) : label;
                class_5481 sequence = this.formatter.apply(renderString, this.displayPos);
                graphics.method_35720(this.font, sequence, textLeft, top, textColor);
                textLeft += this.font.method_30880(sequence) + 1;
            }
            boolean $$15 = this.cursorPos < displayValue.length() || displayValue.length() >= this.getMaxLength();
            int $$16 = textLeft;
            if (!cursorAtEnd) {
                $$16 = position > 0 ? left + this.field_22758 : left;
            } else if ($$15) {
                --$$16;
                --textLeft;
            }
            if (!label.isEmpty() && cursorAtEnd && position < label.length()) {
                graphics.method_35720(this.font, this.formatter.apply(label.substring(position), this.cursorPos), textLeft, top, textColor);
            }
            if (this.hint != null && label.isEmpty() && !this.method_25370()) {
                graphics.method_27535(this.font, this.hint, textLeft, top, textColor);
            }
            if (!$$15 && this.suggestion != null) {
                graphics.method_25303(this.font, this.suggestion, $$16 - 1, top, -8355712);
            }
            if (blink) {
                if ($$15) {
                    var10003 = top - 1;
                    var10004 = $$16 + 1;
                    var10005 = top + 1;
                    graphics.method_25294($$16, var10003, var10004, var10005 + 9, -3092272);
                } else {
                    graphics.method_25303(this.font, CURSOR_APPEND_CHARACTER, $$16, top, textColor);
                }
            }
            if ($$13 != position && this.method_25370()) {
                int $$17 = left + this.font.method_1727(label.substring(0, $$13));
                var10003 = top - 1;
                var10004 = $$17 - 1;
                var10005 = top + 1;
                this.renderHighlight(graphics, $$16, var10003, var10004, var10005 + 9);
            }
        }
    }

    private void renderHighlight(class_332 graphics, int x1, int y1, int x2, int y2) {
        int $$6;
        if (x1 < x2) {
            $$6 = x1;
            x1 = x2;
            x2 = $$6;
        }
        if (y1 < y2) {
            $$6 = y1;
            y1 = y2;
            y2 = $$6;
        }
        if (x2 > this.method_46426() + this.field_22758) {
            x2 = this.method_46426() + this.field_22758;
        }
        if (x1 > this.method_46426() + this.field_22758) {
            x1 = this.method_46426() + this.field_22758;
        }
        graphics.method_48196(class_10799.field_56881, x1, y1, x2, y2, -16776961);
    }

    public void setMaxLength(int maxLength) {
        this.maxLength = maxLength;
        if (this.value.length() > maxLength) {
            this.value = this.value.substring(0, maxLength);
            this.onValueChange(this.value);
        }
    }

    private int getMaxLength() {
        return this.maxLength;
    }

    public int getCursorPosition() {
        return this.cursorPos;
    }

    public boolean isBordered() {
        return this.bordered;
    }

    public void setBordered(boolean bordered) {
        this.bordered = bordered;
    }

    public void method_25365(boolean focused) {
        if (this.canLoseFocus || focused) {
            super.method_25365(focused);
            if (focused) {
                this.focusedTime = class_156.method_658();
            }
        }
    }

    public int getInnerWidth() {
        return this.isBordered() ? this.field_22758 - 8 : this.field_22758;
    }

    public void setHighlightPos(int pos) {
        this.highlightPos = class_3532.method_15340((int)pos, (int)0, (int)this.value.length());
        this.scrollTo(this.highlightPos);
    }

    private void scrollTo(int position) {
        if (this.font != null) {
            this.displayPos = Math.min(this.displayPos, this.value.length());
            int $$1 = this.getInnerWidth();
            String $$2 = this.font.method_27523(this.value.substring(this.displayPos), $$1);
            int $$3 = $$2.length() + this.displayPos;
            if (position == this.displayPos) {
                this.displayPos -= this.font.method_27524(this.value, $$1, true).length();
            }
            if (position > $$3) {
                this.displayPos += position - $$3;
            } else if (position <= this.displayPos) {
                this.displayPos -= this.displayPos - position;
            }
            this.displayPos = class_3532.method_15340((int)this.displayPos, (int)0, (int)this.value.length());
        }
    }

    public void setCanLoseFocus(boolean canLoseFocus) {
        this.canLoseFocus = canLoseFocus;
    }

    public boolean isVisible() {
        return this.field_22764;
    }

    public void setVisible(boolean visible) {
        this.field_22764 = visible;
    }

    public void setSuggestion(String suggestion) {
        this.suggestion = suggestion;
    }

    public int getScreenX(int $$0) {
        return $$0 > this.value.length() ? this.method_46426() : this.method_46426() + this.font.method_1727(this.value.substring(0, $$0));
    }

    @Override
    public void method_47399(class_6382 output) {
        output.method_37034(class_6381.field_33788, (class_2561)this.method_25360());
    }

    public void setHint(class_2561 $$0) {
        this.hint = $$0;
    }

    public record NumberFormatter(DecimalFormat format, Supplier<Number> value) {
        public String applyFormat() {
            return this.format.format(this.value.get());
        }
    }
}

