/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.configuration.client.widget;

import dev.toma.configuration.client.theme.ConfigTheme;
import dev.toma.configuration.client.widget.AbstractThemeWidget;
import dev.toma.configuration.client.widget.render.IRenderer;
import dev.toma.configuration.config.value.NumericValue;
import java.text.DecimalFormat;
import net.minecraft.class_1144;
import net.minecraft.class_11909;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_6382;
import net.minecraft.class_8666;

public class SliderWidget<N extends Number>
extends AbstractThemeWidget {
    public static final class_8666 SLIDER = new class_8666(class_2960.method_60656((String)"widget/slider"), class_2960.method_60656((String)"widget/slider_highlighted"));
    public static final class_8666 HANDLE = new class_8666(class_2960.method_60656((String)"widget/slider_handle"), class_2960.method_60656((String)"widget/slider_handle_highlighted"));
    protected final class_327 font;
    protected final NumericValue<N> numericValue;
    protected IRenderer handleRenderer;
    protected double value;
    protected N num;
    private DecimalFormat decimalFormat;

    public SliderWidget(int x, int y, int width, int height, ConfigTheme theme, NumericValue<N> numericValue, class_327 font) {
        super(x, y, width, height, theme);
        this.numericValue = numericValue;
        this.value = numericValue.getSliderValue();
        this.font = font;
        this.updateDisplayText();
    }

    public void setFormatter(DecimalFormat decimalFormat) {
        this.decimalFormat = decimalFormat;
        this.updateDisplayText();
    }

    public void setHandleRenderer(IRenderer handleRenderer) {
        this.handleRenderer = handleRenderer;
    }

    protected void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float deltaTick) {
        this.renderBackground(guiGraphics);
        this.applyRenderer(this.handleRenderer, guiGraphics, this.method_46426() + (int)(this.value * ((double)this.field_22758 - 8.0)), this.method_46427(), 8, this.method_25364());
        int textColor = this.theme.getWidgetTextColor(this.field_22763, this.field_22762);
        this.method_49604(guiGraphics, this.font, 2, textColor);
    }

    public void method_25348(class_11909 event, boolean doubleClick) {
        this.setValueFromMouse(event.comp_4798());
    }

    private void setValueFromMouse(double x) {
        this.setValue((x - ((double)this.method_46426() + 4.0)) / ((double)this.field_22758 - 8.0));
    }

    public void setValue(double value) {
        double oldValue = this.value;
        this.value = class_3532.method_15350((double)value, (double)0.0, (double)1.0);
        if (oldValue != this.value) {
            N updatedValue = this.numericValue.getValueFromSlider(this.value);
            this.numericValue.setValue(updatedValue);
            this.setChanged();
        }
        this.updateDisplayText();
    }

    protected void updateDisplayText() {
        this.num = (Number)this.numericValue.get();
        this.method_25355((class_2561)class_2561.method_43470((String)(this.decimalFormat != null ? this.decimalFormat.format(this.num) : String.valueOf(this.num))));
    }

    protected void method_25349(class_11909 event, double dragX, double dragY) {
        this.setValueFromMouse(event.comp_4798());
        super.method_25349(event, dragX, dragY);
    }

    public void method_25354(class_1144 $$0) {
    }

    public void method_25357(class_11909 event) {
        super.method_25354(class_310.method_1551().method_1483());
    }

    @Override
    protected void method_47399(class_6382 output) {
    }
}

