/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.configuration.config;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import io.netty.buffer.ByteBuf;
import java.util.regex.Pattern;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public record ConfigValueLocation(String namespace, String path) {
    public static final Pattern PATTERN = Pattern.compile("^[a-zA-Z0-9_-]+:[a-zA-Z0-9/_-]+$");
    public static final String NAMESPACE_SEPARATOR = ":";
    public static final String PATH_SEPARATOR = "/";
    public static final Codec<ConfigValueLocation> CODEC = Codec.STRING.comapFlatMap(string -> {
        try {
            return DataResult.success((Object)ConfigValueLocation.parse(string));
        }
        catch (IllegalArgumentException e) {
            return DataResult.error(() -> "Invalid location: " + string);
        }
    }, ConfigValueLocation::toString);
    public static final class_9139<ByteBuf, ConfigValueLocation> STREAM_CODEC = class_9135.field_48554.method_56432(ConfigValueLocation::parse, ConfigValueLocation::toString);

    public static ConfigValueLocation of(String namespace, String rootDir, String ... subDirs) {
        if (subDirs.length > 0) {
            return new ConfigValueLocation(namespace, rootDir + PATH_SEPARATOR + String.join((CharSequence)PATH_SEPARATOR, subDirs));
        }
        return new ConfigValueLocation(namespace, rootDir);
    }

    public static ConfigValueLocation parse(String location) {
        if (!PATTERN.matcher(location).matches()) {
            throw new IllegalArgumentException("Invalid config location: " + location);
        }
        String[] components = location.split(NAMESPACE_SEPARATOR, 2);
        return new ConfigValueLocation(components[0], components[1]);
    }

    @Override
    public String toString() {
        return this.namespace + NAMESPACE_SEPARATOR + this.path;
    }
}

