/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.configuration.config.format.json;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import dev.toma.configuration.Configuration;
import dev.toma.configuration.config.ConfigUtils;
import dev.toma.configuration.config.exception.ConfigReadException;
import dev.toma.configuration.config.exception.ConfigValueMissingException;
import dev.toma.configuration.config.format.IConfigFormat;
import dev.toma.configuration.config.io.ConfigurationFileManager;
import dev.toma.configuration.config.value.ConfigValue;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.IntFunction;

public final class GsonFormat
implements IConfigFormat {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private final JsonObject root;

    public GsonFormat() {
        this.root = new JsonObject();
    }

    private GsonFormat(JsonObject root) {
        this.root = root;
    }

    @Override
    public void writeBoolean(String field, boolean value) {
        this.root.addProperty(field, Boolean.valueOf(value));
    }

    @Override
    public boolean readBoolean(String field) throws ConfigValueMissingException {
        return this.tryRead(field, JsonElement::getAsBoolean);
    }

    @Override
    public void writeChar(String field, char value) {
        this.root.addProperty(field, Character.valueOf(value));
    }

    @Override
    public char readChar(String field) throws ConfigValueMissingException {
        return this.tryRead(field, element -> {
            String fieldValue = element.getAsString();
            if (fieldValue.isBlank()) {
                throw new UnsupportedOperationException("String value is empty");
            }
            return Character.valueOf(fieldValue.charAt(0));
        }).charValue();
    }

    @Override
    public void writeByte(String field, byte value) {
        this.root.addProperty(field, (Number)value);
    }

    @Override
    public byte readByte(String field) throws ConfigValueMissingException {
        return this.tryRead(field, JsonElement::getAsByte);
    }

    @Override
    public void writeShort(String field, short value) {
        this.root.addProperty(field, (Number)value);
    }

    @Override
    public short readShort(String field) throws ConfigValueMissingException {
        return this.tryRead(field, JsonElement::getAsShort);
    }

    @Override
    public void writeInt(String field, int value) {
        this.root.addProperty(field, (Number)value);
    }

    @Override
    public int readInt(String field) throws ConfigValueMissingException {
        return this.tryRead(field, JsonElement::getAsInt);
    }

    @Override
    public void writeLong(String field, long value) {
        this.root.addProperty(field, (Number)value);
    }

    @Override
    public long readLong(String field) throws ConfigValueMissingException {
        return this.tryRead(field, JsonElement::getAsLong);
    }

    @Override
    public void writeFloat(String field, float value) {
        this.root.addProperty(field, (Number)Float.valueOf(value));
    }

    @Override
    public float readFloat(String field) throws ConfigValueMissingException {
        return this.tryRead(field, JsonElement::getAsFloat).floatValue();
    }

    @Override
    public void writeDouble(String field, double value) {
        this.root.addProperty(field, (Number)value);
    }

    @Override
    public double readDouble(String field) throws ConfigValueMissingException {
        return this.tryRead(field, JsonElement::getAsDouble);
    }

    @Override
    public void writeString(String field, String value) {
        this.root.addProperty(field, value);
    }

    @Override
    public String readString(String field) throws ConfigValueMissingException {
        return this.tryRead(field, JsonElement::getAsString);
    }

    @Override
    public void writeBoolArray(String field, Boolean[] values) {
        this.writeArray(field, values, JsonArray::add);
    }

    @Override
    public Boolean[] readBoolArray(String field) throws ConfigValueMissingException {
        return this.readArray(field, Boolean[]::new, JsonElement::getAsBoolean);
    }

    @Override
    public void writeCharArray(String field, Character[] values) {
        this.writeArray(field, values, JsonArray::add);
    }

    @Override
    public Character[] readCharArray(String field) throws ConfigValueMissingException {
        return this.readArray(field, Character[]::new, element -> {
            String fieldValue = element.getAsString();
            if (fieldValue.isBlank()) {
                throw new UnsupportedOperationException("String value is empty");
            }
            return Character.valueOf(fieldValue.charAt(0));
        });
    }

    @Override
    public void writeByteArray(String field, Byte[] values) {
        this.writeArray(field, values, JsonArray::add);
    }

    @Override
    public Byte[] readByteArray(String field) throws ConfigValueMissingException {
        return this.readArray(field, Byte[]::new, JsonElement::getAsByte);
    }

    @Override
    public void writeShortArray(String field, Short[] values) {
        this.writeArray(field, values, JsonArray::add);
    }

    @Override
    public Short[] readShortArray(String field) throws ConfigValueMissingException {
        return this.readArray(field, Short[]::new, JsonElement::getAsShort);
    }

    @Override
    public void writeIntArray(String field, Integer[] values) {
        this.writeArray(field, values, JsonArray::add);
    }

    @Override
    public Integer[] readIntArray(String field) throws ConfigValueMissingException {
        return this.readArray(field, Integer[]::new, JsonElement::getAsInt);
    }

    @Override
    public void writeLongArray(String field, Long[] values) {
        this.writeArray(field, values, JsonArray::add);
    }

    @Override
    public Long[] readLongArray(String field) throws ConfigValueMissingException {
        return this.readArray(field, Long[]::new, JsonElement::getAsLong);
    }

    @Override
    public void writeFloatArray(String field, Float[] values) {
        this.writeArray(field, values, JsonArray::add);
    }

    @Override
    public Float[] readFloatArray(String field) throws ConfigValueMissingException {
        return this.readArray(field, Float[]::new, JsonElement::getAsFloat);
    }

    @Override
    public void writeDoubleArray(String field, Double[] values) {
        this.writeArray(field, values, JsonArray::add);
    }

    @Override
    public Double[] readDoubleArray(String field) throws ConfigValueMissingException {
        return this.readArray(field, Double[]::new, JsonElement::getAsDouble);
    }

    @Override
    public void writeStringArray(String field, String[] values) {
        this.writeArray(field, values, JsonArray::add);
    }

    @Override
    public String[] readStringArray(String field) throws ConfigValueMissingException {
        return this.readArray(field, String[]::new, JsonElement::getAsString);
    }

    @Override
    public <E extends Enum<E>> void writeEnum(String field, E value) {
        this.root.addProperty(field, value.name());
    }

    @Override
    public <E extends Enum<E>> E readEnum(String field, Class<E> enumClass) throws ConfigValueMissingException {
        String value = this.readString(field);
        return ConfigUtils.getEnumConstant(value, enumClass);
    }

    @Override
    public <E extends Enum<E>> void writeEnumArray(String field, E[] value) {
        String[] strings = (String[])Arrays.stream(value).map(Enum::name).toArray(String[]::new);
        this.writeStringArray(field, strings);
    }

    @Override
    public <E extends Enum<E>> E[] readEnumArray(String field, Class<E> enumClass) throws ConfigValueMissingException {
        String[] strings = this.readStringArray(field);
        Enum[] arr = (Enum[])Array.newInstance(enumClass, strings.length);
        for (int i = 0; i < strings.length; ++i) {
            arr[i] = ConfigUtils.getEnumConstant(strings[i], enumClass);
        }
        return arr;
    }

    @Override
    public void writeMap(String field, Map<String, ConfigValue<?>> value) {
        GsonFormat config = new GsonFormat();
        value.values().forEach(val -> val.serializeValue(config));
        this.root.add(field, (JsonElement)config.root);
    }

    @Override
    public void readMap(String field, Collection<ConfigValue<?>> values) throws ConfigValueMissingException {
        JsonElement element = this.root.get(field);
        if (element == null || !element.isJsonObject()) {
            throw new ConfigValueMissingException("Missing config value: " + field);
        }
        JsonObject object = element.getAsJsonObject();
        GsonFormat config = new GsonFormat(object);
        for (ConfigValue<?> value : values) {
            value.deserializeValue(config);
        }
    }

    @Override
    public void writeFile(File file) throws IOException {
        try (FileWriter writer = new FileWriter(file);){
            writer.write(GSON.toJson((JsonElement)this.root));
        }
    }

    @Override
    public void readFile(File file) throws IOException, ConfigReadException {
        try (FileReader reader = new FileReader(file);){
            try {
                JsonElement element = JsonParser.parseReader((Reader)reader);
                if (!element.isJsonObject()) {
                    throw new ConfigReadException("Gson config must contain JsonObject as root element!");
                }
                JsonObject object = element.getAsJsonObject();
                for (Map.Entry entry : object.entrySet()) {
                    this.root.add((String)entry.getKey(), (JsonElement)entry.getValue());
                }
            }
            catch (JsonParseException e) {
                throw new ConfigReadException("Config read failed", e);
            }
        }
    }

    @Override
    public void addComments(String ... fileComments) {
    }

    private <T> void writeArray(String field, T[] array, BiConsumer<JsonArray, T> elementConsumer) {
        JsonArray ar = new JsonArray();
        for (T t : array) {
            elementConsumer.accept(ar, (JsonArray)t);
        }
        this.root.add(field, (JsonElement)ar);
    }

    private <T> T tryRead(String field, Function<JsonElement, T> function) throws ConfigValueMissingException {
        JsonElement element = this.root.get(field);
        if (element == null) {
            throw new ConfigValueMissingException("Missing value: " + field);
        }
        try {
            return function.apply(element);
        }
        catch (Exception e) {
            Configuration.LOGGER.error(ConfigurationFileManager.MARKER, "Error loading value for field {} - {}", (Object)field, (Object)e);
            throw new ConfigValueMissingException("Invalid value");
        }
    }

    private <T> T[] readArray(String field, IntFunction<T[]> arrayFactory, Function<JsonElement, T> function) throws ConfigValueMissingException {
        JsonElement element = this.root.get(field);
        if (element == null || !element.isJsonArray()) {
            throw new ConfigValueMissingException("Missing value: " + field);
        }
        JsonArray array = element.getAsJsonArray();
        T[] arr = arrayFactory.apply(array.size());
        try {
            int j = 0;
            for (JsonElement el : array) {
                arr[j++] = function.apply(el);
            }
            return arr;
        }
        catch (Exception e) {
            Configuration.LOGGER.error(ConfigurationFileManager.MARKER, "Error loading value for field {} - {}", (Object)field, (Object)e);
            throw new ConfigValueMissingException("Invalid value");
        }
    }
}

