/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.configuration.config.format.yaml;

import dev.toma.configuration.config.ConfigUtils;
import dev.toma.configuration.config.exception.ConfigReadException;
import dev.toma.configuration.config.exception.ConfigValueMissingException;
import dev.toma.configuration.config.format.IConfigFormat;
import dev.toma.configuration.config.value.ConfigValue;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Pattern;

public class YamlFormat
implements IConfigFormat {
    private final StringBuilder buffer;
    private final int currentNesting;
    private final Map<String, Object> processedData;
    private int readerIndex;

    public YamlFormat() {
        this.buffer = new StringBuilder();
        this.currentNesting = 0;
        this.processedData = new HashMap<String, Object>();
    }

    public YamlFormat(StringBuilder buffer, int nesting) {
        this.buffer = buffer;
        this.currentNesting = nesting;
        this.processedData = new HashMap<String, Object>();
    }

    public YamlFormat(Map<String, Object> processed) {
        this.buffer = null;
        this.currentNesting = 0;
        this.processedData = processed;
    }

    @Override
    public void writeBoolean(String field, boolean value) {
        this.writeValuePair(field, String.valueOf(value));
    }

    @Override
    public boolean readBoolean(String field) throws ConfigValueMissingException {
        return this.getValue(field, Boolean::parseBoolean);
    }

    @Override
    public void writeChar(String field, char value) {
        this.writeValuePair(field, String.valueOf(value));
    }

    @Override
    public char readChar(String field) throws ConfigValueMissingException {
        return this.getValue(field, str -> Character.valueOf(str.charAt(0))).charValue();
    }

    @Override
    public void writeByte(String field, byte value) {
        this.writeValuePair(field, String.valueOf(value));
    }

    @Override
    public byte readByte(String field) throws ConfigValueMissingException {
        return this.getValue(field, Byte::parseByte);
    }

    @Override
    public void writeShort(String field, short value) {
        this.writeValuePair(field, String.valueOf(value));
    }

    @Override
    public short readShort(String field) throws ConfigValueMissingException {
        return this.getValue(field, Short::parseShort);
    }

    @Override
    public void writeInt(String field, int value) {
        this.writeValuePair(field, String.valueOf(value));
    }

    @Override
    public int readInt(String field) throws ConfigValueMissingException {
        return this.getValue(field, Integer::parseInt);
    }

    @Override
    public void writeLong(String field, long value) {
        this.writeValuePair(field, String.valueOf(value));
    }

    @Override
    public long readLong(String field) throws ConfigValueMissingException {
        return this.getValue(field, Long::parseLong);
    }

    @Override
    public void writeFloat(String field, float value) {
        this.writeValuePair(field, String.valueOf(value));
    }

    @Override
    public float readFloat(String field) throws ConfigValueMissingException {
        return this.getValue(field, Float::parseFloat).floatValue();
    }

    @Override
    public void writeDouble(String field, double value) {
        this.writeValuePair(field, String.valueOf(value));
    }

    @Override
    public double readDouble(String field) throws ConfigValueMissingException {
        return this.getValue(field, Double::parseDouble);
    }

    @Override
    public void writeString(String field, String value) {
        this.writeValuePair(field, value);
    }

    @Override
    public String readString(String field) throws ConfigValueMissingException {
        return (String)this.getValue(field, Function.identity());
    }

    @Override
    public void writeBoolArray(String field, Boolean[] values) {
        this.writeKey(field);
        for (Boolean value : values) {
            this.writeArrayEntry(String.valueOf(value));
        }
    }

    @Override
    public Boolean[] readBoolArray(String field) throws ConfigValueMissingException {
        String[] arr = this.getValueArray(field);
        Boolean[] res = new Boolean[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            res[i] = Boolean.parseBoolean(arr[i]);
        }
        return res;
    }

    @Override
    public void writeCharArray(String field, Character[] values) {
        this.writeKey(field);
        for (Character value : values) {
            this.writeArrayEntry(String.valueOf(value));
        }
    }

    @Override
    public Character[] readCharArray(String field) throws ConfigValueMissingException {
        String[] arr = this.getValueArray(field);
        Character[] res = new Character[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            res[i] = Character.valueOf(arr[i].charAt(0));
        }
        return res;
    }

    @Override
    public void writeByteArray(String field, Byte[] values) {
        this.writeKey(field);
        for (Byte value : values) {
            this.writeArrayEntry(String.valueOf(value));
        }
    }

    @Override
    public Byte[] readByteArray(String field) throws ConfigValueMissingException {
        String[] arr = this.getValueArray(field);
        Byte[] res = new Byte[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            res[i] = Byte.parseByte(arr[i]);
        }
        return res;
    }

    @Override
    public void writeShortArray(String field, Short[] values) {
        this.writeKey(field);
        for (Short value : values) {
            this.writeArrayEntry(String.valueOf(value));
        }
    }

    @Override
    public Short[] readShortArray(String field) throws ConfigValueMissingException {
        String[] arr = this.getValueArray(field);
        Short[] res = new Short[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            res[i] = Short.parseShort(arr[i]);
        }
        return res;
    }

    @Override
    public void writeIntArray(String field, Integer[] values) {
        this.writeKey(field);
        for (Integer value : values) {
            this.writeArrayEntry(String.valueOf(value));
        }
    }

    @Override
    public Integer[] readIntArray(String field) throws ConfigValueMissingException {
        String[] arr = this.getValueArray(field);
        Integer[] res = new Integer[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            try {
                res[i] = Integer.parseInt(arr[i]);
                continue;
            }
            catch (NumberFormatException e) {
                throw new ConfigValueMissingException("Invalid value: " + field);
            }
        }
        return res;
    }

    @Override
    public void writeLongArray(String field, Long[] values) {
        this.writeKey(field);
        for (Long value : values) {
            this.writeArrayEntry(String.valueOf(value));
        }
    }

    @Override
    public Long[] readLongArray(String field) throws ConfigValueMissingException {
        String[] arr = this.getValueArray(field);
        Long[] res = new Long[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            try {
                res[i] = Long.parseLong(arr[i]);
                continue;
            }
            catch (NumberFormatException e) {
                throw new ConfigValueMissingException("Invalid value: " + field);
            }
        }
        return res;
    }

    @Override
    public void writeFloatArray(String field, Float[] values) {
        this.writeKey(field);
        for (Float value : values) {
            this.writeArrayEntry(String.valueOf(value));
        }
    }

    @Override
    public Float[] readFloatArray(String field) throws ConfigValueMissingException {
        String[] arr = this.getValueArray(field);
        Float[] res = new Float[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            try {
                res[i] = Float.valueOf(Float.parseFloat(arr[i]));
                continue;
            }
            catch (NumberFormatException e) {
                throw new ConfigValueMissingException("Invalid value: " + field);
            }
        }
        return res;
    }

    @Override
    public void writeDoubleArray(String field, Double[] values) {
        this.writeKey(field);
        for (Double value : values) {
            this.writeArrayEntry(String.valueOf(value));
        }
    }

    @Override
    public Double[] readDoubleArray(String field) throws ConfigValueMissingException {
        String[] arr = this.getValueArray(field);
        Double[] res = new Double[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            try {
                res[i] = Double.parseDouble(arr[i]);
                continue;
            }
            catch (NumberFormatException e) {
                throw new ConfigValueMissingException("Invalid value: " + field);
            }
        }
        return res;
    }

    @Override
    public void writeStringArray(String field, String[] values) {
        this.writeKey(field);
        for (String value : values) {
            this.writeArrayEntry(value);
        }
    }

    @Override
    public String[] readStringArray(String field) throws ConfigValueMissingException {
        return this.getValueArray(field);
    }

    @Override
    public <E extends Enum<E>> void writeEnum(String field, E value) {
        this.writeValuePair(field, value.name());
    }

    @Override
    public <E extends Enum<E>> E readEnum(String field, Class<E> enumClass) throws ConfigValueMissingException {
        String name = this.readString(field);
        return ConfigUtils.getEnumConstant(name, enumClass);
    }

    @Override
    public <E extends Enum<E>> void writeEnumArray(String field, E[] value) {
        String[] strings = (String[])Arrays.stream(value).map(Enum::name).toArray(String[]::new);
        this.writeStringArray(field, strings);
    }

    @Override
    public <E extends Enum<E>> E[] readEnumArray(String field, Class<E> enumClass) throws ConfigValueMissingException {
        String[] strings = this.readStringArray(field);
        Enum[] arr = (Enum[])Array.newInstance(enumClass, strings.length);
        for (int i = 0; i < strings.length; ++i) {
            arr[i] = ConfigUtils.getEnumConstant(strings[i], enumClass);
        }
        return arr;
    }

    @Override
    public void writeMap(String field, Map<String, ConfigValue<?>> value) {
        this.writeKey(field);
        YamlFormat format = new YamlFormat(this.buffer, this.currentNesting + 1);
        value.values().forEach(val -> val.serializeValue(format));
    }

    @Override
    public void readMap(String field, Collection<ConfigValue<?>> values) throws ConfigValueMissingException {
        Map<String, Object> map = this.getValueMap(field);
        YamlFormat format = new YamlFormat(map);
        values.forEach(val -> val.deserializeValue(format));
    }

    @Override
    public void readFile(File file) throws IOException, ConfigReadException {
        ArrayList<String> lines = new ArrayList<String>();
        try (BufferedReader reader = new BufferedReader(new FileReader(file));){
            String line;
            while ((line = reader.readLine()) != null) {
                String editedText = line.replaceAll("^[\\s|\\t]*#.+$", "");
                if (editedText.isEmpty()) continue;
                lines.add(editedText);
            }
        }
        try {
            while (this.readerIndex < lines.size()) {
                this.process(lines);
            }
        }
        catch (Exception e) {
            throw new ConfigReadException("Config process failed", e);
        }
    }

    private void process(List<String> list) throws ConfigReadException {
        String value = list.get(this.readerIndex);
        String[] components = value.split(":\\s*", 2);
        Pattern pattern = Pattern.compile("^.+:\\s?\n?$");
        if (components.length == 1 || pattern.matcher(value).matches()) {
            if (this.readerIndex == list.size() - 1) {
                this.processedData.put(components[0].trim(), new String[0]);
                ++this.readerIndex;
                return;
            }
            String next = list.get(this.readerIndex + 1);
            if (next.trim().startsWith("-")) {
                this.processArray(list, components[0].trim());
            } else {
                this.processMap(list, components[0].trim());
            }
            return;
        }
        if (components.length == 2) {
            this.processedData.put(components[0].trim(), components[1].trim());
            ++this.readerIndex;
            return;
        }
        throw new ConfigReadException("Invalid config format");
    }

    private void processMap(List<String> list, String key) throws ConfigReadException {
        String value;
        int next;
        String prefix = "^ {2}";
        ArrayList<String> newValues = new ArrayList<String>();
        while (this.readerIndex < list.size() && (next = this.readerIndex + 1) < list.size() && (value = list.get(next)).startsWith("  ")) {
            newValues.add(value.replaceFirst(prefix, ""));
            ++this.readerIndex;
        }
        YamlFormat format = new YamlFormat(new HashMap<String, Object>());
        while (format.readerIndex < newValues.size()) {
            format.process(newValues);
        }
        this.processedData.put(key, format.processedData);
        ++this.readerIndex;
    }

    private void processArray(List<String> list, String key) {
        String entry;
        ++this.readerIndex;
        ArrayList<String> entries = new ArrayList<String>();
        while (this.readerIndex < list.size() && (entry = list.get(this.readerIndex).trim()).startsWith("-")) {
            entries.add(entry.replaceAll("^-\\s", ""));
            ++this.readerIndex;
        }
        this.processedData.put(key, entries.toArray(new String[0]));
    }

    @Override
    public void writeFile(File file) throws IOException {
        try (FileWriter writer = new FileWriter(file);){
            writer.write(this.buffer.toString());
        }
    }

    @Override
    public void addComments(String ... fileComments) {
        for (String comment : fileComments) {
            this.spaces();
            this.buffer.append("# ").append(comment).append("\n");
        }
    }

    private void spaces() {
        this.spaces(this.currentNesting);
    }

    private void spaces(int nestIndex) {
        if (nestIndex > 0) {
            this.buffer.append(" ".repeat(Math.max(0, nestIndex * 2)));
        }
    }

    private void writeKey(String key) {
        this.spaces();
        this.buffer.append(key).append(":\n");
    }

    private void writeArrayEntry(String value) {
        this.spaces(this.currentNesting + 1);
        this.buffer.append("- ").append(value).append("\n");
    }

    private void writeValuePair(String key, String value) {
        this.spaces();
        this.buffer.append(key).append(": ").append(value).append("\n");
    }

    private <V> V getValue(String key, Function<String, V> parser) throws ConfigValueMissingException {
        Object value = this.processedData.get(key);
        if (value == null) {
            throw new ConfigValueMissingException("Missing value: " + key);
        }
        try {
            return parser.apply(value.toString());
        }
        catch (ClassCastException | NumberFormatException e) {
            throw new ConfigValueMissingException("Value parse failed: " + key + ", value: " + String.valueOf(value));
        }
    }

    private String[] getValueArray(String key) throws ConfigValueMissingException {
        Object value = this.processedData.get(key);
        if (value == null) {
            throw new ConfigValueMissingException("Missing value: " + key);
        }
        try {
            if (value instanceof Map) {
                return new String[0];
            }
            return (String[])value;
        }
        catch (ClassCastException e) {
            throw new ConfigValueMissingException("Value parse failed: " + key + ", value: " + String.valueOf(value));
        }
    }

    private Map<String, Object> getValueMap(String key) throws ConfigValueMissingException {
        Object value = this.processedData.get(key);
        if (value == null) {
            throw new ConfigValueMissingException("Missing value: " + key);
        }
        try {
            if (value instanceof String[]) {
                return new HashMap<String, Object>();
            }
            return (Map)value;
        }
        catch (ClassCastException e) {
            throw new ConfigValueMissingException("Value parse failed: " + key + ", value: " + String.valueOf(value));
        }
    }
}

