/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.configuration.config.util;

import dev.toma.configuration.config.util.IDescriptionProvider;
import dev.toma.configuration.config.util.NoteDescriptionProvider;
import dev.toma.configuration.config.validate.NumberRange;
import dev.toma.configuration.config.value.IConfigValueReadable;
import dev.toma.configuration.config.value.INumericValue;
import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

public class NumericRangeDescription<N extends Number>
extends NoteDescriptionProvider<N> {
    public static final String LOCALIZATION_KEY = "text.configuration.description.range";

    private NumericRangeDescription() {
    }

    public static <N extends Number> IDescriptionProvider<N> create() {
        return new NumericRangeDescription<N>();
    }

    @Override
    public void appendValues(IConfigValueReadable<N> value, Consumer<class_5250> appender) {
        if (!(value instanceof INumericValue)) {
            return;
        }
        INumericValue numericValue = (INumericValue)((Object)value);
        class_5250 template = NumericRangeDescription.getTemplate(numericValue);
        if (template == null) {
            return;
        }
        appender.accept(template);
    }

    public static <N extends Number> class_5250 getTemplate(INumericValue<N> value) {
        NumberRange<N> range = value.getRange();
        N min = value.min();
        N max = value.max();
        N rangeMin = range.min();
        N rangeMax = range.max();
        if (((Comparable)rangeMin).compareTo(min) <= 0 && ((Comparable)rangeMax).compareTo(max) >= 0) {
            return null;
        }
        if (((Comparable)rangeMin).compareTo(min) > 0 && ((Comparable)rangeMax).compareTo(max) < 0) {
            return class_2561.method_43469((String)LOCALIZATION_KEY, (Object[])new Object[]{range.format(rangeMin), range.format(rangeMax)});
        }
        if (((Comparable)rangeMin).compareTo(min) > 0) {
            return class_2561.method_43469((String)LOCALIZATION_KEY, (Object[])new Object[]{range.format(rangeMin), "..."});
        }
        return class_2561.method_43469((String)LOCALIZATION_KEY, (Object[])new Object[]{"...", range.format(rangeMax)});
    }
}

