/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.configuration.config.validate;

import dev.toma.configuration.config.validate.ValidationResult;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_5244;

public final class ValidationHelper {
    public static final class_2561 CHILD_VALUE_WARNING = class_2561.method_43471((String)"text.configuration.validation.child_failed.warning");
    public static final class_2561 CHILD_VALUE_ERROR = class_2561.method_43471((String)"text.configuration.validation.child_failed.error");

    private ValidationHelper() {
    }

    public static ValidationResult joinChild(ValidationResult r1, ValidationResult r2) {
        ValidationResult.Type result;
        ArrayList<class_2561> messages = new ArrayList<class_2561>();
        ValidationResult.Type s1 = r1 != null ? r1.type() : ValidationResult.Type.SUCCESS;
        ValidationResult.Type s2 = r2 != null ? r2.type() : ValidationResult.Type.SUCCESS;
        ValidationResult.Type type = result = s1.isMoreSevereThan(s2) ? s1 : s2;
        if (result == ValidationResult.Type.SUCCESS) {
            return ValidationResult.success();
        }
        if (r1 != null) {
            messages.addAll(r1.description());
        }
        if (r2 != null && s2.isWarningOrError()) {
            messages.add(class_5244.field_39003);
            messages.add(s2 == ValidationResult.Type.WARNING ? CHILD_VALUE_WARNING : CHILD_VALUE_ERROR);
        }
        return new ValidationResult(result, messages);
    }

    public static ValidationResult aggregate(List<ValidationResult> results) {
        ValidationResult.Type type = ValidationResult.Type.SUCCESS;
        ArrayList<class_2561> messages = new ArrayList<class_2561>();
        if (!results.isEmpty()) {
            Iterator<ValidationResult> iterator = results.iterator();
            while (iterator.hasNext()) {
                ValidationResult result = iterator.next();
                List<class_2561> resultMessages = result.description().stream().filter(c -> c != null && !c.equals((Object)class_5244.field_39003)).toList();
                ValidationResult.Type resultType = result.type();
                if (!resultType.isSameOrMoreSevereThan(ValidationResult.Type.WARNING)) continue;
                messages.addAll(resultMessages);
                if (iterator.hasNext()) {
                    messages.add(class_5244.field_41874);
                }
                type = resultType;
            }
        }
        return new ValidationResult(type, messages);
    }
}

