/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.configuration.config.value;

import dev.toma.configuration.Configuration;
import dev.toma.configuration.config.ConfigUtils;
import dev.toma.configuration.config.Configurable;
import dev.toma.configuration.config.value.ConfigValue;
import dev.toma.configuration.config.value.IArrayValue;
import dev.toma.configuration.config.value.IConfigValue;
import dev.toma.configuration.config.value.IHierarchical;
import dev.toma.configuration.config.value.ValueData;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import net.minecraft.class_2540;
import org.apache.logging.log4j.message.FormattedMessage;
import org.apache.logging.log4j.message.Message;

public abstract class AbstractArrayValue<T>
extends ConfigValue<T[]>
implements IArrayValue<T> {
    private boolean fixedSize;

    public AbstractArrayValue(ValueData<T[]> valueData) {
        super(valueData);
        this.addFixer(this::fixValue);
    }

    @Override
    public boolean isFixedSize() {
        return this.fixedSize;
    }

    @Override
    protected void processAdditionalAnnotations(Field field) {
        this.fixedSize = field.isAnnotationPresent(Configurable.FixedSize.class);
    }

    public <V> Optional<IConfigValue<V>> getChild(Iterator<String> iterator, Class<V> targetType) {
        try {
            return Optional.of(this);
        }
        catch (ClassCastException e) {
            if (Configuration.PLATFORM.isDevelopmentEnvironment()) {
                Configuration.LOGGER.error((Message)new FormattedMessage("Attempted to load invalid config value class for array '{}'", (Object)this.getId()), (Throwable)e);
            }
            return Optional.empty();
        }
    }

    public <V> Optional<V> getChildValue(Iterator<String> iterator, Class<V> targetType) {
        Optional<IConfigValue<V>> optional = this.getChild(iterator, targetType);
        if (optional.isEmpty()) {
            return Optional.empty();
        }
        String key = iterator.next();
        Object[] arrayValue = (Object[])this.get();
        try {
            int length = Array.getLength(arrayValue);
            int elementIndex = Integer.parseInt(key);
            if (elementIndex < 0 || elementIndex >= length) {
                Configuration.LOGGER.warn("Attempted to get array config value '{}' which is out of bounds!", (Object)key);
                return Optional.empty();
            }
            Object item = Array.get(arrayValue, elementIndex);
            if (iterator.hasNext()) {
                if (item instanceof IHierarchical) {
                    IHierarchical hierarchical = (IHierarchical)item;
                    return hierarchical.getChildValue(iterator, targetType);
                }
                Configuration.LOGGER.warn("Attempted to get non-existing value '{}' in config!", (Object)key);
            } else {
                if (targetType.isAssignableFrom(item.getClass())) {
                    return Optional.of(targetType.cast(item));
                }
                Configuration.LOGGER.warn("Attempted to get invalid value type '{}' in config!", (Object)key);
            }
        }
        catch (NumberFormatException e) {
            Configuration.LOGGER.warn("Unexpected array index '{}', expected number", (Object)key);
        }
        catch (Exception e) {
            Configuration.LOGGER.error((Message)new FormattedMessage("Failed to obtain child value for key '{}' due to error", (Object)key), (Throwable)e);
        }
        return Optional.empty();
    }

    @Override
    public IConfigValue<?> getChildById(String childId) {
        return null;
    }

    @Override
    public String toString() {
        return Arrays.toString((Object[])this.getActiveValue());
    }

    @Override
    protected boolean isChanged(T[] saved, T[] pending) {
        return this.isEditable() && !Arrays.equals(saved, pending);
    }

    private T[] fixValue(T[] in) {
        Object[] defaultArray = (Object[])this.valueData.getDefaultValue();
        int defaultSize = defaultArray.length;
        int valueSize = in.length;
        if (this.fixedSize && valueSize != defaultSize) {
            ConfigUtils.logArraySizeCorrectedMessage(this.getId(), Arrays.toString(in), Arrays.toString(defaultArray));
            return defaultArray;
        }
        return in;
    }

    public static <T> void saveToBuffer(T[] value, class_2540 buf, BiConsumer<class_2540, T> encoder) {
        buf.method_53002(value.length);
        for (T t : value) {
            encoder.accept(buf, (class_2540)t);
        }
    }

    public static <T> T[] readFromBuffer(class_2540 buf, IntFunction<T[]> factory, Function<class_2540, T> decoder) {
        int length = buf.readInt();
        T[] value = factory.apply(length);
        for (int i = 0; i < length; ++i) {
            value[i] = decoder.apply(buf);
        }
        return value;
    }

    @Override
    public Collection<ConfigValue<?>> children() {
        return Collections.emptyList();
    }
}

