/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.configuration.config.value;

import dev.toma.configuration.config.adapter.TypeAdapter;
import dev.toma.configuration.config.exception.ConfigValueMissingException;
import dev.toma.configuration.config.format.IConfigFormat;
import dev.toma.configuration.config.value.AbstractArrayValue;
import dev.toma.configuration.config.value.ConfigValue;
import dev.toma.configuration.config.value.IConfigValueReadable;
import dev.toma.configuration.config.value.ValueData;
import net.minecraft.class_2540;

public class BooleanArrayValue
extends AbstractArrayValue<Boolean> {
    public BooleanArrayValue(ValueData<Boolean[]> valueData) {
        super((ValueData<T[]>)valueData);
    }

    @Override
    public Boolean createElementInstance() {
        return false;
    }

    @Override
    protected void serialize(IConfigFormat format) {
        format.writeBoolArray(this.getId(), (Boolean[])this.get(IConfigValueReadable.Mode.SAVED));
    }

    @Override
    protected void deserialize(IConfigFormat format) throws ConfigValueMissingException {
        this.setValue(format.readBoolArray(this.getId()));
    }

    public static final class Adapter
    extends TypeAdapter<Boolean[]> {
        @Override
        public ConfigValue<Boolean[]> serialize(TypeAdapter.TypeAttributes<Boolean[]> attributes, Object instance, TypeAdapter.TypeSerializer serializer) throws IllegalAccessException {
            return new BooleanArrayValue(ValueData.of(attributes));
        }

        @Override
        public void encodeToBuffer(ConfigValue<Boolean[]> value, class_2540 buffer) {
            Boolean[] arr = value.get();
            buffer.method_53002(arr.length);
            for (Boolean b : arr) {
                buffer.method_52964(b.booleanValue());
            }
        }

        @Override
        public Boolean[] decodeFromBuffer(ConfigValue<Boolean[]> value, class_2540 buffer) {
            Boolean[] arr = new Boolean[buffer.readInt()];
            for (int i = 0; i < arr.length; ++i) {
                arr[i] = buffer.readBoolean();
            }
            return arr;
        }
    }
}

