/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.configuration.config.value;

import dev.toma.configuration.Configuration;
import dev.toma.configuration.config.ConfigUtils;
import dev.toma.configuration.config.Configurable;
import dev.toma.configuration.config.FieldVisibility;
import dev.toma.configuration.config.UpdateRestrictions;
import dev.toma.configuration.config.adapter.TypeAdapter;
import dev.toma.configuration.config.exception.ConfigValueMissingException;
import dev.toma.configuration.config.format.IConfigFormat;
import dev.toma.configuration.config.io.ConfigurationFileManager;
import dev.toma.configuration.config.util.IDescriptionProvider;
import dev.toma.configuration.config.util.NoteDescriptionProvider;
import dev.toma.configuration.config.util.ValueListener;
import dev.toma.configuration.config.validate.GameRestartValidator;
import dev.toma.configuration.config.validate.RequiredModValidator;
import dev.toma.configuration.config.validate.SpecificValueValidator;
import dev.toma.configuration.config.validate.ValidationHelper;
import dev.toma.configuration.config.validate.ValidationResult;
import dev.toma.configuration.config.validate.Validator;
import dev.toma.configuration.config.validate.ValueFixer;
import dev.toma.configuration.config.value.IConfigValue;
import dev.toma.configuration.config.value.IConfigValueReadable;
import dev.toma.configuration.config.value.IHierarchical;
import dev.toma.configuration.config.value.ValueData;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_2561;
import org.apache.logging.log4j.message.FormattedMessage;
import org.apache.logging.log4j.message.Message;

public abstract class ConfigValue<T>
implements IConfigValue<T> {
    protected final ValueData<T> valueData;
    private T pendingValue;
    private T activeValue;
    private T networkSavedValue;
    private boolean synchronizeToClient;
    private UpdateRestrictions updateRestriction = UpdateRestrictions.NONE;
    private final List<ValueFixer<T>> correctors = new ArrayList<ValueFixer<T>>();
    private final List<Validator<T>> validators = new ArrayList<Validator<T>>();
    private final List<ValueListener<T>> listeners = new ArrayList<ValueListener<T>>();
    private ValidationResult validationResultHolder;
    private final List<IDescriptionProvider<T>> descriptionProviders = new ArrayList<IDescriptionProvider<T>>();
    private FieldVisibility fieldVisibility = FieldVisibility.NORMAL;

    public ConfigValue(ValueData<T> valueData) {
        this.valueData = valueData;
        this.forceSetValue(this.valueData.getDefaultValue());
    }

    @Override
    public T get(IConfigValueReadable.Mode mode) {
        if (mode != IConfigValueReadable.Mode.SAVED && this.networkSavedValue != null) {
            return this.networkSavedValue;
        }
        if (this.pendingValue == null) {
            return this.activeValue;
        }
        return mode == IConfigValueReadable.Mode.SAVED && this.updateRestriction != UpdateRestrictions.GAME_RESTART ? this.activeValue : this.pendingValue;
    }

    @Override
    public T get() {
        return IConfigValue.super.get();
    }

    public T getActiveValue() {
        return this.activeValue;
    }

    @Override
    public boolean isChanged() {
        return this.pendingValue != null && this.isChanged(this.activeValue, this.pendingValue);
    }

    @Override
    public boolean isChangedFromDefault() {
        T t = this.get();
        return this.isChanged(t, this.valueData.getDefaultValue());
    }

    @Override
    public void save() {
        ConfigurationFileManager.ConfigEnvironment environment = ConfigurationFileManager.getEnvironment();
        if (this.pendingValue != null && this.updateRestriction.canApplyChangeInEnvironment(environment)) {
            this.forceSetValue(this.pendingValue);
            this.pendingValue = null;
        }
    }

    @Override
    public class_2561 getTitle() {
        return this.valueData.getTitle();
    }

    @Override
    public String[] getFileComments() {
        return this.valueData.getFileComments();
    }

    @Override
    public IConfigValue<?> parent() {
        return this.valueData.getParent();
    }

    @Override
    public Collection<String> getChildrenKeys() {
        return Collections.emptyList();
    }

    @Override
    public String getPath() {
        return this.valueData.getFullFieldPath();
    }

    public boolean shouldSynchronize() {
        return this.synchronizeToClient;
    }

    @Override
    public final void setValue(T value) {
        Objects.requireNonNull(value, "Config value cannot be null!");
        if (this.isEditable()) {
            this.pendingValue = this.processNewValue(value);
            this.notifyListeners(this.pendingValue);
            this.valueData.getContext().setValue(value);
        }
    }

    @Override
    public void revertChanges() {
        this.pendingValue = null;
        this.notifyListeners(this.activeValue);
        this.valueData.getContext().setValue(this.activeValue);
    }

    @Override
    public void revertChangesToDefault() {
        this.pendingValue = null;
        this.activeValue = this.valueData.getDefaultValue();
        this.notifyListeners(this.activeValue);
        this.valueData.getContext().setValue(this.activeValue);
    }

    public void clearNetworkValues() {
        this.networkSavedValue = null;
        this.notifyListeners(this.activeValue);
        this.valueData.setValueToMemory(this.activeValue);
    }

    @Override
    public final boolean isEditable() {
        ConfigurationFileManager.ConfigEnvironment environment = ConfigurationFileManager.getEnvironment();
        return this.updateRestriction.isEditableInEnvironment(environment);
    }

    public final void runGameInitEvents() {
        this.validators.forEach(validator -> validator.onGameLoaded(this));
        ConfigValue configValue = this;
        if (configValue instanceof IHierarchical) {
            IHierarchical hierarchical = (IHierarchical)((Object)configValue);
            for (ConfigValue configValue2 : hierarchical.children()) {
                configValue2.runGameInitEvents();
            }
        }
        this.validateAndStoreResult(this.activeValue);
    }

    public final void forceSetValue(T value) {
        T corrected = this.processNewValue(value);
        this.pendingValue = null;
        this.activeValue = corrected;
        this.notifyListeners(this.activeValue);
        this.valueData.setValueToMemory(corrected);
    }

    public final void setFromNetwork(T value) {
        value = this.processNewValue(value);
        this.networkSavedValue = value;
        this.notifyListeners(this.networkSavedValue);
        this.valueData.setValueToMemory(value);
    }

    public final void forceSetDefaultValue() {
        this.forceSetValue(this.valueData.getDefaultValue());
    }

    public final T processNewValue(T in) {
        T fixedValue = in;
        for (ValueFixer<T> fixer : this.correctors) {
            fixedValue = fixer.fixValue(fixedValue);
        }
        if (fixedValue == null) {
            fixedValue = this.valueData.getDefaultValue();
            this.validationResultHolder = null;
        }
        this.validateAndStoreResult(in);
        if (this.validationResultHolder != null && !this.validationResultHolder.isValid()) {
            fixedValue = this.valueData.getDefaultValue();
        }
        return fixedValue;
    }

    public final void validateAndStoreResult(T value) {
        ValidationResult result = this.performAdditionalValidations(value);
        this.validationResultHolder = result.isWarningOrError() ? result : null;
    }

    @Override
    public final String getId() {
        return this.valueData.getId();
    }

    public final void setParent(ConfigValue<?> parent) {
        this.valueData.setParent(parent);
    }

    public final void processAnnotations(Field field) {
        Configurable.Validate validate;
        this.synchronizeToClient = field.isAnnotationPresent(Configurable.Synchronized.class);
        Configurable.UpdateRestriction restriction = field.getAnnotation(Configurable.UpdateRestriction.class);
        if (restriction != null) {
            this.updateRestriction = restriction.value();
            if (this.updateRestriction == UpdateRestrictions.GAME_RESTART && this.shouldSynchronize()) {
                throw new IllegalArgumentException("Config value which can be updated only on game restart cannot be synchronized! Field " + field.getDeclaringClass().getCanonicalName() + "." + field.getName());
            }
            if (this.updateRestriction == UpdateRestrictions.GAME_RESTART) {
                this.addValidator(new GameRestartValidator());
            }
        }
        if (this.shouldSynchronize()) {
            this.updateRestriction = UpdateRestrictions.MAIN_MENU;
            this.addDescriptionProvider(NoteDescriptionProvider.note(NoteDescriptionProvider.SYNCHRONIZED));
        } else if (this.updateRestriction.isRestricted()) {
            this.addDescriptionProvider(NoteDescriptionProvider.note(NoteDescriptionProvider.RESTRICTION.apply(this.updateRestriction)));
        }
        Configurable.Gui.Visibility visibility = field.getAnnotation(Configurable.Gui.Visibility.class);
        if (visibility != null && visibility.value() != FieldVisibility.NORMAL) {
            this.fieldVisibility = visibility.value();
            if (this.fieldVisibility == FieldVisibility.ADVANCED) {
                this.addDescriptionProvider(NoteDescriptionProvider.note(FieldVisibility.ADVANCED.getLabel()));
            }
        }
        this.processAdditionalAnnotations(field);
        Configurable.DependsOn dependsOn = field.getAnnotation(Configurable.DependsOn.class);
        if (dependsOn != null) {
            Configurable.DependsOn.ActiveMod[] modRequirements;
            for (Configurable.DependsOn.ActiveMod mod : modRequirements = dependsOn.mods()) {
                this.addValidator(new RequiredModValidator(mod));
            }
            Configurable.DependsOn.ConfigValue[] valueRequirements = dependsOn.configValues();
            for (Configurable.DependsOn.ConfigValue configValue : valueRequirements) {
                this.addValidator(new SpecificValueValidator(configValue));
            }
        }
        if ((validate = field.getAnnotation(Configurable.Validate.class)) != null) {
            Class<? extends Validator<?>>[] types = validate.value();
            for (Class<? extends Validator<?>> validatorType : types) {
                try {
                    this.autoRegisterValidator(validatorType);
                }
                catch (Exception e) {
                    Configuration.LOGGER.error((Message)new FormattedMessage("Failed to register config value validator for field '{}', skipping", (Object)this.getId()), (Throwable)e);
                    if (!Configuration.PLATFORM.isDevelopmentEnvironment()) continue;
                    throw new RuntimeException("Failed to register validator", e);
                }
            }
        }
    }

    protected boolean isChanged(T saved, T pending) {
        return this.isEditable() && !saved.equals(pending);
    }

    protected void processAdditionalAnnotations(Field field) {
    }

    protected abstract void serialize(IConfigFormat var1);

    public final void serializeValue(IConfigFormat format) {
        format.addComments(this.valueData.getFileComments());
        this.serialize(format);
    }

    protected abstract void deserialize(IConfigFormat var1) throws ConfigValueMissingException;

    public final void deserializeValue(IConfigFormat format) {
        try {
            this.deserialize(format);
        }
        catch (ConfigValueMissingException e) {
            this.forceSetValue(this.valueData.getDefaultValue());
            ConfigUtils.logCorrectedMessage(this.getId(), null, this.get());
        }
    }

    public final TypeAdapter.AdapterContext getSerializationContext() {
        return this.valueData.getContext();
    }

    public final TypeAdapter<T> getAdapter() {
        return this.getSerializationContext().getAdapter();
    }

    public final Class<T> getValueType() {
        return this.valueData.getValueType();
    }

    public final ValueData<T> getValueData() {
        return this.valueData;
    }

    public String toString() {
        return Objects.toString(this.getActiveValue());
    }

    @Override
    public ValidationResult getValidationResult() {
        return this.validationResultHolder;
    }

    @Override
    public final void addDescriptionProvider(IDescriptionProvider<T> provider) {
        this.descriptionProviders.add(provider);
    }

    @Override
    public final void addValidator(Validator<T> validator) {
        this.validators.add(Objects.requireNonNull(validator));
    }

    @Override
    public final void addFixer(ValueFixer<T> corrector) {
        this.correctors.add(Objects.requireNonNull(corrector));
    }

    @Override
    public void addListener(ValueListener<T> listener) {
        this.listeners.add(Objects.requireNonNull(listener));
    }

    public void notifyListeners(T value) {
        this.listeners.forEach(listener -> listener.onValueChanged(this, value));
    }

    @Override
    public final List<class_2561> getDescription() {
        ArrayList<class_2561> description = new ArrayList<class_2561>(this.valueData.getDescription());
        if (!this.descriptionProviders.isEmpty()) {
            ArrayList<class_2561> generated = new ArrayList<class_2561>();
            for (IDescriptionProvider<T> provider : this.descriptionProviders) {
                if (provider.replaceDefaultDescription()) {
                    description.clear();
                }
                generated.addAll(provider.generate(this));
            }
            description.addAll(generated);
        }
        return description;
    }

    public final FieldVisibility getFieldVisibility() {
        return this.fieldVisibility;
    }

    private ValidationResult performAdditionalValidations(T value) {
        List<ValidationResult> results = this.validators.stream().map(validator -> validator.validate(value, this)).filter(ValidationResult::isWarningOrError).toList();
        return ValidationHelper.aggregate(results);
    }

    private void autoRegisterValidator(Class<? extends Validator<?>> type) throws Exception {
        try {
            Constructor<Validator<?>> constructor = type.getConstructor(new Class[0]);
            Validator<?> instance = constructor.newInstance(new Object[0]);
            this.addValidator(instance);
        }
        catch (NoSuchMethodException e) {
            Configuration.LOGGER.fatal((Message)new FormattedMessage("No default constructor found for {}", (Object)type.getSimpleName()), (Throwable)e);
            throw e;
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            Configuration.LOGGER.fatal((Message)new FormattedMessage("Could not instantiate default constructor for {}", (Object)type.getSimpleName()), (Throwable)e);
            throw e;
        }
        catch (ClassCastException e) {
            Configuration.LOGGER.fatal((Message)new FormattedMessage("Invalid validator data type {}", (Object)type.getSimpleName()), (Throwable)e);
            throw e;
        }
    }
}

