/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.configuration.config.value;

import dev.toma.configuration.config.Configurable;
import dev.toma.configuration.config.adapter.TypeAdapter;
import dev.toma.configuration.config.exception.ConfigValueMissingException;
import dev.toma.configuration.config.format.IConfigFormat;
import dev.toma.configuration.config.validate.NumberRange;
import dev.toma.configuration.config.value.ConfigValue;
import dev.toma.configuration.config.value.IConfigValueReadable;
import dev.toma.configuration.config.value.NumericValue;
import dev.toma.configuration.config.value.ValueData;
import java.lang.reflect.Field;
import net.minecraft.class_2540;

public class IntValue
extends NumericValue<Integer> {
    public IntValue(ValueData<Integer> valueData) {
        super(valueData, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    @Override
    protected NumberRange<Integer> getValueRange(Field field, Integer min, Integer max) {
        Configurable.Range range = field.getAnnotation(Configurable.Range.class);
        return range != null ? NumberRange.interval(this, (int)Math.max(range.min(), (long)min.intValue()), (int)Math.min(range.max(), (long)max.intValue())) : NumberRange.all(this);
    }

    @Override
    public Integer getValueFromSlider(double sliderValue) {
        NumberRange range = this.getRange();
        int delta = (Integer)range.max() - (Integer)range.min();
        return (Integer)range.min() + (int)((double)delta * sliderValue);
    }

    @Override
    public void serialize(IConfigFormat format) {
        format.writeInt(this.getId(), (Integer)this.get(IConfigValueReadable.Mode.SAVED));
    }

    @Override
    public void deserialize(IConfigFormat format) throws ConfigValueMissingException {
        this.setValue(format.readInt(this.getId()));
    }

    public static final class Adapter
    extends TypeAdapter<Integer> {
        @Override
        public ConfigValue<Integer> serialize(TypeAdapter.TypeAttributes<Integer> attributes, Object instance, TypeAdapter.TypeSerializer serializer) {
            return new IntValue(ValueData.of(attributes));
        }

        @Override
        public void encodeToBuffer(ConfigValue<Integer> value, class_2540 buffer) {
            buffer.method_53002(value.get().intValue());
        }

        @Override
        public Integer decodeFromBuffer(ConfigValue<Integer> value, class_2540 buffer) {
            return buffer.readInt();
        }

        @Override
        public void setFieldValue(Field field, Object instance, Object value) throws IllegalAccessException {
            field.setInt(instance, (Integer)value);
        }
    }
}

