/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.configuration.config.value;

import dev.toma.configuration.config.Configurable;
import dev.toma.configuration.config.adapter.TypeAdapter;
import dev.toma.configuration.config.exception.ConfigValueMissingException;
import dev.toma.configuration.config.format.IConfigFormat;
import dev.toma.configuration.config.validate.NumberRange;
import dev.toma.configuration.config.value.ConfigValue;
import dev.toma.configuration.config.value.IConfigValueReadable;
import dev.toma.configuration.config.value.NumericValue;
import dev.toma.configuration.config.value.ValueData;
import java.lang.reflect.Field;
import net.minecraft.class_2540;

public class LongValue
extends NumericValue<Long> {
    public LongValue(ValueData<Long> valueData) {
        super(valueData, Long.MIN_VALUE, Long.MAX_VALUE);
    }

    @Override
    protected NumberRange<Long> getValueRange(Field field, Long min, Long max) {
        Configurable.Range range = field.getAnnotation(Configurable.Range.class);
        return range != null ? NumberRange.interval(this, range.min(), range.max()) : NumberRange.all(this);
    }

    @Override
    public Long getValueFromSlider(double sliderValue) {
        NumberRange range = this.getRange();
        long delta = (Long)range.max() - (Long)range.min();
        return (Long)range.min() + (long)((double)delta * sliderValue);
    }

    @Override
    protected void serialize(IConfigFormat format) {
        format.writeLong(this.getId(), (Long)this.get(IConfigValueReadable.Mode.SAVED));
    }

    @Override
    protected void deserialize(IConfigFormat format) throws ConfigValueMissingException {
        this.setValue(format.readLong(this.getId()));
    }

    public static final class Adapter
    extends TypeAdapter<Long> {
        @Override
        public ConfigValue<Long> serialize(TypeAdapter.TypeAttributes<Long> attributes, Object instance, TypeAdapter.TypeSerializer serializer) throws IllegalAccessException {
            return new LongValue(ValueData.of(attributes));
        }

        @Override
        public void encodeToBuffer(ConfigValue<Long> value, class_2540 buffer) {
            buffer.method_52974(value.get().longValue());
        }

        @Override
        public Long decodeFromBuffer(ConfigValue<Long> value, class_2540 buffer) {
            return buffer.readLong();
        }

        @Override
        public void setFieldValue(Field field, Object instance, Object value) throws IllegalAccessException {
            field.setLong(instance, (Long)value);
        }
    }
}

