/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.configuration.config.value;

import dev.toma.configuration.Configuration;
import dev.toma.configuration.config.ConfigUtils;
import dev.toma.configuration.config.Configurable;
import dev.toma.configuration.config.adapter.TypeAdapter;
import dev.toma.configuration.config.exception.ConfigValueMissingException;
import dev.toma.configuration.config.format.IConfigFormat;
import dev.toma.configuration.config.io.ConfigurationFileManager;
import dev.toma.configuration.config.value.ConfigValue;
import dev.toma.configuration.config.value.IConfigValueReadable;
import dev.toma.configuration.config.value.ValueData;
import java.lang.reflect.Field;
import java.util.regex.Pattern;
import net.minecraft.class_2540;

public class StringValue
extends ConfigValue<String> {
    private Pattern pattern;
    private String descriptor;

    public StringValue(ValueData<String> valueData) {
        super(valueData);
        this.addFixer(this::fixValue);
    }

    @Override
    protected void processAdditionalAnnotations(Field field) {
        Configurable.StringPattern stringPattern = field.getAnnotation(Configurable.StringPattern.class);
        if (stringPattern != null) {
            String value = stringPattern.value();
            this.descriptor = stringPattern.errorDescriptor().isEmpty() ? null : stringPattern.errorDescriptor();
            try {
                this.pattern = Pattern.compile(value, stringPattern.flags());
            }
            catch (IllegalArgumentException e) {
                Configuration.LOGGER.error(ConfigurationFileManager.MARKER, "Invalid @StringPattern value for {} field - {}", (Object)this.getId(), (Object)e);
            }
        }
    }

    @Override
    protected void serialize(IConfigFormat format) {
        format.writeString(this.getId(), (String)this.get(IConfigValueReadable.Mode.SAVED));
    }

    @Override
    protected void deserialize(IConfigFormat format) throws ConfigValueMissingException {
        this.setValue(format.readString(this.getId()));
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public String getErrorDescriptor() {
        return this.descriptor;
    }

    private String fixValue(String in) {
        if (this.pattern != null && !this.pattern.matcher(in).matches()) {
            String defaultValue = (String)this.valueData.getDefaultValue();
            if (!this.pattern.matcher(defaultValue).matches()) {
                throw new IllegalArgumentException(String.format("Invalid config default value '%s' for field '%s' - does not match required pattern \\%s\\", defaultValue, this.getId(), this.pattern.toString()));
            }
            ConfigUtils.logCorrectedMessage(this.getId(), in, defaultValue);
            return defaultValue;
        }
        return in;
    }

    public static final class Adapter
    extends TypeAdapter<String> {
        @Override
        public void encodeToBuffer(ConfigValue<String> value, class_2540 buffer) {
            buffer.method_10814(value.get());
        }

        @Override
        public String decodeFromBuffer(ConfigValue<String> value, class_2540 buffer) {
            return buffer.method_19772();
        }

        @Override
        public ConfigValue<String> serialize(TypeAdapter.TypeAttributes<String> attributes, Object instance, TypeAdapter.TypeSerializer serializer) throws IllegalAccessException {
            return new StringValue(ValueData.of(attributes));
        }
    }
}

