/*
 * Decompiled with CFR 0.152.
 */
package com.skillforge;

import com.skillforge.commands.InspectCommand;
import com.skillforge.commands.LeaderboardCommand;
import com.skillforge.commands.MainCommand;
import com.skillforge.commands.PartyCommand;
import com.skillforge.database.DatabaseManager;
import com.skillforge.listeners.BlockListener;
import com.skillforge.listeners.CombatListener;
import com.skillforge.listeners.FishingListener;
import com.skillforge.listeners.PlayerListener;
import com.skillforge.listeners.TamingListener;
import com.skillforge.managers.ConfigManager;
import com.skillforge.managers.PartyManager;
import com.skillforge.managers.PlayerManager;
import com.skillforge.managers.SkillManager;
import org.bukkit.command.CommandExecutor;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class SkillForge
extends JavaPlugin {
    private static SkillForge instance;
    private DatabaseManager databaseManager;
    private PlayerManager playerManager;
    private SkillManager skillManager;
    private PartyManager partyManager;
    private ConfigManager configManager;

    public void onEnable() {
        instance = this;
        this.configManager = new ConfigManager(this);
        this.databaseManager = new DatabaseManager(this);
        this.skillManager = new SkillManager(this);
        this.playerManager = new PlayerManager(this);
        this.partyManager = new PartyManager(this);
        this.registerCommands();
        this.registerListeners();
        this.databaseManager.initialize();
        this.getLogger().info("SkillForge has been enabled! LitRPG adventures await!");
    }

    public void onDisable() {
        if (this.databaseManager != null) {
            this.databaseManager.close();
        }
        this.getLogger().info("SkillForge has been disabled!");
    }

    private void registerCommands() {
        this.getCommand("sf").setExecutor((CommandExecutor)new MainCommand(this));
        this.getCommand("party").setExecutor((CommandExecutor)new PartyCommand(this));
        this.getCommand("leaderboard").setExecutor((CommandExecutor)new LeaderboardCommand(this));
        this.getCommand("inspect").setExecutor((CommandExecutor)new InspectCommand(this));
    }

    private void registerListeners() {
        this.getServer().getPluginManager().registerEvents((Listener)new BlockListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new CombatListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new FishingListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new TamingListener(this), (Plugin)this);
    }

    public static SkillForge getInstance() {
        return instance;
    }

    public DatabaseManager getDatabaseManager() {
        return this.databaseManager;
    }

    public PlayerManager getPlayerManager() {
        return this.playerManager;
    }

    public SkillManager getSkillManager() {
        return this.skillManager;
    }

    public PartyManager getPartyManager() {
        return this.partyManager;
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }
}

