/*
 * Decompiled with CFR 0.152.
 */
package com.skillforge.commands;

import com.skillforge.SkillForge;
import com.skillforge.models.PlayerProfile;
import com.skillforge.models.SkillType;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class InspectCommand
implements CommandExecutor {
    private final SkillForge plugin;

    public InspectCommand(SkillForge plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length == 0) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /inspect <player>");
            return true;
        }
        String targetName = args[0];
        Player target = this.plugin.getServer().getPlayer(targetName);
        if (target == null) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Player not found!");
            return true;
        }
        PlayerProfile profile = this.plugin.getPlayerManager().getProfile(target);
        if (profile == null) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Could not load player profile!");
            return true;
        }
        this.showPlayerInspection(sender, target, profile);
        return true;
    }

    private void showPlayerInspection(CommandSender sender, Player target, PlayerProfile profile) {
        sender.sendMessage("");
        sender.sendMessage(String.valueOf(ChatColor.GOLD) + "\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550");
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "      " + target.getName() + "'s SkillForge Stats");
        sender.sendMessage(String.valueOf(ChatColor.GOLD) + "\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550");
        sender.sendMessage(String.valueOf(ChatColor.AQUA) + "Power Level: " + String.valueOf(ChatColor.WHITE) + profile.getPowerLevel());
        sender.sendMessage(String.valueOf(ChatColor.AQUA) + "Total XP: " + String.valueOf(ChatColor.WHITE) + profile.getTotalExperience());
        sender.sendMessage("");
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Top Skills:");
        for (SkillType skill : SkillType.values()) {
            int level;
            if (!this.plugin.getSkillManager().isSkillEnabled(skill) || (level = profile.getSkillLevel(skill)) <= 1) continue;
            sender.sendMessage(String.valueOf(ChatColor.GREEN) + skill.getIcon() + " " + skill.getDisplayName() + ": " + String.valueOf(ChatColor.YELLOW) + "Level " + level);
        }
        sender.sendMessage(String.valueOf(ChatColor.GOLD) + "\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550");
    }
}

