/*
 * Decompiled with CFR 0.152.
 */
package com.skillforge.commands;

import com.skillforge.SkillForge;
import com.skillforge.models.SkillType;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;

public class LeaderboardCommand
implements CommandExecutor {
    private final SkillForge plugin;

    public LeaderboardCommand(SkillForge plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length == 0) {
            this.showPowerLevelLeaderboard(sender);
        } else {
            String skillName = args[0];
            SkillType skill = SkillType.fromString(skillName);
            if (skill == null) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "Invalid skill name!");
                return true;
            }
            this.showSkillLeaderboard(sender, skill);
        }
        return true;
    }

    private void showPowerLevelLeaderboard(CommandSender sender) {
        sender.sendMessage(String.valueOf(ChatColor.GOLD) + "\u2550\u2550\u2550 Power Level Leaderboard \u2550\u2550\u2550");
        sender.sendMessage(String.valueOf(ChatColor.GRAY) + "Feature coming soon!");
        sender.sendMessage(String.valueOf(ChatColor.GOLD) + "\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550");
    }

    private void showSkillLeaderboard(CommandSender sender, SkillType skill) {
        sender.sendMessage(String.valueOf(ChatColor.GOLD) + "\u2550\u2550\u2550 " + skill.getDisplayName() + " Leaderboard \u2550\u2550\u2550");
        sender.sendMessage(String.valueOf(ChatColor.GRAY) + "Feature coming soon!");
        sender.sendMessage(String.valueOf(ChatColor.GOLD) + "\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550");
    }
}

