/*
 * Decompiled with CFR 0.152.
 */
package com.skillforge.commands;

import com.skillforge.SkillForge;
import com.skillforge.models.PlayerProfile;
import com.skillforge.models.SkillType;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class MainCommand
implements CommandExecutor {
    private final SkillForge plugin;

    public MainCommand(SkillForge plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String subCommand;
        if (!(sender instanceof Player)) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "This command can only be used by players!");
            return true;
        }
        Player player = (Player)sender;
        if (args.length == 0) {
            this.showPlayerStats(player);
            return true;
        }
        switch (subCommand = args[0].toLowerCase()) {
            case "stats": 
            case "s": {
                this.showPlayerStats(player);
                break;
            }
            case "skill": 
            case "sk": {
                if (args.length < 2) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /sf skill <skillname>");
                    return true;
                }
                this.showSkillStats(player, args[1]);
                break;
            }
            case "ability": 
            case "ab": {
                if (args.length < 2) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /sf ability <skillname>");
                    return true;
                }
                this.activateAbility(player, args[1]);
                break;
            }
            case "help": 
            case "h": {
                this.showHelp(player);
                break;
            }
            default: {
                player.sendMessage(String.valueOf(ChatColor.RED) + "Unknown command! Use /sf help for help.");
            }
        }
        return true;
    }

    private void showPlayerStats(Player player) {
        PlayerProfile profile = this.plugin.getPlayerManager().getProfile(player);
        if (profile == null) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Could not load your profile!");
            return;
        }
        player.sendMessage("");
        player.sendMessage(String.valueOf(ChatColor.GOLD) + "\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550");
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "      " + player.getName() + "'s SkillForge Stats");
        player.sendMessage(String.valueOf(ChatColor.GOLD) + "\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550");
        player.sendMessage(String.valueOf(ChatColor.AQUA) + "Power Level: " + String.valueOf(ChatColor.WHITE) + profile.getPowerLevel());
        player.sendMessage(String.valueOf(ChatColor.AQUA) + "Total XP: " + String.valueOf(ChatColor.WHITE) + profile.getTotalExperience());
        player.sendMessage("");
        for (SkillType skill : SkillType.values()) {
            if (!this.plugin.getSkillManager().isSkillEnabled(skill)) continue;
            int level = profile.getSkillLevel(skill);
            long xp = profile.getSkillExperience(skill);
            player.sendMessage(String.valueOf(ChatColor.GREEN) + skill.getIcon() + " " + skill.getDisplayName() + ": " + String.valueOf(ChatColor.YELLOW) + "Level " + level + String.valueOf(ChatColor.GRAY) + " (" + xp + " XP)");
        }
        player.sendMessage(String.valueOf(ChatColor.GOLD) + "\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550");
    }

    private void showSkillStats(Player player, String skillName) {
        SkillType skill = SkillType.fromString(skillName);
        if (skill == null) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Invalid skill name!");
            return;
        }
        PlayerProfile profile = this.plugin.getPlayerManager().getProfile(player);
        if (profile == null) {
            return;
        }
        int level = profile.getSkillLevel(skill);
        long xp = profile.getSkillExperience(skill);
        player.sendMessage("");
        player.sendMessage(String.valueOf(ChatColor.GOLD) + "\u2550\u2550\u2550 " + skill.getIcon() + " " + skill.getDisplayName() + " \u2550\u2550\u2550");
        player.sendMessage(String.valueOf(ChatColor.AQUA) + "Level: " + String.valueOf(ChatColor.WHITE) + level);
        player.sendMessage(String.valueOf(ChatColor.AQUA) + "Experience: " + String.valueOf(ChatColor.WHITE) + xp);
        if (profile.isAbilityOnCooldown(skill)) {
            long cooldown = profile.getAbilityCooldownRemaining(skill);
            player.sendMessage(String.valueOf(ChatColor.RED) + "Ability Cooldown: " + cooldown + "s");
        } else {
            player.sendMessage(String.valueOf(ChatColor.GREEN) + "Ability Ready!");
        }
        player.sendMessage(String.valueOf(ChatColor.GOLD) + "\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550");
    }

    private void activateAbility(Player player, String skillName) {
        SkillType skill = SkillType.fromString(skillName);
        if (skill == null) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Invalid skill name!");
            return;
        }
        String abilityName = this.getMainAbilityName(skill);
        if (abilityName == null) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "This skill doesn't have an activatable ability!");
            return;
        }
        if (this.plugin.getSkillManager().canUseAbility(player, skill, abilityName)) {
            this.plugin.getSkillManager().activateAbility(player, skill, abilityName);
        } else {
            PlayerProfile profile = this.plugin.getPlayerManager().getProfile(player);
            if (profile.isAbilityOnCooldown(skill)) {
                long cooldown = profile.getAbilityCooldownRemaining(skill);
                player.sendMessage(String.valueOf(ChatColor.RED) + "Ability is on cooldown for " + cooldown + " seconds!");
            } else {
                player.sendMessage(String.valueOf(ChatColor.RED) + "You don't have the required level for this ability!");
            }
        }
    }

    private String getMainAbilityName(SkillType skill) {
        switch (skill) {
            case MINING: {
                return "super-breaker";
            }
            case WOODCUTTING: {
                return "tree-feller";
            }
            case EXCAVATION: {
                return "giga-drill-breaker";
            }
            case HERBALISM: {
                return "green-terra";
            }
            case ARCHERY: {
                return "power-shot";
            }
            case SWORDS: {
                return "serrated-strikes";
            }
            case AXES: {
                return "skull-splitter";
            }
            case UNARMED: {
                return "berserk";
            }
        }
        return null;
    }

    private void showHelp(Player player) {
        player.sendMessage(String.valueOf(ChatColor.GOLD) + "\u2550\u2550\u2550 SkillForge Help \u2550\u2550\u2550");
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/sf stats" + String.valueOf(ChatColor.WHITE) + " - View your skill stats");
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/sf skill <name>" + String.valueOf(ChatColor.WHITE) + " - View specific skill info");
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/sf ability <skill>" + String.valueOf(ChatColor.WHITE) + " - Activate skill ability");
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/party" + String.valueOf(ChatColor.WHITE) + " - Party management commands");
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/leaderboard [skill]" + String.valueOf(ChatColor.WHITE) + " - View leaderboards");
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/inspect <player>" + String.valueOf(ChatColor.WHITE) + " - Inspect another player");
    }
}

