/*
 * Decompiled with CFR 0.152.
 */
package com.skillforge.commands;

import com.skillforge.SkillForge;
import com.skillforge.models.PlayerProfile;
import java.util.Set;
import java.util.UUID;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class PartyCommand
implements CommandExecutor {
    private final SkillForge plugin;

    public PartyCommand(SkillForge plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String subCommand;
        if (!(sender instanceof Player)) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "This command can only be used by players!");
            return true;
        }
        Player player = (Player)sender;
        if (args.length == 0) {
            this.showPartyHelp(player);
            return true;
        }
        switch (subCommand = args[0].toLowerCase()) {
            case "create": {
                this.createParty(player);
                break;
            }
            case "invite": {
                if (args.length < 2) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /party invite <player>");
                    return true;
                }
                this.invitePlayer(player, args[1]);
                break;
            }
            case "leave": {
                this.leaveParty(player);
                break;
            }
            case "info": {
                this.showPartyInfo(player);
                break;
            }
            case "help": {
                this.showPartyHelp(player);
                break;
            }
            default: {
                player.sendMessage(String.valueOf(ChatColor.RED) + "Unknown party command! Use /party help for help.");
            }
        }
        return true;
    }

    private void createParty(Player player) {
        PlayerProfile profile = this.plugin.getPlayerManager().getProfile(player);
        if (profile == null) {
            return;
        }
        if (profile.hasParty()) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You are already in a party!");
            return;
        }
        UUID partyId = this.plugin.getPartyManager().createParty(player);
        player.sendMessage(String.valueOf(ChatColor.GREEN) + "\u2726 Party created! You are now the party leader.");
    }

    private void invitePlayer(Player player, String targetName) {
        PlayerProfile profile = this.plugin.getPlayerManager().getProfile(player);
        if (profile == null || !profile.hasParty()) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You must be in a party to invite players!");
            return;
        }
        Player target = this.plugin.getServer().getPlayer(targetName);
        if (target == null) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Player not found!");
            return;
        }
        PlayerProfile targetProfile = this.plugin.getPlayerManager().getProfile(target);
        if (targetProfile.hasParty()) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "That player is already in a party!");
            return;
        }
        UUID partyId = profile.getPartyId();
        if (!this.plugin.getPartyManager().isPartyLeader(player, partyId)) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Only the party leader can invite players!");
            return;
        }
        if (this.plugin.getPartyManager().invitePlayer(partyId, target)) {
            player.sendMessage(String.valueOf(ChatColor.GREEN) + "\u2726 " + target.getName() + " has been invited to the party!");
            target.sendMessage(String.valueOf(ChatColor.GREEN) + "\u2726 You have been invited to " + player.getName() + "'s party!");
        } else {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Failed to invite player (party might be full)!");
        }
    }

    private void leaveParty(Player player) {
        PlayerProfile profile = this.plugin.getPlayerManager().getProfile(player);
        if (profile == null || !profile.hasParty()) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You are not in a party!");
            return;
        }
        this.plugin.getPartyManager().leaveParty(player);
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "You have left the party.");
    }

    private void showPartyInfo(Player player) {
        PlayerProfile profile = this.plugin.getPlayerManager().getProfile(player);
        if (profile == null || !profile.hasParty()) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You are not in a party!");
            return;
        }
        UUID partyId = profile.getPartyId();
        Set<UUID> members = this.plugin.getPartyManager().getPartyMembers(partyId);
        player.sendMessage(String.valueOf(ChatColor.GOLD) + "\u2550\u2550\u2550 Party Info \u2550\u2550\u2550");
        player.sendMessage(String.valueOf(ChatColor.AQUA) + "Members (" + members.size() + "/6):");
        for (UUID memberId : members) {
            Player member = this.plugin.getServer().getPlayer(memberId);
            if (member == null) continue;
            String status = this.plugin.getPartyManager().isPartyLeader(member, partyId) ? " \u00a76[Leader]" : "";
            player.sendMessage(String.valueOf(ChatColor.WHITE) + "- " + member.getName() + status);
        }
        player.sendMessage(String.valueOf(ChatColor.GOLD) + "\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550");
    }

    private void showPartyHelp(Player player) {
        player.sendMessage(String.valueOf(ChatColor.GOLD) + "\u2550\u2550\u2550 Party Help \u2550\u2550\u2550");
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/party create" + String.valueOf(ChatColor.WHITE) + " - Create a new party");
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/party invite <player>" + String.valueOf(ChatColor.WHITE) + " - Invite a player");
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/party leave" + String.valueOf(ChatColor.WHITE) + " - Leave your party");
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/party info" + String.valueOf(ChatColor.WHITE) + " - View party information");
    }
}

