/*
 * Decompiled with CFR 0.152.
 */
package com.skillforge.database;

import com.skillforge.SkillForge;
import com.skillforge.models.PlayerProfile;
import com.skillforge.models.SkillType;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.UUID;

public class DatabaseManager {
    private final SkillForge plugin;
    private Connection connection;

    public DatabaseManager(SkillForge plugin) {
        this.plugin = plugin;
    }

    public void initialize() {
        try {
            this.setupDatabase();
            this.createTables();
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Failed to initialize database: " + e.getMessage());
        }
    }

    private void setupDatabase() throws SQLException {
        String dbType = this.plugin.getConfig().getString("database.type", "sqlite");
        if (dbType.equalsIgnoreCase("sqlite")) {
            File dbFile = new File(this.plugin.getDataFolder(), "skillforge.db");
            String url = "jdbc:sqlite:" + dbFile.getAbsolutePath();
            this.connection = DriverManager.getConnection(url);
        } else if (dbType.equalsIgnoreCase("mysql")) {
            String host = this.plugin.getConfig().getString("database.host", "localhost");
            int port = this.plugin.getConfig().getInt("database.port", 3306);
            String database = this.plugin.getConfig().getString("database.database", "skillforge");
            String username = this.plugin.getConfig().getString("database.username", "root");
            String password = this.plugin.getConfig().getString("database.password", "");
            String url = "jdbc:mysql://" + host + ":" + port + "/" + database;
            this.connection = DriverManager.getConnection(url, username, password);
        }
    }

    private void createTables() throws SQLException {
        String createPlayersTable = "    CREATE TABLE IF NOT EXISTS players (\n        uuid VARCHAR(36) PRIMARY KEY,\n        name VARCHAR(16) NOT NULL,\n        power_level BIGINT DEFAULT 0,\n        total_experience BIGINT DEFAULT 0,\n        last_seen TIMESTAMP DEFAULT CURRENT_TIMESTAMP\n    )\n";
        String createSkillsTable = "    CREATE TABLE IF NOT EXISTS player_skills (\n        uuid VARCHAR(36),\n        skill VARCHAR(20),\n        level INT DEFAULT 1,\n        experience BIGINT DEFAULT 0,\n        PRIMARY KEY (uuid, skill),\n        FOREIGN KEY (uuid) REFERENCES players(uuid) ON DELETE CASCADE\n    )\n";
        try (Statement stmt = this.connection.createStatement();){
            stmt.execute(createPlayersTable);
            stmt.execute(createSkillsTable);
        }
    }

    public PlayerProfile loadPlayerProfile(UUID playerId, String playerName) {
        PlayerProfile profile = new PlayerProfile(playerId, playerName);
        try {
            String selectPlayer = "SELECT * FROM players WHERE uuid = ?";
            try (PreparedStatement stmt = this.connection.prepareStatement(selectPlayer);){
                stmt.setString(1, playerId.toString());
                ResultSet rs = stmt.executeQuery();
                if (!rs.next()) {
                    this.insertNewPlayer(playerId, playerName);
                }
            }
            String selectSkills = "SELECT * FROM player_skills WHERE uuid = ?";
            try (PreparedStatement stmt = this.connection.prepareStatement(selectSkills);){
                stmt.setString(1, playerId.toString());
                ResultSet rs = stmt.executeQuery();
                while (rs.next()) {
                    String skillName = rs.getString("skill");
                    int level = rs.getInt("level");
                    long experience = rs.getLong("experience");
                    SkillType skill = SkillType.fromString(skillName);
                    if (skill == null) continue;
                    profile.setSkillLevel(skill, level);
                    profile.addSkillExperience(skill, experience);
                }
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Failed to load player profile: " + e.getMessage());
        }
        return profile;
    }

    public void savePlayerProfile(PlayerProfile profile) {
        try {
            String updatePlayer = "    UPDATE players SET\n    name = ?, power_level = ?, total_experience = ?, last_seen = CURRENT_TIMESTAMP\n    WHERE uuid = ?\n";
            try (PreparedStatement stmt = this.connection.prepareStatement(updatePlayer);){
                stmt.setString(1, profile.getPlayerName());
                stmt.setLong(2, profile.getPowerLevel());
                stmt.setLong(3, profile.getTotalExperience());
                stmt.setString(4, profile.getPlayerId().toString());
                stmt.executeUpdate();
            }
            for (SkillType skill : SkillType.values()) {
                String updateSkill = "    INSERT OR REPLACE INTO player_skills (uuid, skill, level, experience)\n    VALUES (?, ?, ?, ?)\n";
                try (PreparedStatement stmt = this.connection.prepareStatement(updateSkill);){
                    stmt.setString(1, profile.getPlayerId().toString());
                    stmt.setString(2, skill.name());
                    stmt.setInt(3, profile.getSkillLevel(skill));
                    stmt.setLong(4, profile.getSkillExperience(skill));
                    stmt.executeUpdate();
                }
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Failed to save player profile: " + e.getMessage());
        }
    }

    private void insertNewPlayer(UUID playerId, String playerName) throws SQLException {
        String insertPlayer = "INSERT INTO players (uuid, name) VALUES (?, ?)";
        try (PreparedStatement stmt = this.connection.prepareStatement(insertPlayer);){
            stmt.setString(1, playerId.toString());
            stmt.setString(2, playerName);
            stmt.executeUpdate();
        }
        for (SkillType skill : SkillType.values()) {
            String insertSkill = "INSERT INTO player_skills (uuid, skill, level, experience) VALUES (?, ?, 1, 0)";
            try (PreparedStatement stmt = this.connection.prepareStatement(insertSkill);){
                stmt.setString(1, playerId.toString());
                stmt.setString(2, skill.name());
                stmt.executeUpdate();
            }
        }
    }

    public void close() {
        try {
            if (this.connection != null && !this.connection.isClosed()) {
                this.connection.close();
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Failed to close database connection: " + e.getMessage());
        }
    }
}

