/*
 * Decompiled with CFR 0.152.
 */
package com.skillforge.lib.sqlite.util;

import com.skillforge.lib.sqlite.SQLiteJDBCLoader;
import com.skillforge.lib.sqlite.util.OSInfo;

public class LibraryLoaderUtil {
    public static String getNativeLibResourcePath() {
        String packagePath = SQLiteJDBCLoader.class.getPackage().getName().replace(".", "/");
        return String.format("/%s/native/%s", packagePath, OSInfo.getNativeLibFolderPathForCurrentOS());
    }

    public static String getNativeLibName() {
        String nativeLibName = System.mapLibraryName("sqlitejdbc");
        if (nativeLibName != null && nativeLibName.endsWith(".dylib")) {
            nativeLibName = nativeLibName.replace(".dylib", ".jnilib");
        }
        return nativeLibName;
    }

    public static boolean hasNativeLib(String path, String libraryName) {
        return SQLiteJDBCLoader.class.getResource(path + "/" + libraryName) != null;
    }
}

