/*
 * Decompiled with CFR 0.152.
 */
package com.skillforge.listeners;

import com.skillforge.SkillForge;
import com.skillforge.models.PlayerProfile;
import com.skillforge.models.SkillType;
import java.util.Random;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.inventory.ItemStack;

public class BlockListener
implements Listener {
    private final SkillForge plugin;
    private final Random random = new Random();

    public BlockListener(SkillForge plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onBlockBreak(BlockBreakEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Player player = event.getPlayer();
        Block block = event.getBlock();
        PlayerProfile profile = this.plugin.getPlayerManager().getProfile(player);
        if (profile == null) {
            return;
        }
        this.handleMining(player, block, profile);
        this.handleWoodcutting(player, block, profile);
        this.handleExcavation(player, block, profile);
        this.handleHerbalism(player, block, profile);
    }

    private void handleMining(Player player, Block block, PlayerProfile profile) {
        if (!this.isMiningBlock(block.getType())) {
            return;
        }
        long experience = this.getMiningExperience(block.getType());
        this.plugin.getPlayerManager().addExperience(player, SkillType.MINING, experience);
        if (profile.hasActiveAbility(SkillType.MINING) && this.random.nextDouble() < 0.33) {
            block.getDrops().forEach(item -> player.getWorld().dropItemNaturally(block.getLocation(), item));
        }
        double doubleDropChance = Math.min(0.1 + (double)profile.getSkillLevel(SkillType.MINING) * 0.001, 0.75);
        if (this.random.nextDouble() < doubleDropChance) {
            block.getDrops().forEach(item -> player.getWorld().dropItemNaturally(block.getLocation(), item));
        }
    }

    private void handleWoodcutting(Player player, Block block, PlayerProfile profile) {
        if (!this.isWoodcuttingBlock(block.getType())) {
            return;
        }
        long experience = this.getWoodcuttingExperience(block.getType());
        this.plugin.getPlayerManager().addExperience(player, SkillType.WOODCUTTING, experience);
        if (profile.hasActiveAbility(SkillType.WOODCUTTING)) {
            this.activateTreeFeller(player, block);
        }
    }

    private void handleExcavation(Player player, Block block, PlayerProfile profile) {
        if (!this.isExcavationBlock(block.getType())) {
            return;
        }
        long experience = this.getExcavationExperience(block.getType());
        this.plugin.getPlayerManager().addExperience(player, SkillType.EXCAVATION, experience);
        double treasureChance = (double)profile.getSkillLevel(SkillType.EXCAVATION) * 0.001;
        if (this.random.nextDouble() < treasureChance) {
            this.dropTreasure(player, block.getLocation());
        }
    }

    private void handleHerbalism(Player player, Block block, PlayerProfile profile) {
        if (!this.isHerbalismBlock(block.getType())) {
            return;
        }
        long experience = this.getHerbalismExperience(block.getType());
        this.plugin.getPlayerManager().addExperience(player, SkillType.HERBALISM, experience);
        if (profile.getSkillLevel(SkillType.HERBALISM) >= 25 && this.isCrop(block.getType()) && this.random.nextDouble() < 0.15) {
            block.getWorld().getBlockAt(block.getLocation()).setType(this.getSeedType(block.getType()));
        }
    }

    private boolean isMiningBlock(Material material) {
        return material == Material.STONE || material == Material.COAL_ORE || material == Material.IRON_ORE || material == Material.GOLD_ORE || material == Material.DIAMOND_ORE || material == Material.EMERALD_ORE || material == Material.DEEPSLATE_COAL_ORE || material == Material.DEEPSLATE_IRON_ORE || material == Material.DEEPSLATE_GOLD_ORE || material == Material.DEEPSLATE_DIAMOND_ORE;
    }

    private boolean isWoodcuttingBlock(Material material) {
        return material.name().contains("LOG") || material.name().contains("WOOD");
    }

    private boolean isExcavationBlock(Material material) {
        return material == Material.DIRT || material == Material.GRASS_BLOCK || material == Material.SAND || material == Material.GRAVEL || material == Material.MYCELIUM || material == Material.SOUL_SAND;
    }

    private boolean isHerbalismBlock(Material material) {
        return material == Material.WHEAT || material == Material.CARROTS || material == Material.POTATOES || material == Material.BEETROOTS || material == Material.SUGAR_CANE || material == Material.CACTUS;
    }

    private long getMiningExperience(Material material) {
        switch (material) {
            case COAL_ORE: 
            case DEEPSLATE_COAL_ORE: {
                return 30L;
            }
            case IRON_ORE: 
            case DEEPSLATE_IRON_ORE: {
                return 50L;
            }
            case GOLD_ORE: 
            case DEEPSLATE_GOLD_ORE: {
                return 75L;
            }
            case DIAMOND_ORE: 
            case DEEPSLATE_DIAMOND_ORE: {
                return 150L;
            }
            case EMERALD_ORE: {
                return 200L;
            }
        }
        return 10L;
    }

    private long getWoodcuttingExperience(Material material) {
        if (material.name().contains("LOG")) {
            return 35L;
        }
        return 25L;
    }

    private long getExcavationExperience(Material material) {
        switch (material) {
            case GRAVEL: {
                return 20L;
            }
            case SAND: {
                return 15L;
            }
            case SOUL_SAND: {
                return 25L;
            }
        }
        return 10L;
    }

    private long getHerbalismExperience(Material material) {
        switch (material) {
            case WHEAT: 
            case CARROTS: 
            case POTATOES: 
            case BEETROOTS: {
                return 30L;
            }
            case SUGAR_CANE: {
                return 20L;
            }
            case CACTUS: {
                return 25L;
            }
        }
        return 15L;
    }

    private void activateTreeFeller(Player player, Block block) {
    }

    private void dropTreasure(Player player, Location location) {
        ItemStack[] treasures = new ItemStack[]{new ItemStack(Material.DIAMOND, 1), new ItemStack(Material.EMERALD, 1), new ItemStack(Material.GOLD_INGOT, 2), new ItemStack(Material.IRON_INGOT, 3)};
        ItemStack treasure = treasures[this.random.nextInt(treasures.length)];
        player.getWorld().dropItemNaturally(location, treasure);
    }

    private boolean isCrop(Material material) {
        return material == Material.WHEAT || material == Material.CARROTS || material == Material.POTATOES || material == Material.BEETROOTS;
    }

    private Material getSeedType(Material crop) {
        switch (crop) {
            case WHEAT: {
                return Material.WHEAT_SEEDS;
            }
            case CARROTS: {
                return Material.CARROTS;
            }
            case POTATOES: {
                return Material.POTATOES;
            }
            case BEETROOTS: {
                return Material.BEETROOT_SEEDS;
            }
        }
        return Material.WHEAT_SEEDS;
    }
}

