/*
 * Decompiled with CFR 0.152.
 */
package com.skillforge.listeners;

import com.skillforge.SkillForge;
import com.skillforge.models.PlayerProfile;
import com.skillforge.models.SkillType;
import java.util.Random;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.inventory.ItemStack;

public class CombatListener
implements Listener {
    private final SkillForge plugin;
    private final Random random = new Random();

    public CombatListener(SkillForge plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onEntityDamageByEntity(EntityDamageByEntityEvent event) {
        Projectile projectile;
        if (event.isCancelled()) {
            return;
        }
        Entity damager = event.getDamager();
        Entity victim = event.getEntity();
        if (damager instanceof Player) {
            Player player = (Player)damager;
            this.handlePlayerAttack(player, victim, event);
        }
        if (damager instanceof Projectile && (projectile = (Projectile)damager).getShooter() instanceof Player) {
            Player shooter = (Player)projectile.getShooter();
            this.handleArcheryAttack(shooter, victim, event);
        }
    }

    private void handlePlayerAttack(Player player, Entity victim, EntityDamageByEntityEvent event) {
        if (!(victim instanceof LivingEntity)) {
            return;
        }
        PlayerProfile profile = this.plugin.getPlayerManager().getProfile(player);
        if (profile == null) {
            return;
        }
        ItemStack weapon = player.getInventory().getItemInMainHand();
        Material weaponType = weapon.getType();
        if (this.isUnarmedAttack(weaponType)) {
            this.handleUnarmedCombat(player, (LivingEntity)victim, event, profile);
        } else if (this.isSwordWeapon(weaponType)) {
            this.handleSwordsCombat(player, (LivingEntity)victim, event, profile);
        } else if (this.isAxeWeapon(weaponType)) {
            this.handleAxesCombat(player, (LivingEntity)victim, event, profile);
        }
    }

    private void handleUnarmedCombat(Player player, LivingEntity victim, EntityDamageByEntityEvent event, PlayerProfile profile) {
        long experience = this.getUnarmedExperience(victim);
        this.plugin.getPlayerManager().addExperience(player, SkillType.UNARMED, experience);
        int level = profile.getSkillLevel(SkillType.UNARMED);
        double damage = event.getDamage();
        if (profile.hasActiveAbility(SkillType.UNARMED)) {
            event.setDamage(damage * 1.5);
            if (this.random.nextDouble() < 0.25) {
                event.setDamage(EntityDamageEvent.DamageModifier.ARMOR, 0.0);
            }
        }
        double disarmChance = Math.min(0.05 + (double)level * 5.0E-4, 0.25);
        if (victim instanceof Player && this.random.nextDouble() < disarmChance) {
            Player victimPlayer = (Player)victim;
            this.disarmPlayer(victimPlayer);
        }
        double damageBonus = 1.0 + (double)level * 0.002;
        event.setDamage(damage * damageBonus);
    }

    private void handleSwordsCombat(Player player, LivingEntity victim, EntityDamageByEntityEvent event, PlayerProfile profile) {
        long experience = this.getSwordsExperience(victim);
        this.plugin.getPlayerManager().addExperience(player, SkillType.SWORDS, experience);
        int level = profile.getSkillLevel(SkillType.SWORDS);
        if (profile.hasActiveAbility(SkillType.SWORDS)) {
            this.performSerratedStrikes(player, victim, event.getDamage());
        }
        double bleedChance = Math.min((double)level * 0.001, 0.15);
        if (this.random.nextDouble() < bleedChance) {
            this.applyBleedEffect(victim, level);
        }
        double damageBonus = 1.0 + (double)level * 0.0015;
        event.setDamage(event.getDamage() * damageBonus);
    }

    private void handleAxesCombat(Player player, LivingEntity victim, EntityDamageByEntityEvent event, PlayerProfile profile) {
        long experience = this.getAxesExperience(victim);
        this.plugin.getPlayerManager().addExperience(player, SkillType.AXES, experience);
        int level = profile.getSkillLevel(SkillType.AXES);
        if (profile.hasActiveAbility(SkillType.AXES)) {
            this.performSkullSplitter(player, victim, event.getDamage());
        }
        if (victim instanceof Player && this.random.nextDouble() < 0.25) {
            this.damageArmor((Player)victim);
        }
        if (this.random.nextDouble() < Math.min((double)level * 0.001, 0.2)) {
            event.setDamage(event.getDamage() * 1.5);
        }
        double damageBonus = 1.0 + (double)level * 0.002;
        event.setDamage(event.getDamage() * damageBonus);
    }

    private void handleArcheryAttack(Player shooter, Entity victim, EntityDamageByEntityEvent event) {
        if (!(victim instanceof LivingEntity)) {
            return;
        }
        PlayerProfile profile = this.plugin.getPlayerManager().getProfile(shooter);
        if (profile == null) {
            return;
        }
        long experience = this.getArcheryExperience((LivingEntity)victim);
        this.plugin.getPlayerManager().addExperience(shooter, SkillType.ARCHERY, experience);
        int level = profile.getSkillLevel(SkillType.ARCHERY);
        if (profile.hasActiveAbility(SkillType.ARCHERY)) {
            event.setDamage(event.getDamage() * 2.0);
            if (victim instanceof LivingEntity) {
                ((LivingEntity)victim).setVelocity(victim.getLocation().getDirection().multiply(-2));
            }
        }
        double dazeChance = Math.min((double)level * 8.0E-4, 0.12);
        if (victim instanceof Player && this.random.nextDouble() < dazeChance) {
            this.applyDazeEffect((Player)victim);
        }
        double damageBonus = 1.0 + (double)level * 0.001;
        event.setDamage(event.getDamage() * damageBonus);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPlayerTakeDamage(EntityDamageByEntityEvent event) {
        int level;
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getEntity();
        PlayerProfile profile = this.plugin.getPlayerManager().getProfile(player);
        if (profile == null) {
            return;
        }
        if (event.getDamager() instanceof Projectile && this.isUnarmedFighting(player)) {
            level = profile.getSkillLevel(SkillType.UNARMED);
            double deflectChance = Math.min((double)level * 5.0E-4, 0.1);
            if (this.random.nextDouble() < deflectChance) {
                event.setCancelled(true);
                player.sendMessage("\u00a76\u26a1 \u00a77You deflected the arrow with your bare hands!");
            }
        }
        if (event.getDamager() instanceof LivingEntity && this.isSwordFighting(player)) {
            level = profile.getSkillLevel(SkillType.SWORDS);
            double counterChance = Math.min((double)level * 3.0E-4, 0.08);
            if (this.random.nextDouble() < counterChance) {
                LivingEntity attacker = (LivingEntity)event.getDamager();
                double counterDamage = event.getDamage() * 0.5;
                attacker.damage(counterDamage, (Entity)player);
                player.sendMessage("\u00a76\u26a1 \u00a77Counter attack!");
            }
        }
    }

    private boolean isUnarmedAttack(Material weapon) {
        return weapon == Material.AIR || weapon == null;
    }

    private boolean isSwordWeapon(Material weapon) {
        return weapon.name().contains("SWORD");
    }

    private boolean isAxeWeapon(Material weapon) {
        return weapon.name().contains("_AXE") && !weapon.name().contains("PICKAXE");
    }

    private boolean isUnarmedFighting(Player player) {
        ItemStack weapon = player.getInventory().getItemInMainHand();
        return this.isUnarmedAttack(weapon.getType());
    }

    private boolean isSwordFighting(Player player) {
        ItemStack weapon = player.getInventory().getItemInMainHand();
        return this.isSwordWeapon(weapon.getType());
    }

    private long getUnarmedExperience(LivingEntity victim) {
        if (victim instanceof Player) {
            return 80L;
        }
        switch (victim.getType()) {
            case ZOMBIE: 
            case SKELETON: 
            case SPIDER: {
                return 40L;
            }
            case CREEPER: 
            case ENDERMAN: {
                return 60L;
            }
            case BLAZE: 
            case WITHER_SKELETON: {
                return 80L;
            }
            case ENDER_DRAGON: 
            case WITHER: {
                return 500L;
            }
        }
        return 20L;
    }

    private long getSwordsExperience(LivingEntity victim) {
        return this.getUnarmedExperience(victim);
    }

    private long getAxesExperience(LivingEntity victim) {
        return this.getUnarmedExperience(victim);
    }

    private long getArcheryExperience(LivingEntity victim) {
        return this.getUnarmedExperience(victim);
    }

    private void disarmPlayer(Player player) {
        ItemStack weapon = player.getInventory().getItemInMainHand();
        if (weapon.getType() != Material.AIR) {
            player.getWorld().dropItemNaturally(player.getLocation(), weapon);
            player.getInventory().setItemInMainHand(new ItemStack(Material.AIR));
            player.sendMessage("\u00a7c\u26a1 \u00a77You have been disarmed!");
        }
    }

    private void performSerratedStrikes(Player player, LivingEntity victim, double damage) {
        victim.getNearbyEntities(3.0, 3.0, 3.0).forEach(entity -> {
            if (entity instanceof LivingEntity && entity != player && entity != victim) {
                LivingEntity target = (LivingEntity)entity;
                target.damage(damage * 0.5, (Entity)player);
            }
        });
    }

    private void performSkullSplitter(Player player, LivingEntity victim, double damage) {
        victim.getNearbyEntities(2.0, 2.0, 2.0).forEach(entity -> {
            if (entity instanceof LivingEntity && entity != player && entity != victim) {
                LivingEntity target = (LivingEntity)entity;
                target.damage(damage * 0.6, (Entity)player);
            }
        });
    }

    private void applyBleedEffect(LivingEntity victim, int level) {
        int duration = Math.min(3 + level / 100, 10);
        victim.damage(2.0 + (double)level * 0.01);
    }

    private void applyDazeEffect(Player victim) {
        victim.sendMessage("\u00a7c\u26a1 \u00a77You feel dazed from the arrow!");
    }

    private void damageArmor(Player player) {
        ItemStack[] armor;
        for (ItemStack piece : armor = player.getInventory().getArmorContents()) {
            if (piece == null || piece.getType() == Material.AIR) continue;
            piece.setDurability((short)(piece.getDurability() + 5));
            break;
        }
    }
}

