/*
 * Decompiled with CFR 0.152.
 */
package com.skillforge.listeners;

import com.skillforge.SkillForge;
import com.skillforge.models.PlayerProfile;
import com.skillforge.models.SkillType;
import java.util.Random;
import org.bukkit.Material;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerFishEvent;
import org.bukkit.inventory.ItemStack;

public class FishingListener
implements Listener {
    private final SkillForge plugin;
    private final Random random = new Random();

    public FishingListener(SkillForge plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onPlayerFish(PlayerFishEvent event) {
        if (event.getState() != PlayerFishEvent.State.CAUGHT_FISH) {
            return;
        }
        if (!(event.getCaught() instanceof Item)) {
            return;
        }
        Player player = event.getPlayer();
        PlayerProfile profile = this.plugin.getPlayerManager().getProfile(player);
        if (profile == null) {
            return;
        }
        long experience = 50L;
        this.plugin.getPlayerManager().addExperience(player, SkillType.FISHING, experience);
        int level = profile.getSkillLevel(SkillType.FISHING);
        double treasureChance = Math.min((double)level * 0.001, 0.15);
        if (this.random.nextDouble() < treasureChance) {
            this.dropFishingTreasure(player);
        }
        double magicChance = Math.min((double)level * 5.0E-4, 0.08);
        if (this.random.nextDouble() < magicChance) {
            this.dropEnchantedBook(player);
        }
    }

    private void dropFishingTreasure(Player player) {
        ItemStack[] treasures = new ItemStack[]{new ItemStack(Material.DIAMOND, 1), new ItemStack(Material.EMERALD, 1), new ItemStack(Material.GOLD_INGOT, 2), new ItemStack(Material.ENCHANTED_GOLDEN_APPLE, 1), new ItemStack(Material.NAME_TAG, 1), new ItemStack(Material.SADDLE, 1)};
        ItemStack treasure = treasures[this.random.nextInt(treasures.length)];
        player.getWorld().dropItemNaturally(player.getLocation(), treasure);
        player.sendMessage("\u00a76\u26a1 \u00a77You caught a treasure: \u00a7e" + treasure.getType().name() + "\u00a77!");
    }

    private void dropEnchantedBook(Player player) {
        ItemStack book = new ItemStack(Material.ENCHANTED_BOOK, 1);
        player.getWorld().dropItemNaturally(player.getLocation(), book);
        player.sendMessage("\u00a76\u26a1 \u00a77You caught an enchanted book!");
    }
}

