/*
 * Decompiled with CFR 0.152.
 */
package com.skillforge.listeners;

import com.skillforge.SkillForge;
import com.skillforge.models.PlayerProfile;
import com.skillforge.models.SkillType;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.Wolf;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityBreedEvent;
import org.bukkit.event.entity.EntityTameEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;

public class TamingListener
implements Listener {
    private final SkillForge plugin;

    public TamingListener(SkillForge plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onEntityTame(EntityTameEvent event) {
        if (!(event.getOwner() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getOwner();
        PlayerProfile profile = this.plugin.getPlayerManager().getProfile(player);
        if (profile == null) {
            return;
        }
        long experience = this.getTamingExperience(event.getEntity().getType());
        this.plugin.getPlayerManager().addExperience(player, SkillType.TAMING, experience);
    }

    @EventHandler
    public void onEntityBreed(EntityBreedEvent event) {
        if (!(event.getBreeder() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getBreeder();
        PlayerProfile profile = this.plugin.getPlayerManager().getProfile(player);
        if (profile == null) {
            return;
        }
        long experience = this.getBreedingExperience(event.getEntity().getType());
        this.plugin.getPlayerManager().addExperience(player, SkillType.TAMING, experience);
    }

    @EventHandler
    public void onPlayerInteractEntity(PlayerInteractEntityEvent event) {
        Player player = event.getPlayer();
        PlayerProfile profile = this.plugin.getPlayerManager().getProfile(player);
        if (profile == null) {
            return;
        }
        if (profile.getSkillLevel(SkillType.TAMING) >= 100 && event.getRightClicked() instanceof Wolf) {
            Wolf wolf = (Wolf)event.getRightClicked();
            this.showBeastLore(player, wolf);
        }
    }

    private long getTamingExperience(EntityType entityType) {
        switch (entityType) {
            case WOLF: {
                return 100L;
            }
            case CAT: {
                return 80L;
            }
            case HORSE: {
                return 150L;
            }
            case PARROT: {
                return 60L;
            }
        }
        return 50L;
    }

    private long getBreedingExperience(EntityType entityType) {
        return this.getTamingExperience(entityType) / 2L;
    }

    private void showBeastLore(Player player, Wolf wolf) {
        player.sendMessage("\u00a76\u2550\u2550\u2550 \u00a7eBeast Lore \u00a76\u2550\u2550\u2550");
        player.sendMessage("\u00a77Health: \u00a7f" + wolf.getHealth() + "/" + wolf.getMaxHealth());
        player.sendMessage("\u00a77Owner: \u00a7f" + (wolf.getOwner() != null ? wolf.getOwner().getName() : "Wild"));
        player.sendMessage("\u00a77Sitting: \u00a7f" + wolf.isSitting());
        player.sendMessage("\u00a76\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550");
    }
}

