/*
 * Decompiled with CFR 0.152.
 */
package com.skillforge.managers;

import com.skillforge.SkillForge;
import java.io.File;
import java.io.IOException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class ConfigManager {
    private final SkillForge plugin;
    private FileConfiguration skillsConfig;
    private File skillsConfigFile;

    public ConfigManager(SkillForge plugin) {
        this.plugin = plugin;
        this.setupConfigs();
    }

    private void setupConfigs() {
        this.plugin.saveDefaultConfig();
        this.skillsConfigFile = new File(this.plugin.getDataFolder(), "skills.yml");
        if (!this.skillsConfigFile.exists()) {
            this.plugin.saveResource("skills.yml", false);
        }
        this.skillsConfig = YamlConfiguration.loadConfiguration((File)this.skillsConfigFile);
    }

    public FileConfiguration getSkillsConfig() {
        return this.skillsConfig;
    }

    public void reloadConfigs() {
        this.plugin.reloadConfig();
        this.skillsConfig = YamlConfiguration.loadConfiguration((File)this.skillsConfigFile);
    }

    public void saveSkillsConfig() {
        try {
            this.skillsConfig.save(this.skillsConfigFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Could not save skills.yml: " + e.getMessage());
        }
    }
}

