/*
 * Decompiled with CFR 0.152.
 */
package com.skillforge.managers;

import com.skillforge.SkillForge;
import com.skillforge.models.PlayerProfile;
import com.skillforge.models.SkillType;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.entity.Player;

public class PartyManager {
    private final SkillForge plugin;
    private final Map<UUID, Set<UUID>> parties;
    private final Map<UUID, UUID> partyLeaders;

    public PartyManager(SkillForge plugin) {
        this.plugin = plugin;
        this.parties = new ConcurrentHashMap<UUID, Set<UUID>>();
        this.partyLeaders = new ConcurrentHashMap<UUID, UUID>();
    }

    public UUID createParty(Player leader) {
        UUID partyId = UUID.randomUUID();
        HashSet<UUID> members = new HashSet<UUID>();
        members.add(leader.getUniqueId());
        this.parties.put(partyId, members);
        this.partyLeaders.put(partyId, leader.getUniqueId());
        PlayerProfile profile = this.plugin.getPlayerManager().getProfile(leader);
        if (profile != null) {
            profile.setPartyId(partyId);
        }
        return partyId;
    }

    public boolean invitePlayer(UUID partyId, Player invitee) {
        Set<UUID> members = this.parties.get(partyId);
        if (members == null || members.size() >= 6) {
            return false;
        }
        members.add(invitee.getUniqueId());
        PlayerProfile profile = this.plugin.getPlayerManager().getProfile(invitee);
        if (profile != null) {
            profile.setPartyId(partyId);
        }
        return true;
    }

    public void leaveParty(Player player) {
        PlayerProfile profile = this.plugin.getPlayerManager().getProfile(player);
        if (profile == null || !profile.hasParty()) {
            return;
        }
        UUID partyId = profile.getPartyId();
        Set<UUID> members = this.parties.get(partyId);
        if (members != null) {
            members.remove(player.getUniqueId());
            if (members.isEmpty()) {
                this.parties.remove(partyId);
                this.partyLeaders.remove(partyId);
            } else if (this.partyLeaders.get(partyId).equals(player.getUniqueId())) {
                UUID newLeader = members.iterator().next();
                this.partyLeaders.put(partyId, newLeader);
            }
        }
        profile.setPartyId(null);
    }

    public void shareExperience(Player player, SkillType skill, long experience) {
        PlayerProfile profile = this.plugin.getPlayerManager().getProfile(player);
        if (profile == null || !profile.hasParty()) {
            return;
        }
        UUID partyId = profile.getPartyId();
        Set<UUID> members = this.parties.get(partyId);
        if (members == null) {
            return;
        }
        double maxDistance = this.plugin.getConfig().getDouble("general.party-max-distance", 75.0);
        long sharedExp = experience / 4L;
        for (UUID memberId : members) {
            Player member;
            if (memberId.equals(player.getUniqueId()) || (member = this.plugin.getServer().getPlayer(memberId)) == null || !member.isOnline() || player.getLocation().distance(member.getLocation()) > maxDistance) continue;
            this.plugin.getPlayerManager().addExperience(member, skill, sharedExp);
        }
    }

    public Set<UUID> getPartyMembers(UUID partyId) {
        return this.parties.getOrDefault(partyId, new HashSet());
    }

    public boolean isPartyLeader(Player player, UUID partyId) {
        UUID leaderId = this.partyLeaders.get(partyId);
        return leaderId != null && leaderId.equals(player.getUniqueId());
    }
}

