/*
 * Decompiled with CFR 0.152.
 */
package com.skillforge.managers;

import com.skillforge.SkillForge;
import com.skillforge.models.PlayerProfile;
import com.skillforge.models.SkillType;
import com.skillforge.utils.ExperienceUtils;
import com.skillforge.utils.MessageUtils;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Sound;
import org.bukkit.entity.Player;

public class PlayerManager {
    private final SkillForge plugin;
    private final Map<UUID, PlayerProfile> profiles;

    public PlayerManager(SkillForge plugin) {
        this.plugin = plugin;
        this.profiles = new ConcurrentHashMap<UUID, PlayerProfile>();
    }

    public PlayerProfile getProfile(UUID playerId) {
        return this.profiles.get(playerId);
    }

    public PlayerProfile getProfile(Player player) {
        return this.getProfile(player.getUniqueId());
    }

    public void loadProfile(Player player) {
        UUID playerId = player.getUniqueId();
        PlayerProfile profile = this.plugin.getDatabaseManager().loadPlayerProfile(playerId, player.getName());
        this.profiles.put(playerId, profile);
    }

    public void saveProfile(Player player) {
        PlayerProfile profile = this.getProfile(player);
        if (profile != null) {
            this.plugin.getDatabaseManager().savePlayerProfile(profile);
        }
    }

    public void unloadProfile(UUID playerId) {
        this.profiles.remove(playerId);
    }

    public void addExperience(Player player, SkillType skill, long experience) {
        PlayerProfile profile = this.getProfile(player);
        if (profile == null) {
            return;
        }
        int oldLevel = profile.getSkillLevel(skill);
        profile.addSkillExperience(skill, experience);
        int newLevel = ExperienceUtils.getLevel(profile.getSkillExperience(skill));
        if (newLevel > oldLevel) {
            profile.setSkillLevel(skill, newLevel);
            this.handleLevelUp(player, skill, newLevel);
        }
        MessageUtils.sendExperienceMessage(player, skill, experience);
        player.playSound(player.getLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 0.5f, 2.0f);
    }

    private void handleLevelUp(Player player, SkillType skill, int newLevel) {
        MessageUtils.sendLevelUpMessage(player, skill, newLevel);
        player.playSound(player.getLocation(), Sound.ENTITY_PLAYER_LEVELUP, 1.0f, 1.0f);
        this.plugin.getSkillManager().checkForNewAbilities(player, skill, newLevel);
        if (this.getProfile(player).hasParty()) {
            this.plugin.getPartyManager().shareExperience(player, skill, newLevel * 10);
        }
    }
}

