/*
 * Decompiled with CFR 0.152.
 */
package com.skillforge.managers;

import com.skillforge.SkillForge;
import com.skillforge.models.PlayerProfile;
import com.skillforge.models.SkillType;
import com.skillforge.utils.MessageUtils;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class SkillManager {
    private final SkillForge plugin;
    private final Map<SkillType, Map<String, Object>> skillConfigs;

    public SkillManager(SkillForge plugin) {
        this.plugin = plugin;
        this.skillConfigs = new HashMap<SkillType, Map<String, Object>>();
        this.loadSkillConfigs();
    }

    private void loadSkillConfigs() {
        for (SkillType skill : SkillType.values()) {
            String path = "skills." + skill.name().toLowerCase();
            if (!this.plugin.getConfigManager().getSkillsConfig().contains(path)) continue;
            this.skillConfigs.put(skill, this.plugin.getConfigManager().getSkillsConfig().getConfigurationSection(path).getValues(true));
        }
    }

    public boolean isSkillEnabled(SkillType skill) {
        return ((Map)this.skillConfigs.getOrDefault((Object)skill, new HashMap())).getOrDefault("enabled", true);
    }

    public void checkForNewAbilities(Player player, SkillType skill, int level) {
        Map<String, Object> config = this.skillConfigs.get((Object)skill);
        if (config == null || !config.containsKey("abilities")) {
            return;
        }
        Map abilities = (Map)config.get("abilities");
        for (String abilityName : abilities.keySet()) {
            Map abilityConfig = (Map)abilities.get(abilityName);
            int unlockLevel = abilityConfig.getOrDefault("unlock-level", 50);
            if (level != unlockLevel) continue;
            MessageUtils.sendAbilityUnlockedMessage(player, skill, abilityName);
            player.playSound(player.getLocation(), Sound.BLOCK_NOTE_BLOCK_CHIME, 1.0f, 2.0f);
        }
    }

    public boolean canUseAbility(Player player, SkillType skill, String abilityName) {
        PlayerProfile profile = this.plugin.getPlayerManager().getProfile(player);
        if (profile == null) {
            return false;
        }
        if (profile.isAbilityOnCooldown(skill)) {
            return false;
        }
        if (profile.hasActiveAbility(skill)) {
            return false;
        }
        Map<String, Object> config = this.skillConfigs.get((Object)skill);
        if (config == null) {
            return false;
        }
        Map abilities = (Map)config.get("abilities");
        if (abilities == null || !abilities.containsKey(abilityName)) {
            return false;
        }
        Map abilityConfig = (Map)abilities.get(abilityName);
        int unlockLevel = abilityConfig.getOrDefault("unlock-level", 50);
        return profile.getSkillLevel(skill) >= unlockLevel;
    }

    public void activateAbility(Player player, final SkillType skill, String abilityName) {
        final PlayerProfile profile = this.plugin.getPlayerManager().getProfile(player);
        if (profile == null) {
            return;
        }
        Map<String, Object> config = this.skillConfigs.get((Object)skill);
        if (config == null) {
            return;
        }
        Map abilities = (Map)config.get("abilities");
        Map abilityConfig = (Map)abilities.get(abilityName);
        int duration = abilityConfig.getOrDefault("duration", 30);
        int cooldown = abilityConfig.getOrDefault("cooldown", 240);
        profile.activateAbility(skill);
        profile.setAbilityCooldown(skill, cooldown);
        MessageUtils.sendAbilityActivatedMessage(player, abilityName, duration);
        player.playSound(player.getLocation(), Sound.ENTITY_ENDER_DRAGON_GROWL, 0.8f, 1.2f);
        new BukkitRunnable(){

            public void run() {
                profile.deactivateAbility(skill);
            }
        }.runTaskLater((Plugin)this.plugin, (long)duration * 20L);
    }

    public double getExperienceMultiplier(SkillType skill) {
        Map<String, Object> config = this.skillConfigs.get((Object)skill);
        if (config == null) {
            return 1.0;
        }
        return (Double)config.getOrDefault("experience-multiplier", 1.0);
    }
}

